/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.amoro.metrics.MetricDefine;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class MetricKey {
    private final MetricDefine define;
    private final Map<String, String> valueOfTags;

    public MetricKey(MetricDefine define, Map<String, String> tagValues) {
        Preconditions.checkNotNull((Object)define);
        Object object = this.valueOfTags = tagValues == null ? ImmutableMap.of() : tagValues;
        if (define.getTags().size() != this.valueOfTags.size()) {
            throw new IllegalArgumentException("Tag value is miss-match with metric define. MetricDefine{" + define + "} given tags:" + Joiner.on((String)",").join(this.valueOfTags.keySet().stream().sorted().iterator()));
        }
        define.getTags().forEach(t -> Preconditions.checkArgument((boolean)this.valueOfTags.containsKey(t), (String)"The value of tag: %s is missed", (Object)t));
        this.define = define;
    }

    public MetricDefine getDefine() {
        return this.define;
    }

    public String valueOfTag(String tag) {
        return this.valueOfTags.getOrDefault(tag, "");
    }

    public List<String> valueOfTags() {
        ArrayList valueOfTags = Lists.newArrayList();
        this.getDefine().getTags().forEach(t -> valueOfTags.add(this.valueOfTag((String)t)));
        return Collections.unmodifiableList(valueOfTags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricKey that = (MetricKey)o;
        return Objects.equals(this.define, that.define) && Objects.equals(this.valueOfTags, that.valueOfTags);
    }

    public int hashCode() {
        return Objects.hash(this.define, this.valueOfTags);
    }

    public String toString() {
        String desc = this.define.getName() + ":" + this.define.getType().name();
        if (!this.define.getTags().isEmpty()) {
            String tagDesc = this.define.getTags().stream().map(t -> t + "=" + this.valueOfTag((String)t)).collect(Collectors.joining(","));
            desc = "<" + tagDesc + ">";
        }
        return desc;
    }
}

