/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.config;

import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OptimizingConfig {
    private boolean enabled;
    private double targetQuota;
    private String optimizerGroup;
    private int maxExecuteRetryCount;
    private int maxCommitRetryCount;
    private long targetSize;
    private long maxTaskSize;
    private int maxFileCount;
    private long openFileCost;
    private int fragmentRatio;
    private double minTargetSizeRatio;
    private int minorLeastFileCount;
    private int minorLeastInterval;
    private double majorDuplicateRatio;
    private int fullTriggerInterval;
    private boolean fullRewriteAllFiles;
    private String filter;
    private int baseHashBucket;
    private long baseRefreshInterval;
    private long hiveRefreshInterval;
    private long minPlanInterval;

    public boolean isEnabled() {
        return this.enabled;
    }

    public OptimizingConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public double getTargetQuota() {
        return this.targetQuota;
    }

    public OptimizingConfig setTargetQuota(double targetQuota) {
        this.targetQuota = targetQuota;
        return this;
    }

    public long getMinPlanInterval() {
        return this.minPlanInterval;
    }

    public OptimizingConfig setMinPlanInterval(long minPlanInterval) {
        this.minPlanInterval = minPlanInterval;
        return this;
    }

    public String getOptimizerGroup() {
        return this.optimizerGroup;
    }

    public OptimizingConfig setOptimizerGroup(String optimizerGroup) {
        this.optimizerGroup = optimizerGroup;
        return this;
    }

    public int getMaxExecuteRetryCount() {
        return this.maxExecuteRetryCount;
    }

    public OptimizingConfig setMaxExecuteRetryCount(int maxExecuteRetryCount) {
        this.maxExecuteRetryCount = maxExecuteRetryCount;
        return this;
    }

    public long getTargetSize() {
        return this.targetSize;
    }

    public OptimizingConfig setTargetSize(long targetSize) {
        this.targetSize = targetSize;
        return this;
    }

    public long getMaxTaskSize() {
        return this.maxTaskSize;
    }

    public OptimizingConfig setMaxTaskSize(long maxTaskSize) {
        this.maxTaskSize = maxTaskSize;
        return this;
    }

    public int getMaxFileCount() {
        return this.maxFileCount;
    }

    public OptimizingConfig setMaxFileCount(int maxFileCount) {
        this.maxFileCount = maxFileCount;
        return this;
    }

    public long getOpenFileCost() {
        return this.openFileCost;
    }

    public OptimizingConfig setOpenFileCost(long openFileCost) {
        this.openFileCost = openFileCost;
        return this;
    }

    public int getFragmentRatio() {
        return this.fragmentRatio;
    }

    public OptimizingConfig setFragmentRatio(int fragmentRatio) {
        this.fragmentRatio = fragmentRatio;
        return this;
    }

    public double getMinTargetSizeRatio() {
        return this.minTargetSizeRatio;
    }

    public OptimizingConfig setMinTargetSizeRatio(double minTargetSizeRatio) {
        this.minTargetSizeRatio = minTargetSizeRatio;
        return this;
    }

    public long maxFragmentSize() {
        return this.targetSize / (long)this.fragmentRatio;
    }

    public long maxDuplicateSize() {
        return (long)((double)this.maxFragmentSize() * this.majorDuplicateRatio);
    }

    public int getMinorLeastFileCount() {
        return this.minorLeastFileCount;
    }

    public OptimizingConfig setMinorLeastFileCount(int minorLeastFileCount) {
        this.minorLeastFileCount = minorLeastFileCount;
        return this;
    }

    public int getMinorLeastInterval() {
        return this.minorLeastInterval;
    }

    public OptimizingConfig setMinorLeastInterval(int minorLeastInterval) {
        this.minorLeastInterval = minorLeastInterval;
        return this;
    }

    public double getMajorDuplicateRatio() {
        return this.majorDuplicateRatio;
    }

    public OptimizingConfig setMajorDuplicateRatio(double majorDuplicateRatio) {
        this.majorDuplicateRatio = majorDuplicateRatio;
        return this;
    }

    public int getFullTriggerInterval() {
        return this.fullTriggerInterval;
    }

    public OptimizingConfig setFullTriggerInterval(int fullTriggerInterval) {
        this.fullTriggerInterval = fullTriggerInterval;
        return this;
    }

    public boolean isFullRewriteAllFiles() {
        return this.fullRewriteAllFiles;
    }

    public OptimizingConfig setFullRewriteAllFiles(boolean fullRewriteAllFiles) {
        this.fullRewriteAllFiles = fullRewriteAllFiles;
        return this;
    }

    public OptimizingConfig setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getBaseHashBucket() {
        return this.baseHashBucket;
    }

    public OptimizingConfig setBaseHashBucket(int baseHashBucket) {
        this.baseHashBucket = baseHashBucket;
        return this;
    }

    public long getBaseRefreshInterval() {
        return this.baseRefreshInterval;
    }

    public OptimizingConfig setBaseRefreshInterval(long baseRefreshInterval) {
        this.baseRefreshInterval = baseRefreshInterval;
        return this;
    }

    public long getHiveRefreshInterval() {
        return this.hiveRefreshInterval;
    }

    public OptimizingConfig setHiveRefreshInterval(long hiveRefreshInterval) {
        this.hiveRefreshInterval = hiveRefreshInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizingConfig that = (OptimizingConfig)o;
        return this.enabled == that.enabled && Double.compare(that.targetQuota, this.targetQuota) == 0 && this.maxExecuteRetryCount == that.maxExecuteRetryCount && this.maxCommitRetryCount == that.maxCommitRetryCount && this.targetSize == that.targetSize && this.maxTaskSize == that.maxTaskSize && this.maxFileCount == that.maxFileCount && this.openFileCost == that.openFileCost && this.fragmentRatio == that.fragmentRatio && Double.compare(this.minTargetSizeRatio, that.minTargetSizeRatio) == 0 && this.minorLeastFileCount == that.minorLeastFileCount && this.minorLeastInterval == that.minorLeastInterval && Double.compare(that.majorDuplicateRatio, this.majorDuplicateRatio) == 0 && this.fullTriggerInterval == that.fullTriggerInterval && this.fullRewriteAllFiles == that.fullRewriteAllFiles && Objects.equal((Object)this.filter, (Object)that.filter) && this.baseHashBucket == that.baseHashBucket && this.baseRefreshInterval == that.baseRefreshInterval && this.hiveRefreshInterval == that.hiveRefreshInterval && Objects.equal((Object)this.optimizerGroup, (Object)that.optimizerGroup) && Objects.equal((Object)this.minPlanInterval, (Object)that.minPlanInterval);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.targetQuota, this.optimizerGroup, this.maxExecuteRetryCount, this.maxCommitRetryCount, this.targetSize, this.maxTaskSize, this.maxFileCount, this.openFileCost, this.fragmentRatio, this.minTargetSizeRatio, this.minorLeastFileCount, this.minorLeastInterval, this.majorDuplicateRatio, this.fullTriggerInterval, this.fullRewriteAllFiles, this.filter, this.baseHashBucket, this.baseRefreshInterval, this.hiveRefreshInterval, this.minPlanInterval});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("targetQuota", this.targetQuota).add("optimizerGroup", (Object)this.optimizerGroup).add("maxExecuteRetryCount", this.maxExecuteRetryCount).add("maxCommitRetryCount", this.maxCommitRetryCount).add("targetSize", this.targetSize).add("maxTaskSize", this.maxTaskSize).add("maxFileCount", this.maxFileCount).add("openFileCost", this.openFileCost).add("fragmentRatio", this.fragmentRatio).add("minorLeastFileCount", this.minorLeastFileCount).add("minorLeastInterval", this.minorLeastInterval).add("majorDuplicateRatio", this.majorDuplicateRatio).add("fullTriggerInterval", this.fullTriggerInterval).add("fullRewriteAllFiles", this.fullRewriteAllFiles).add("filter", (Object)this.filter).add("baseHashBucket", this.baseHashBucket).add("baseRefreshInterval", this.baseRefreshInterval).add("hiveRefreshInterval", this.hiveRefreshInterval).toString();
    }
}

