/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.amoro.CommonUnifiedCatalog;
import org.apache.amoro.PooledAmsClient;
import org.apache.amoro.UnifiedCatalog;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.NoSuchObjectException;

public class UnifiedCatalogLoader {
    public static UnifiedCatalog loadUnifiedCatalog(String amsUri, String catalogName, Map<String, String> props) {
        PooledAmsClient client = new PooledAmsClient(amsUri);
        Supplier<CatalogMeta> metaSupplier = () -> {
            try {
                CatalogMeta meta = client.getCatalog(catalogName);
                meta.putToCatalogProperties("ams.uri", amsUri);
                return meta;
            }
            catch (NoSuchObjectException e) {
                throw new IllegalStateException("catalog not found, please check catalog name:" + catalogName, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new IllegalStateException("failed when load catalog " + catalogName, e);
            }
        };
        return new CommonUnifiedCatalog(metaSupplier, props);
    }
}

