/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.SerializerProvider;

public final class TableFormat
implements Serializable {
    private static final Map<String, TableFormat> registeredFormats = Maps.newConcurrentMap();
    public static final TableFormat ICEBERG = TableFormat.register("ICEBERG");
    public static final TableFormat MIXED_ICEBERG = TableFormat.register("MIXED_ICEBERG");
    public static final TableFormat MIXED_HIVE = TableFormat.register("MIXED_HIVE");
    public static final TableFormat PAIMON = TableFormat.register("PAIMON");
    public static final TableFormat HUDI = TableFormat.register("HUDI");
    private final String name;

    public static TableFormat[] values() {
        return registeredFormats.values().toArray(new TableFormat[0]);
    }

    public static TableFormat register(String name) {
        return registeredFormats.computeIfAbsent(name, s -> new TableFormat(name));
    }

    public static TableFormat valueOf(String name) {
        return registeredFormats.get(name);
    }

    private TableFormat(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"TableFormat name should not be null");
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public boolean in(TableFormat ... tableFormats) {
        for (TableFormat tableFormat : tableFormats) {
            if (!this.equals(tableFormat)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.name.equals(((TableFormat)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class JsonSerializer
    extends org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonSerializer<TableFormat> {
        public void serialize(TableFormat tableFormat, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(tableFormat.name());
        }
    }

    public static class JsonDeserializer
    extends org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonDeserializer<TableFormat> {
        public TableFormat deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            TreeNode node = jsonParser.getCodec().readTree(jsonParser);
            return TableFormat.valueOf(node.toString());
        }
    }
}

