/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.Blocker;
import org.apache.amoro.api.TableIdentifier;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.exception.AlreadyExistsException;
import org.apache.amoro.exception.BlockerConflictException;
import org.apache.amoro.exception.IllegalMetadataException;
import org.apache.amoro.exception.ObjectNotExistsException;
import org.apache.amoro.exception.PersistenceException;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.CatalogManager;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.dashboard.model.TableOptimizingInfo;
import org.apache.amoro.server.dashboard.utils.OptimizingUtil;
import org.apache.amoro.server.optimizing.OptimizingTaskMeta;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.TableRuntimeMeta;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.blocker.TableBlocker;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableManager
extends PersistentBase
implements TableManager {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultTableManager.class);
    private static final int TABLE_BLOCKER_RETRY = 3;
    private final long blockerTimeout;
    private final CatalogManager catalogManager;
    @Nullable
    private TableService tableService;

    public DefaultTableManager(Configurations configuration, CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.blockerTimeout = ((Duration)configuration.get(AmoroManagementConf.BLOCKER_TIMEOUT)).toMillis();
    }

    @Override
    public void setTableService(@Nullable TableService tableService) {
        this.tableService = tableService;
    }

    private Optional<TableService> tableService() {
        return Optional.ofNullable(this.tableService);
    }

    @Override
    public void dropTableMetadata(TableIdentifier tableIdentifier, boolean deleteData) {
        String table;
        String database;
        if (StringUtils.isBlank((String)tableIdentifier.getTableName())) {
            throw new IllegalMetadataException("table name is blank");
        }
        if (StringUtils.isBlank((String)tableIdentifier.getCatalog())) {
            throw new IllegalMetadataException("catalog is blank");
        }
        if (StringUtils.isBlank((String)tableIdentifier.getDatabase())) {
            throw new IllegalMetadataException("database is blank");
        }
        InternalCatalog internalCatalog = this.catalogManager.getInternalCatalog(tableIdentifier.getCatalog());
        if (!internalCatalog.tableExists(database = tableIdentifier.getDatabase(), table = tableIdentifier.getTableName())) {
            throw new ObjectNotExistsException(tableIdentifier);
        }
        ServerTableIdentifier serverTableIdentifier = internalCatalog.dropTable(database, table);
        this.tableService().ifPresent(s -> s.onTableDropped(internalCatalog, serverTableIdentifier));
    }

    @Override
    public void createTable(String catalogName, TableMetadata tableMetadata) {
        String table;
        String database;
        InternalCatalog catalog = this.catalogManager.getInternalCatalog(catalogName);
        if (catalog.tableExists(database = tableMetadata.getTableIdentifier().getDatabase(), table = tableMetadata.getTableIdentifier().getTableName())) {
            throw new AlreadyExistsException(tableMetadata.getTableIdentifier().getIdentifier().buildTableIdentifier());
        }
        TableMetadata metadata = catalog.createTable(tableMetadata);
        this.tableService().ifPresent(s -> s.onTableCreated(catalog, metadata.getTableIdentifier()));
    }

    @Override
    public List<ServerTableIdentifier> listManagedTables() {
        return this.getAs(TableMetaMapper.class, TableMetaMapper::selectAllTableIdentifiers);
    }

    @Override
    public Blocker block(TableIdentifier tableIdentifier, List<BlockableOperation> operations, Map<String, String> properties) {
        Preconditions.checkNotNull(operations, (Object)"operations should not be null");
        Preconditions.checkArgument((!operations.isEmpty() ? 1 : 0) != 0, (Object)"operations should not be empty");
        Preconditions.checkArgument((this.blockerTimeout > 0L ? 1 : 0) != 0, (Object)"blocker timeout must > 0");
        String catalog = tableIdentifier.getCatalog();
        String database = tableIdentifier.getDatabase();
        String table = tableIdentifier.getTableName();
        int tryCount = 0;
        while (tryCount++ < 3) {
            long now = System.currentTimeMillis();
            this.doAs(TableBlockerMapper.class, mapper -> mapper.deleteExpiredBlockers(catalog, database, table, now));
            List tableBlockers = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlockers(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName(), now));
            if (TableBlocker.conflict(operations, (List<TableBlocker>)tableBlockers)) {
                throw new BlockerConflictException(operations + " is conflict with " + tableBlockers);
            }
            Optional<Long> maxBlockerOpt = tableBlockers.stream().map(TableBlocker::getBlockerId).max(Comparator.comparingLong(l -> l));
            long prevBlockerId = maxBlockerOpt.orElse(-1L);
            TableBlocker tableBlocker = TableBlocker.buildTableBlocker(tableIdentifier, operations, properties, now, this.blockerTimeout, prevBlockerId);
            try {
                this.doAs(TableBlockerMapper.class, mapper -> mapper.insert(tableBlocker));
                if (tableBlocker.getBlockerId() <= 0L) continue;
                return tableBlocker.buildBlocker();
            }
            catch (PersistenceException e) {
                LOG.warn("An exception occurs when creating a blocker:{}", (Object)tableBlocker, (Object)e);
            }
        }
        throw new BlockerConflictException("Failed to create a blocker: conflict meet max retry");
    }

    @Override
    public void releaseBlocker(TableIdentifier tableIdentifier, String blockerId) {
        this.doAs(TableBlockerMapper.class, mapper -> mapper.deleteBlocker(Long.parseLong(blockerId)));
    }

    @Override
    public long renewBlocker(TableIdentifier tableIdentifier, String blockerId) {
        int retry = 0;
        while (retry++ < 3) {
            long expirationTime;
            long now = System.currentTimeMillis();
            long id = Long.parseLong(blockerId);
            TableBlocker tableBlocker = this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlocker(id, now));
            if (tableBlocker == null) {
                throw new ObjectNotExistsException("Blocker " + blockerId + " of " + tableIdentifier);
            }
            long current = System.currentTimeMillis();
            long effectRow = this.updateAs(TableBlockerMapper.class, arg_0 -> DefaultTableManager.lambda$renewBlocker$8(id, current, expirationTime = now + this.blockerTimeout, arg_0));
            if (effectRow <= 0L) continue;
            return expirationTime;
        }
        throw new BlockerConflictException("Failed to renew a blocker: conflict meet max retry");
    }

    @Override
    public List<Blocker> getBlockers(TableIdentifier tableIdentifier) {
        return this.getAs(TableBlockerMapper.class, mapper -> mapper.selectBlockers(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName(), System.currentTimeMillis())).stream().map(TableBlocker::buildBlocker).collect(Collectors.toList());
    }

    @Override
    public ServerTableIdentifier getServerTableIdentifier(TableIdentifier id) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifier(id.getCatalog(), id.getDatabase(), id.getTableName()));
    }

    @Override
    public TableRuntimeMeta getTableRuntimeMata(ServerTableIdentifier id) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.getTableRuntimeMeta(id.getId()));
    }

    @Override
    public Pair<List<TableOptimizingInfo>, Integer> queryTableOptimizingInfo(String optimizerGroup, @Nullable String fuzzyDbName, @Nullable String fuzzyTableName, @Nullable List<Integer> statusCodeFilters, int limit, int offset) {
        List ret;
        int pageNumber = offset / limit + 1;
        int total = 0;
        try (Page ignore = PageHelper.startPage((int)pageNumber, (int)limit, (boolean)true);){
            ret = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableRuntimesForOptimizerGroup(optimizerGroup, fuzzyDbName, fuzzyTableName, statusCodeFilters));
            PageInfo pageInfo = new PageInfo(ret);
            total = (int)pageInfo.getTotal();
        }
        List processIds = ret.stream().map(TableRuntimeMeta::getOptimizingProcessId).filter(i -> i != -1L).collect(Collectors.toList());
        List<Long> tableIds = ret.stream().map(TableRuntimeMeta::getTableId).collect(Collectors.toList());
        List taskMetas = this.getAs(OptimizingMapper.class, m -> {
            if (processIds.isEmpty()) {
                return Lists.newArrayList();
            }
            return m.selectOptimizeTaskMetas(processIds);
        });
        Map tableTaskMetaMap = taskMetas.stream().collect(Collectors.groupingBy(OptimizingTaskMeta::getTableId, Collectors.toList()));
        Map<Long, List<TaskRuntime.TaskQuota>> tableQuotaMap = this.getQuotaTime(tableIds);
        List infos = ret.stream().map(meta -> {
            List tasks = (List)tableTaskMetaMap.get(meta.getTableId());
            List quotas = (List)tableQuotaMap.get(meta.getTableId());
            return OptimizingUtil.buildTableOptimizeInfo(meta, tasks, quotas);
        }).collect(Collectors.toList());
        return Pair.of(infos, (Object)total);
    }

    private Map<Long, List<TaskRuntime.TaskQuota>> getQuotaTime(List<Long> tableIds) {
        if (tableIds == null || tableIds.isEmpty()) {
            return Maps.newHashMap();
        }
        long calculatingEndTime = System.currentTimeMillis();
        long calculatingStartTime = calculatingEndTime - 3600000L;
        List quotas = this.getAs(OptimizingMapper.class, mapper -> mapper.selectTableQuotas(tableIds, calculatingStartTime));
        return quotas.stream().collect(Collectors.groupingBy(TaskRuntime.TaskQuota::getTableId, Collectors.toList()));
    }

    private static /* synthetic */ Number lambda$renewBlocker$8(long id, long current, long expirationTime, TableBlockerMapper mapper) {
        return mapper.renewBlocker(id, current, expirationTime);
    }
}

