/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.resource.ResourceGroup;
import org.apache.amoro.resource.ResourceType;
import org.apache.amoro.server.DefaultOptimizingService;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.server.resource.ContainerMetadata;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.amoro.server.resource.OptimizerManager;
import org.apache.amoro.server.resource.ResourceContainers;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class OptimizerController {
    private final OptimizerManager optimizerManager;
    private final DefaultOptimizingService optimizingService;

    public OptimizerController(DefaultOptimizingService optimizingService, OptimizerManager optimizerManager) {
        this.optimizingService = optimizingService;
        this.optimizerManager = optimizerManager;
    }

    public void releaseOptimizer(Context ctx) {
        String resourceId = ctx.pathParam("jobId");
        Preconditions.checkArgument((!resourceId.isEmpty() ? 1 : 0) != 0, (Object)"resource id can not be empty, maybe it's a external optimizer");
        List optimizerInstances = this.optimizerManager.listOptimizers().stream().filter(e -> resourceId.equals(e.getResourceId())).collect(Collectors.toList());
        Preconditions.checkState((!optimizerInstances.isEmpty() ? 1 : 0) != 0, (Object)String.format("The resource ID %s has not been indexed to any optimizer.", resourceId));
        Resource resource = this.optimizerManager.getResource(resourceId);
        resource.getProperties().putAll(((OptimizerInstance)((Object)optimizerInstances.get(0))).getProperties());
        ResourceContainers.get(resource.getContainerName()).releaseOptimizer(resource);
        this.optimizerManager.deleteResource(resourceId);
        this.optimizerManager.deleteOptimizer(resource.getGroupName(), resourceId);
        ctx.json(OkResponse.of("Success to release optimizer"));
    }

    public void createOptimizer(Context ctx) {
        Map map = (Map)ctx.bodyAsClass(Map.class);
        int parallelism = Integer.parseInt(map.get("parallelism").toString());
        String optimizerGroup = map.get("optimizerGroup").toString();
        ResourceGroup resourceGroup = this.optimizerManager.getResourceGroup(optimizerGroup);
        Resource resource = new Resource.Builder(resourceGroup.getContainer(), resourceGroup.getName(), ResourceType.OPTIMIZER).setProperties(resourceGroup.getProperties()).setThreadCount(parallelism).build();
        ResourceContainers.get(resource.getContainerName()).requestResource(resource);
        this.optimizerManager.createResource(resource);
        ctx.json(OkResponse.of("success to create optimizer"));
    }

    public void getContainers(Context ctx) {
        ctx.json(OkResponse.of(ResourceContainers.getMetadataList().stream().map(ContainerMetadata::getName).collect(Collectors.toList())));
    }
}

