/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CommitMetaProducer;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.op.SnapshotSummary;
import org.apache.amoro.optimizing.MetricsSummary;
import org.apache.amoro.optimizing.OptimizingType;
import org.apache.amoro.process.ProcessStatus;
import org.apache.amoro.process.ProcessTaskStatus;
import org.apache.amoro.server.dashboard.component.reverser.IcebergTableMetaExtract;
import org.apache.amoro.server.dashboard.model.TableBasicInfo;
import org.apache.amoro.server.dashboard.model.TableStatistics;
import org.apache.amoro.server.dashboard.utils.AmsUtil;
import org.apache.amoro.server.dashboard.utils.TableStatCollector;
import org.apache.amoro.server.optimizing.OptimizingProcessMeta;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.OptimizingTaskMeta;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableProperties;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.table.descriptor.AMSColumnInfo;
import org.apache.amoro.table.descriptor.AMSPartitionField;
import org.apache.amoro.table.descriptor.AmoroSnapshotsOfTable;
import org.apache.amoro.table.descriptor.ConsumerInfo;
import org.apache.amoro.table.descriptor.DDLInfo;
import org.apache.amoro.table.descriptor.DDLReverser;
import org.apache.amoro.table.descriptor.FilesStatistics;
import org.apache.amoro.table.descriptor.FormatTableDescriptor;
import org.apache.amoro.table.descriptor.OperationType;
import org.apache.amoro.table.descriptor.OptimizingProcessInfo;
import org.apache.amoro.table.descriptor.OptimizingTaskInfo;
import org.apache.amoro.table.descriptor.PartitionBaseInfo;
import org.apache.amoro.table.descriptor.PartitionFileBaseInfo;
import org.apache.amoro.table.descriptor.ServerTableMeta;
import org.apache.amoro.table.descriptor.TableMetaExtract;
import org.apache.amoro.table.descriptor.TableSummary;
import org.apache.amoro.table.descriptor.TagOrBranchInfo;
import org.apache.amoro.utils.MixedDataFiles;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.IcebergFindFiles;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedAndIcebergTableDescriptor
extends PersistentBase
implements FormatTableDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(MixedAndIcebergTableDescriptor.class);
    private ExecutorService executorService;

    public void withIoExecutor(ExecutorService ioExecutor) {
        this.executorService = ioExecutor;
    }

    public List<TableFormat> supportFormat() {
        return Arrays.asList(TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.MIXED_HIVE);
    }

    public ServerTableMeta getTableDetail(AmoroTable<?> amoroTable) {
        MixedTable table = this.getTable(amoroTable);
        String tableFormat = this.decorateTableFormat(amoroTable);
        TableBasicInfo tableBasicInfo = this.getTableBasicInfo(table);
        ServerTableMeta serverTableMeta = this.getServerTableMeta(table);
        long tableSize = 0L;
        long tableFileCnt = 0L;
        HashMap baseMetrics = Maps.newHashMap();
        FilesStatistics baseFilesStatistics = tableBasicInfo.getBaseStatistics().getTotalFilesStat();
        Map<String, String> baseSummary = tableBasicInfo.getBaseStatistics().getSummary();
        baseMetrics.put("lastCommitTime", AmsUtil.longOrNull(baseSummary.get("visibleTime")));
        baseMetrics.put("totalSize", AmsUtil.byteToXB(baseFilesStatistics.getTotalSize()));
        baseMetrics.put("fileCount", baseFilesStatistics.getFileCnt());
        baseMetrics.put("averageFileSize", AmsUtil.byteToXB(baseFilesStatistics.getAverageSize()));
        if (tableBasicInfo.getChangeStatistics() == null) {
            baseMetrics.put("baseWatermark", AmsUtil.longOrNull(serverTableMeta.getTableWatermark()));
        } else {
            baseMetrics.put("baseWatermark", AmsUtil.longOrNull(serverTableMeta.getBaseWatermark()));
        }
        tableSize += baseFilesStatistics.getTotalSize();
        tableFileCnt += (long)baseFilesStatistics.getFileCnt();
        serverTableMeta.setBaseMetrics((Map)baseMetrics);
        if (table.isKeyedTable()) {
            HashMap changeMetrics = Maps.newHashMap();
            if (tableBasicInfo.getChangeStatistics() != null) {
                FilesStatistics changeFilesStatistics = tableBasicInfo.getChangeStatistics().getTotalFilesStat();
                Map<String, String> changeSummary = tableBasicInfo.getChangeStatistics().getSummary();
                changeMetrics.put("lastCommitTime", AmsUtil.longOrNull(changeSummary.get("visibleTime")));
                changeMetrics.put("totalSize", AmsUtil.byteToXB(changeFilesStatistics.getTotalSize()));
                changeMetrics.put("fileCount", changeFilesStatistics.getFileCnt());
                changeMetrics.put("averageFileSize", AmsUtil.byteToXB(changeFilesStatistics.getAverageSize()));
                changeMetrics.put("tableWatermark", AmsUtil.longOrNull(serverTableMeta.getTableWatermark()));
                tableSize += changeFilesStatistics.getTotalSize();
                tableFileCnt += (long)changeFilesStatistics.getFileCnt();
            } else {
                changeMetrics.put("lastCommitTime", null);
                changeMetrics.put("totalSize", null);
                changeMetrics.put("fileCount", null);
                changeMetrics.put("averageFileSize", null);
                changeMetrics.put("tableWatermark", null);
            }
            serverTableMeta.setChangeMetrics((Map)changeMetrics);
        }
        String averageFileSize = AmsUtil.byteToXB(tableFileCnt == 0L ? 0L : tableSize / tableFileCnt);
        long records = this.getRecordsOfTable(table);
        TableSummary tableSummary = new TableSummary(tableFileCnt, AmsUtil.byteToXB(tableSize), averageFileSize, records, tableFormat);
        serverTableMeta.setTableSummary(tableSummary);
        return serverTableMeta;
    }

    private String decorateTableFormat(AmoroTable<?> table) {
        StringBuilder sb = new StringBuilder();
        sb.append(AmsUtil.formatString(table.format().name()));
        if (table.format().equals((Object)TableFormat.ICEBERG)) {
            int formatVersion = ((HasTableOperations)table.originalTable()).operations().current().formatVersion();
            sb.append("(V");
            sb.append(formatVersion);
            sb.append(")");
        }
        return sb.toString();
    }

    private long getRecordsOfTable(MixedTable mixedTable) {
        long totalRecords = 0L;
        if (mixedTable.isKeyedTable()) {
            Snapshot changeSnapshot = SnapshotUtil.latestSnapshot((Table)mixedTable.asKeyedTable().changeTable(), null);
            Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)mixedTable.asKeyedTable().baseTable(), null);
            if (changeSnapshot != null) {
                totalRecords += PropertyUtil.propertyAsLong((Map)changeSnapshot.summary(), (String)"total-records", (long)0L);
            }
            if (baseSnapshot != null) {
                totalRecords += PropertyUtil.propertyAsLong((Map)baseSnapshot.summary(), (String)"total-records", (long)0L);
            }
        } else {
            Snapshot latestSnapshot = SnapshotUtil.latestSnapshot((Table)mixedTable.asUnkeyedTable(), null);
            if (latestSnapshot != null) {
                totalRecords = PropertyUtil.propertyAsLong((Map)latestSnapshot.summary(), (String)"total-records", (long)0L);
            }
        }
        return totalRecords;
    }

    private Long snapshotIdOfTableRef(Table table, String ref) {
        Snapshot snapshot;
        if (ref == null) {
            ref = "main";
        }
        if ((snapshot = table.snapshot(ref)) == null) {
            return null;
        }
        return snapshot.snapshotId();
    }

    public List<AmoroSnapshotsOfTable> getSnapshots(AmoroTable<?> amoroTable, String ref, OperationType operationType) {
        MixedTable mixedTable = this.getTable(amoroTable);
        ArrayList snapshotsOfTables = new ArrayList();
        ArrayList<Pair> tableAndSnapshotIdList = new ArrayList<Pair>();
        if (mixedTable.isKeyedTable()) {
            tableAndSnapshotIdList.add(Pair.of((Object)mixedTable.asKeyedTable().changeTable(), (Object)this.snapshotIdOfTableRef((Table)mixedTable.asKeyedTable().changeTable(), ref)));
            tableAndSnapshotIdList.add(Pair.of((Object)mixedTable.asKeyedTable().baseTable(), (Object)this.snapshotIdOfTableRef((Table)mixedTable.asKeyedTable().baseTable(), ref)));
        } else {
            tableAndSnapshotIdList.add(Pair.of((Object)mixedTable.asUnkeyedTable(), (Object)this.snapshotIdOfTableRef((Table)mixedTable.asUnkeyedTable(), ref)));
        }
        tableAndSnapshotIdList.forEach(tableAndSnapshotId -> this.collectSnapshots(snapshotsOfTables, (Pair<Table, Long>)tableAndSnapshotId));
        return snapshotsOfTables.stream().filter(s -> this.validOperationType((AmoroSnapshotsOfTable)s, operationType)).sorted((o1, o2) -> Long.compare(o2.getCommitTime(), o1.getCommitTime())).collect(Collectors.toList());
    }

    private boolean validOperationType(AmoroSnapshotsOfTable snapshot, OperationType operationType) {
        switch (operationType) {
            case ALL: {
                return true;
            }
            case OPTIMIZING: {
                return CommitMetaProducer.OPTIMIZE.name().equals(snapshot.getProducer());
            }
            case NON_OPTIMIZING: {
                return !CommitMetaProducer.OPTIMIZE.name().equals(snapshot.getProducer());
            }
        }
        throw new IllegalArgumentException("invalid operation: " + operationType + ", only support all/optimizing/non-optimizing");
    }

    private void collectSnapshots(List<AmoroSnapshotsOfTable> snapshotsOfTables, Pair<Table, Long> tableAndSnapshotId) {
        Table table = (Table)tableAndSnapshotId.getLeft();
        Long snapshotId = (Long)tableAndSnapshotId.getRight();
        if (snapshotId != null) {
            SnapshotUtil.ancestorsOf((long)snapshotId, arg_0 -> ((Table)table).snapshot(arg_0)).forEach(snapshot -> {
                Map summary = snapshot.summary();
                if (summary.containsKey("tx.begin.signature")) {
                    return;
                }
                AmoroSnapshotsOfTable amoroSnapshotsOfTable = new AmoroSnapshotsOfTable();
                amoroSnapshotsOfTable.setSnapshotId(String.valueOf(snapshot.snapshotId()));
                int fileCount = PropertyUtil.propertyAsInt((Map)summary, (String)"total-delete-files", (int)0) + PropertyUtil.propertyAsInt((Map)summary, (String)"total-data-files", (int)0);
                amoroSnapshotsOfTable.setFileCount(fileCount);
                amoroSnapshotsOfTable.setFileSize(PropertyUtil.propertyAsLong((Map)summary, (String)"added-files-size", (long)0L) + PropertyUtil.propertyAsLong((Map)summary, (String)"removed-files-size", (long)0L));
                long totalRecords = PropertyUtil.propertyAsLong((Map)summary, (String)"total-records", (long)0L);
                amoroSnapshotsOfTable.setRecords(totalRecords);
                amoroSnapshotsOfTable.setCommitTime(snapshot.timestampMillis());
                amoroSnapshotsOfTable.setOperation(snapshot.operation());
                amoroSnapshotsOfTable.setProducer(PropertyUtil.propertyAsString((Map)summary, (String)"snapshot.producer", (String)SnapshotSummary.SNAPSHOT_PRODUCER_DEFAULT));
                HashMap normalizeSummary = Maps.newHashMap((Map)summary);
                normalizeSummary.computeIfPresent("total-files-size", (k, v) -> AmsUtil.byteToXB(Long.parseLong((String)summary.get(k))));
                normalizeSummary.computeIfPresent("added-files-size", (k, v) -> AmsUtil.byteToXB(Long.parseLong((String)summary.get(k))));
                normalizeSummary.computeIfPresent("removed-files-size", (k, v) -> AmsUtil.byteToXB(Long.parseLong((String)summary.get(k))));
                amoroSnapshotsOfTable.setSummary((Map)normalizeSummary);
                HashMap<String, String> recordsSummaryForChat = new HashMap<String, String>();
                recordsSummaryForChat.put("total-records", totalRecords + "");
                recordsSummaryForChat.put("eq-delete-records", (String)summary.get("total-equality-deletes"));
                recordsSummaryForChat.put("pos-delete-records", (String)summary.get("total-position-deletes"));
                amoroSnapshotsOfTable.setRecordsSummaryForChart(recordsSummaryForChat);
                HashMap filesSummaryForChat = new HashMap();
                filesSummaryForChat.put("data-files", summary.get("total-data-files"));
                filesSummaryForChat.put("delete-files", summary.get("total-delete-files"));
                filesSummaryForChat.put("total-files", fileCount + "");
                amoroSnapshotsOfTable.setFilesSummaryForChart(filesSummaryForChat);
                snapshotsOfTables.add(amoroSnapshotsOfTable);
            });
        }
    }

    public List<PartitionFileBaseInfo> getSnapshotDetail(AmoroTable<?> amoroTable, String snapshotId, @Nullable String ref) {
        Snapshot snapshot;
        MixedTable mixedTable = this.getTable(amoroTable);
        ArrayList<PartitionFileBaseInfo> result = new ArrayList<PartitionFileBaseInfo>();
        long commitId = Long.parseLong(snapshotId);
        if (mixedTable.isKeyedTable()) {
            snapshot = mixedTable.asKeyedTable().changeTable().snapshot(commitId);
            if (snapshot == null) {
                snapshot = mixedTable.asKeyedTable().baseTable().snapshot(commitId);
            }
        } else {
            snapshot = mixedTable.asUnkeyedTable().snapshot(commitId);
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("unknown snapshot " + snapshotId + " of " + amoroTable.id());
        }
        long snapshotTime = snapshot.timestampMillis();
        snapshot.addedDataFiles((FileIO)mixedTable.io()).forEach(f -> result.add(new PartitionFileBaseInfo(snapshotId, DataFileType.ofContentId((Integer)f.content().id()).name(), Long.valueOf(snapshotTime), MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)mixedTable, (int)f.specId()).partitionToPath(f.partition()), f.path().toString(), f.fileSizeInBytes(), "add")));
        snapshot.removedDataFiles((FileIO)mixedTable.io()).forEach(f -> result.add(new PartitionFileBaseInfo(snapshotId, DataFileType.ofContentId((Integer)f.content().id()).name(), Long.valueOf(snapshotTime), MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)mixedTable, (int)f.specId()).partitionToPath(f.partition()), f.path().toString(), f.fileSizeInBytes(), "remove")));
        snapshot.addedDeleteFiles((FileIO)mixedTable.io()).forEach(f -> result.add(new PartitionFileBaseInfo(snapshotId, DataFileType.ofContentId((Integer)f.content().id()).name(), Long.valueOf(snapshotTime), MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)mixedTable, (int)f.specId()).partitionToPath(f.partition()), f.path().toString(), f.fileSizeInBytes(), "add")));
        snapshot.removedDeleteFiles((FileIO)mixedTable.io()).forEach(f -> result.add(new PartitionFileBaseInfo(snapshotId, DataFileType.ofContentId((Integer)f.content().id()).name(), Long.valueOf(snapshotTime), MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)mixedTable, (int)f.specId()).partitionToPath(f.partition()), f.path().toString(), f.fileSizeInBytes(), "remove")));
        return result;
    }

    public List<DDLInfo> getTableOperations(AmoroTable<?> amoroTable) {
        MixedTable mixedTable = this.getTable(amoroTable);
        Object table = mixedTable.isKeyedTable() ? mixedTable.asKeyedTable().baseTable() : mixedTable.asUnkeyedTable();
        IcebergTableMetaExtract extract = new IcebergTableMetaExtract();
        DDLReverser ddlReverser = new DDLReverser((TableMetaExtract)extract);
        return ddlReverser.reverse(table, amoroTable.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PartitionBaseInfo> getTablePartitions(AmoroTable<?> amoroTable) {
        MixedTable mixedTable = this.getTable(amoroTable);
        if (mixedTable.spec().isUnpartitioned()) {
            return new ArrayList<PartitionBaseInfo>();
        }
        HashMap<String, PartitionBaseInfo> partitionBaseInfoHashMap = new HashMap<String, PartitionBaseInfo>();
        CloseableIterable<PartitionFileBaseInfo> tableFiles = this.getTableFilesInternal(amoroTable, null, null);
        try {
            for (PartitionFileBaseInfo fileInfo : tableFiles) {
                if (!partitionBaseInfoHashMap.containsKey(fileInfo.getPartition())) {
                    PartitionBaseInfo partitionBaseInfo = new PartitionBaseInfo();
                    partitionBaseInfo.setPartition(fileInfo.getPartition());
                    partitionBaseInfo.setSpecId(fileInfo.getSpecId());
                    partitionBaseInfoHashMap.put(fileInfo.getPartition(), partitionBaseInfo);
                }
                PartitionBaseInfo partitionInfo = (PartitionBaseInfo)partitionBaseInfoHashMap.get(fileInfo.getPartition());
                partitionInfo.setFileCount(partitionInfo.getFileCount() + 1L);
                partitionInfo.setFileSize(partitionInfo.getFileSize() + fileInfo.getFileSize());
                partitionInfo.setLastCommitTime(partitionInfo.getLastCommitTime() > fileInfo.getCommitTime() ? partitionInfo.getLastCommitTime() : fileInfo.getCommitTime().longValue());
            }
        }
        finally {
            try {
                tableFiles.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close the manifest reader.", (Throwable)e);
            }
        }
        return new ArrayList<PartitionBaseInfo>(partitionBaseInfoHashMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PartitionFileBaseInfo> getTableFiles(AmoroTable<?> amoroTable, String partition, Integer specId) {
        CloseableIterable<PartitionFileBaseInfo> tableFilesIterable = this.getTableFilesInternal(amoroTable, partition, specId);
        try {
            ArrayList<PartitionFileBaseInfo> result = new ArrayList<PartitionFileBaseInfo>();
            Iterables.addAll(result, tableFilesIterable);
            ArrayList<PartitionFileBaseInfo> arrayList = result;
            return arrayList;
        }
        finally {
            try {
                tableFilesIterable.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close the manifest reader.", (Throwable)e);
            }
        }
    }

    public List<TagOrBranchInfo> getTableTags(AmoroTable<?> amoroTable) {
        return this.getTableTagsOrBranches(amoroTable, SnapshotRef::isTag);
    }

    public List<TagOrBranchInfo> getTableBranches(AmoroTable<?> amoroTable) {
        return this.getTableTagsOrBranches(amoroTable, SnapshotRef::isBranch);
    }

    public List<ConsumerInfo> getTableConsumerInfos(AmoroTable<?> amoroTable) {
        return Collections.emptyList();
    }

    public Pair<List<OptimizingProcessInfo>, Integer> getOptimizingProcessesInfo(AmoroTable<?> amoroTable, String type, ProcessStatus status, int limit, int offset) {
        TableIdentifier tableIdentifier = amoroTable.id();
        int total = 0;
        int pageNumber = offset / limit + 1;
        List processMetaList = Collections.emptyList();
        try (Page ignored = PageHelper.startPage((int)pageNumber, (int)limit, (boolean)true);){
            processMetaList = this.getAs(OptimizingMapper.class, mapper -> mapper.selectOptimizingProcesses(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName(), type, status));
            PageInfo pageInfo = new PageInfo(processMetaList);
            total = (int)pageInfo.getTotal();
            LOG.info("Get optimizing processes total : {} , pageNumber:{}, limit:{}, offset:{}", new Object[]{total, pageNumber, limit, offset});
            if (pageInfo.getSize() == 0) {
                Pair pair = Pair.of(Collections.emptyList(), (Object)0);
                return pair;
            }
        }
        List processIds = processMetaList.stream().map(OptimizingProcessMeta::getProcessId).collect(Collectors.toList());
        Map<Long, List<OptimizingTaskMeta>> optimizingTasks = this.getAs(OptimizingMapper.class, mapper -> mapper.selectOptimizeTaskMetas(processIds)).stream().collect(Collectors.groupingBy(OptimizingTaskMeta::getProcessId));
        LOG.info("Get {} optimizing tasks. ", (Object)optimizingTasks.size());
        return Pair.of(processMetaList.stream().map(p -> MixedAndIcebergTableDescriptor.buildOptimizingProcessInfo(p, (List)optimizingTasks.get(p.getProcessId()))).collect(Collectors.toList()), (Object)total);
    }

    public Map<String, String> getTableOptimizingTypes(AmoroTable<?> amoroTable) {
        HashMap types = Maps.newHashMap();
        for (OptimizingType type : OptimizingType.values()) {
            types.put(type.name(), OptimizingStatus.ofOptimizingType(type).displayValue());
        }
        return types;
    }

    public List<OptimizingTaskInfo> getOptimizingTaskInfos(AmoroTable<?> amoroTable, String processId) {
        long id = Long.parseLong(processId);
        List optimizingTaskMetaList = this.getAs(OptimizingMapper.class, mapper -> mapper.selectOptimizeTaskMetas(Collections.singletonList(id)));
        if (CollectionUtils.isEmpty((Collection)optimizingTaskMetaList)) {
            return Collections.emptyList();
        }
        return optimizingTaskMetaList.stream().map(taskMeta -> new OptimizingTaskInfo(Long.valueOf(taskMeta.getTableId()), String.valueOf(taskMeta.getProcessId()), taskMeta.getTaskId(), taskMeta.getPartitionData(), ProcessTaskStatus.valueOf((String)taskMeta.getStatus().name()), taskMeta.getRetryNum(), taskMeta.getOptimizerToken(), taskMeta.getThreadId(), taskMeta.getStartTime(), taskMeta.getEndTime(), taskMeta.getCostTime(), taskMeta.getFailReason(), taskMeta.getMetricsSummary().getInputFilesStatistics(), taskMeta.getMetricsSummary().getOutputFilesStatistics(), taskMeta.getMetricsSummary().summaryAsMap(true), taskMeta.getProperties())).collect(Collectors.toList());
    }

    private CloseableIterable<PartitionFileBaseInfo> getTableFilesInternal(AmoroTable<?> amoroTable, String partition, Integer specId) {
        MixedTable mixedTable = this.getTable(amoroTable);
        if (mixedTable.isKeyedTable()) {
            return CloseableIterable.concat(Arrays.asList(this.collectFileInfo((Table)mixedTable.asKeyedTable().changeTable(), true, partition, specId), this.collectFileInfo((Table)mixedTable.asKeyedTable().baseTable(), false, partition, specId)));
        }
        return this.collectFileInfo((Table)mixedTable.asUnkeyedTable(), false, partition, specId);
    }

    private CloseableIterable<PartitionFileBaseInfo> collectFileInfo(Table table, boolean isChangeTable, String partition, Integer specId) {
        Map specs = table.specs();
        IcebergFindFiles manifestReader = new IcebergFindFiles(table).ignoreDeleted().planWith(this.executorService);
        if (table.spec().isPartitioned() && partition != null && specId != null) {
            GenericRecord partitionData = MixedDataFiles.data((PartitionSpec)((PartitionSpec)specs.get(specId)), (String)partition);
            manifestReader.inPartitions((PartitionSpec)specs.get(specId), new StructLike[]{partitionData});
        }
        CloseableIterable entries = manifestReader.entries();
        return CloseableIterable.transform((CloseableIterable)entries, entry -> {
            ContentFile contentFile = entry.getFile();
            long snapshotId = entry.getSnapshotId();
            PartitionSpec partitionSpec = (PartitionSpec)specs.get(contentFile.specId());
            String partitionPath = partitionSpec.partitionToPath(contentFile.partition());
            long fileSize = contentFile.fileSizeInBytes();
            DataFileType dataFileType = isChangeTable ? FileNameRules.parseFileTypeForChange((String)contentFile.path().toString()) : DataFileType.ofContentId((Integer)contentFile.content().id());
            long commitTime = -1L;
            if (table.snapshot(snapshotId) != null) {
                commitTime = table.snapshot(snapshotId).timestampMillis();
            }
            return new PartitionFileBaseInfo(String.valueOf(snapshotId), dataFileType.name(), Long.valueOf(commitTime), partitionPath, contentFile.specId(), contentFile.path().toString(), fileSize);
        });
    }

    private TableBasicInfo getTableBasicInfo(MixedTable table) {
        try {
            TableStatistics baseInfo;
            TableBasicInfo tableBasicInfo = new TableBasicInfo();
            tableBasicInfo.setTableIdentifier(table.id());
            TableStatistics changeInfo = null;
            if (table.isUnkeyedTable()) {
                UnkeyedTable unkeyedTable = table.asUnkeyedTable();
                baseInfo = new TableStatistics();
                TableStatCollector.fillTableStatistics(baseInfo, unkeyedTable, table);
            } else if (table.isKeyedTable()) {
                KeyedTable keyedTable = table.asKeyedTable();
                changeInfo = TableStatCollector.collectChangeTableInfo(keyedTable);
                baseInfo = TableStatCollector.collectBaseTableInfo(keyedTable);
            } else {
                throw new IllegalStateException("unknown type of table");
            }
            tableBasicInfo.setChangeStatistics(changeInfo);
            tableBasicInfo.setBaseStatistics(baseInfo);
            tableBasicInfo.setTableStatistics(TableStatCollector.union(changeInfo, baseInfo));
            long createTime = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"table.create-timestamp", (long)0L);
            if (createTime != 0L) {
                if (tableBasicInfo.getTableStatistics() != null) {
                    if (tableBasicInfo.getTableStatistics().getSummary() == null) {
                        tableBasicInfo.getTableStatistics().setSummary(new HashMap<String, String>());
                    } else {
                        LOG.warn("{} summary is null", (Object)table.id());
                    }
                    tableBasicInfo.getTableStatistics().getSummary().put("createTime", String.valueOf(createTime));
                } else {
                    LOG.warn("{} table statistics is null {}", (Object)table.id(), (Object)tableBasicInfo);
                }
            }
            return tableBasicInfo;
        }
        catch (Throwable t) {
            LOG.error("{} failed to build table basic info", (Object)table.id(), (Object)t);
            throw t;
        }
    }

    private ServerTableMeta getServerTableMeta(MixedTable table) {
        ServerTableMeta serverTableMeta = new ServerTableMeta();
        serverTableMeta.setTableType(table.format().toString());
        serverTableMeta.setTableIdentifier(table.id());
        serverTableMeta.setBaseLocation(table.location());
        HashMap tableProperties = Maps.newHashMap((Map)table.properties());
        this.fillTableProperties(serverTableMeta, tableProperties);
        if (tableProperties.containsKey("comment")) {
            String comment = (String)tableProperties.get("comment");
            serverTableMeta.setComment(comment);
        }
        serverTableMeta.setPartitionColumnList(table.spec().fields().stream().map(item -> MixedAndIcebergTableDescriptor.buildPartitionFieldFromPartitionSpec(table.spec().schema(), item)).collect(Collectors.toList()));
        serverTableMeta.setSchema(table.schema().columns().stream().map(MixedAndIcebergTableDescriptor::buildColumnInfoFromNestedField).collect(Collectors.toList()));
        serverTableMeta.setFilter(null);
        LOG.debug("Table {} is keyedTable: {}", (Object)table.name(), (Object)(table instanceof KeyedTable));
        if (table.isKeyedTable()) {
            KeyedTable kt = table.asKeyedTable();
            if (kt.primaryKeySpec() != null) {
                serverTableMeta.setPkList(kt.primaryKeySpec().fields().stream().map(item -> MixedAndIcebergTableDescriptor.buildColumnInfoFromPartitionSpec(table.spec().schema(), item)).collect(Collectors.toList()));
            }
        } else {
            serverTableMeta.setPkList(serverTableMeta.getSchema().stream().filter(s -> table.schema().identifierFieldNames().contains(s.getField())).collect(Collectors.toList()));
        }
        return serverTableMeta;
    }

    private void fillTableProperties(ServerTableMeta serverTableMeta, Map<String, String> properties) {
        serverTableMeta.setTableWatermark(properties.remove("watermark.table"));
        serverTableMeta.setBaseWatermark(properties.remove("watermark.base"));
        serverTableMeta.setCreateTime(PropertyUtil.propertyAsLong(properties, (String)"table.create-timestamp", (long)0L));
        properties.remove("table.create-timestamp");
        TableProperties.READ_PROTECTED_PROPERTIES.forEach(properties::remove);
        serverTableMeta.setProperties(properties);
    }

    private MixedTable getTable(AmoroTable<?> amoroTable) {
        return (MixedTable)amoroTable.originalTable();
    }

    private List<TagOrBranchInfo> getTableTagsOrBranches(AmoroTable<?> amoroTable, Predicate<SnapshotRef> predicate) {
        MixedTable mixedTable = this.getTable(amoroTable);
        ArrayList<TagOrBranchInfo> result = new ArrayList<TagOrBranchInfo>();
        if (mixedTable.isKeyedTable()) {
            if (predicate.test(SnapshotRef.branchBuilder((long)-1L).build())) {
                return ImmutableList.of((Object)TagOrBranchInfo.MAIN_BRANCH);
            }
            return Collections.emptyList();
        }
        Map snapshotRefs = mixedTable.asUnkeyedTable().refs();
        snapshotRefs.forEach((name, snapshotRef) -> {
            if (predicate.test((SnapshotRef)snapshotRef)) {
                result.add(MixedAndIcebergTableDescriptor.buildTagOrBranchInfo(name, snapshotRef));
            }
        });
        result.sort(Comparator.comparing(TagOrBranchInfo::getName));
        return result;
    }

    private static AMSColumnInfo buildColumnInfoFromNestedField(Types.NestedField field) {
        if (field == null) {
            return null;
        }
        return new AMSColumnInfo.Builder().field(field.name()).type(field.type().toString()).required(Boolean.valueOf(field.isRequired())).comment(field.doc()).build();
    }

    private static AMSColumnInfo buildColumnInfoFromPartitionSpec(Schema schema, PrimaryKeySpec.PrimaryKeyField pkf) {
        return MixedAndIcebergTableDescriptor.buildColumnInfoFromNestedField(schema.findField(pkf.fieldName()));
    }

    private static AMSPartitionField buildPartitionFieldFromPartitionSpec(Schema schema, PartitionField pf) {
        return new AMSPartitionField.Builder().field(pf.name()).sourceField(schema.findColumnName(pf.sourceId())).transform(pf.transform().toString()).fieldId(Integer.valueOf(pf.fieldId())).sourceFieldId(Integer.valueOf(pf.sourceId())).build();
    }

    private static TagOrBranchInfo buildTagOrBranchInfo(String name, SnapshotRef snapshotRef) {
        String type = null;
        if (snapshotRef.isTag()) {
            type = "tag";
        } else if (snapshotRef.isBranch()) {
            type = "branch";
        } else {
            throw new RuntimeException("Invalid snapshot ref: " + snapshotRef);
        }
        return new TagOrBranchInfo(name, snapshotRef.snapshotId(), snapshotRef.minSnapshotsToKeep(), snapshotRef.maxSnapshotAgeMs(), snapshotRef.maxRefAgeMs(), type);
    }

    private static OptimizingProcessInfo buildOptimizingProcessInfo(OptimizingProcessMeta meta, List<OptimizingTaskMeta> optimizingTaskStats) {
        MetricsSummary summary;
        if (meta == null) {
            return null;
        }
        OptimizingProcessInfo result = new OptimizingProcessInfo();
        if (optimizingTaskStats != null) {
            int successTasks = 0;
            int runningTasks = 0;
            for (OptimizingTaskMeta optimizingTaskStat : optimizingTaskStats) {
                TaskRuntime.Status status = optimizingTaskStat.getStatus();
                switch (status) {
                    case SUCCESS: {
                        ++successTasks;
                        break;
                    }
                    case SCHEDULED: 
                    case ACKED: {
                        ++runningTasks;
                    }
                }
            }
            result.setTotalTasks(optimizingTaskStats.size());
            result.setSuccessTasks(successTasks);
            result.setRunningTasks(runningTasks);
        }
        if ((summary = meta.getSummary()) != null) {
            result.setInputFiles(summary.getInputFilesStatistics());
            result.setOutputFiles(summary.getOutputFilesStatistics());
        }
        result.setTableId(meta.getTableId());
        result.setCatalogName(meta.getCatalogName());
        result.setDbName(meta.getDbName());
        result.setTableName(meta.getTableName());
        result.setProcessId(String.valueOf(meta.getProcessId()));
        result.setStartTime(meta.getPlanTime());
        result.setOptimizingType(meta.getOptimizingType().name());
        result.setStatus(ProcessStatus.valueOf((String)meta.getStatus().name()));
        result.setFailReason(meta.getFailReason());
        result.setDuration(meta.getEndTime() > 0L ? meta.getEndTime() - meta.getPlanTime() : System.currentTimeMillis() - meta.getPlanTime());
        result.setFinishTime(meta.getEndTime());
        result.setSummary(meta.getSummary().summaryAsMap(true));
        return result;
    }
}

