/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.amoro.metrics.Gauge;
import org.apache.amoro.metrics.Metric;
import org.apache.amoro.metrics.MetricDefine;
import org.apache.amoro.metrics.MetricKey;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class AmsServiceMetrics {
    public static final String GARBAGE_COLLECTOR_TAG = "garbage_collector";
    public static final MetricDefine AMS_JVM_CPU_LOAD = MetricDefine.defineGauge((String)"ams_jvm_cpu_load").withDescription("The recent CPU usage of the AMS").build();
    public static final MetricDefine AMS_JVM_CPU_TIME = MetricDefine.defineGauge((String)"ams_jvm_cpu_time").withDescription("The CPU time used by the AMS").build();
    public static final MetricDefine AMS_JVM_MEMORY_HEAP_USED = MetricDefine.defineGauge((String)"ams_jvm_memory_heap_used").withDescription("The amount of heap memory currently used (in bytes) by the AMS").build();
    public static final MetricDefine AMS_JVM_MEMORY_HEAP_COMMITTED = MetricDefine.defineGauge((String)"ams_jvm_memory_heap_committed").withDescription("The amount of memory in the heap that is committed for the JVM to use (in bytes)").build();
    public static final MetricDefine AMS_JVM_MEMORY_HEAP_MAX = MetricDefine.defineGauge((String)"ams_jvm_memory_heap_max").withDescription("The maximum amount of memory in the heap (in bytes), It's equal to the value specified through -Xmx").build();
    public static final MetricDefine AMS_JVM_THREADS_COUNT = MetricDefine.defineGauge((String)"ams_jvm_threads_count").withDescription("The total number of live threads used by the AMS").build();
    public static final MetricDefine AMS_JVM_GARBAGE_COLLECTOR_COUNT = MetricDefine.defineGauge((String)"ams_jvm_garbage_collector_count").withDescription("The count of the JVM's Garbage Collector").withTags(new String[]{"garbage_collector"}).build();
    public static final MetricDefine AMS_JVM_GARBAGE_COLLECTOR_TIME = MetricDefine.defineGauge((String)"ams_jvm_garbage_collector_time").withDescription("The time of the JVM's Garbage Collector").withTags(new String[]{"garbage_collector"}).build();
    private final MetricRegistry registry;
    private List<MetricKey> registeredMetricKeys = Lists.newArrayList();

    public AmsServiceMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void register() {
        this.registerHeapMetric();
        this.registerThreadMetric();
        this.registerCPuMetric();
        this.registerGarbageCollectorMetrics();
    }

    public void unregister() {
        this.registeredMetricKeys.forEach(this.registry::unregister);
        this.registeredMetricKeys.clear();
    }

    private void registerHeapMetric() {
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.registerMetric(this.registry, AMS_JVM_MEMORY_HEAP_USED, (Metric)((Gauge)() -> heapMemoryUsage.getUsed()));
        this.registerMetric(this.registry, AMS_JVM_MEMORY_HEAP_COMMITTED, (Metric)((Gauge)() -> heapMemoryUsage.getCommitted()));
        this.registerMetric(this.registry, AMS_JVM_MEMORY_HEAP_MAX, (Metric)((Gauge)() -> heapMemoryUsage.getMax()));
    }

    private void registerThreadMetric() {
        this.registerMetric(this.registry, AMS_JVM_THREADS_COUNT, (Metric)((Gauge)() -> ManagementFactory.getThreadMXBean().getThreadCount()));
    }

    private void registerCPuMetric() {
        OperatingSystemMXBean mxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.registerMetric(this.registry, AMS_JVM_CPU_LOAD, (Metric)((Gauge)() -> mxBean.getProcessCpuLoad()));
        this.registerMetric(this.registry, AMS_JVM_CPU_TIME, (Metric)((Gauge)() -> mxBean.getProcessCpuTime()));
    }

    private void registerGarbageCollectorMetrics() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollector : garbageCollectorMXBeans) {
            this.registerMetric(this.registry, AMS_JVM_GARBAGE_COLLECTOR_COUNT, (Map<String, String>)ImmutableMap.of((Object)GARBAGE_COLLECTOR_TAG, (Object)garbageCollector.getName()), (Metric)((Gauge)() -> garbageCollector.getCollectionCount()));
            this.registerMetric(this.registry, AMS_JVM_GARBAGE_COLLECTOR_TIME, (Map<String, String>)ImmutableMap.of((Object)GARBAGE_COLLECTOR_TAG, (Object)garbageCollector.getName()), (Metric)((Gauge)() -> garbageCollector.getCollectionTime()));
        }
    }

    private void registerMetric(MetricRegistry registry, MetricDefine define, Metric metric) {
        MetricKey key = registry.register(define, Collections.emptyMap(), metric);
        this.registeredMetricKeys.add(key);
    }

    private void registerMetric(MetricRegistry registry, MetricDefine define, Map<String, String> tags, Metric metric) {
        MetricKey key = registry.register(define, tags, metric);
        this.registeredMetricKeys.add(key);
    }
}

