/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.StructLikeSet;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Filter;

public class Deletes {
    private static final Schema POSITION_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, Set<Long> deleteSet) {
        if (deleteSet.isEmpty()) {
            return rows;
        }
        PositionSetDeleteFilter filter = new PositionSetDeleteFilter(rowToPosition, deleteSet);
        return filter.filter(rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StructLikeSet toEqualitySet(CloseableIterable<StructLike> eqDeletes, Types.StructType eqType, StructLikeCollections structLikeCollections) {
        try (CloseableIterable<StructLike> deletes = eqDeletes;){
            StructLikeSet deleteSet = structLikeCollections.createStructLikeSet(eqType);
            for (StructLike delete : deletes) {
                deleteSet.add(delete);
            }
            Object object = deleteSet;
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close equality delete source", e);
        }
    }

    public static Set<Long> toPositionSet(CharSequence dataLocation, CloseableIterable<? extends StructLike> deleteFile) {
        return Deletes.toPositionSet(dataLocation, ImmutableList.of(deleteFile));
    }

    public static <T extends StructLike> Set<Long> toPositionSet(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform((CloseableIterable)locationFilter.filter((CloseableIterable)deletes), row -> (Long)POSITION_ACCESSOR.get(row)));
        return Deletes.toPositionSet((CloseableIterable<Long>)CloseableIterable.concat((Iterable)positions));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<Long> toPositionSet(CloseableIterable<Long> posDeletes) {
        try (CloseableIterable<Long> deletes = posDeletes;){
            HashSet hashSet = Sets.newHashSet(deletes);
            return hashSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close position delete source", e);
        }
    }

    private static class PositionSetDeleteFilter<T>
    extends Filter<T> {
        private final Function<T, Long> rowToPosition;
        private final Set<Long> deleteSet;

        private PositionSetDeleteFilter(Function<T, Long> rowToPosition, Set<Long> deleteSet) {
            this.rowToPosition = rowToPosition;
            this.deleteSet = deleteSet;
        }

        protected boolean shouldKeep(T row) {
            return !this.deleteSet.contains(this.rowToPosition.apply(row));
        }
    }

    private static class DataFileFilter<T extends StructLike>
    extends Filter<T> {
        private static final Comparator<CharSequence> CHARSEQ_COMPARATOR = Comparators.charSequences();
        private final CharSequence dataLocation;

        DataFileFilter(CharSequence dataLocation) {
            this.dataLocation = dataLocation;
        }

        protected boolean shouldKeep(T posDelete) {
            return CHARSEQ_COMPARATOR.compare(this.dataLocation, (CharSequence)FILENAME_ACCESSOR.get(posDelete)) == 0;
        }
    }
}

