/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.SupportFileRecycleOperations;
import org.apache.amoro.io.SupportsFileSystemOperations;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.io.SupportsPrefixOperations;

public class AuthenticatedFileIOAdapter
implements AuthenticatedFileIO {
    private final FileIO io;

    public AuthenticatedFileIOAdapter(FileIO io) {
        this.io = io;
    }

    @Override
    public <T> T doAs(Callable<T> callable) {
        if (this.io instanceof AuthenticatedFileIO) {
            return ((AuthenticatedFileIO)this.io).doAs(callable);
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists(String path) {
        if (this.io instanceof AuthenticatedFileIO) {
            return ((AuthenticatedFileIO)this.io).exists(path);
        }
        return AuthenticatedFileIO.super.exists(path);
    }

    @Override
    public boolean supportPrefixOperations() {
        return this.io instanceof SupportsPrefixOperations;
    }

    @Override
    public SupportsPrefixOperations asPrefixFileIO() {
        Preconditions.checkArgument((boolean)this.supportPrefixOperations());
        return (SupportsPrefixOperations)this.io;
    }

    @Override
    public boolean supportBulkOperations() {
        return this.io instanceof SupportsBulkOperations;
    }

    @Override
    public SupportsBulkOperations asBulkFileIO() {
        Preconditions.checkArgument((boolean)this.supportBulkOperations());
        return (SupportsBulkOperations)this.io;
    }

    @Override
    public boolean supportFileSystemOperations() {
        return this.io instanceof AuthenticatedFileIO && ((AuthenticatedFileIO)this.io).supportFileSystemOperations();
    }

    @Override
    public SupportsFileSystemOperations asFileSystemIO() {
        Preconditions.checkArgument((boolean)this.supportFileSystemOperations());
        return ((AuthenticatedFileIO)this.io).asFileSystemIO();
    }

    @Override
    public boolean supportsFileRecycle() {
        return this.io instanceof AuthenticatedFileIO && ((AuthenticatedFileIO)this.io).supportsFileRecycle();
    }

    @Override
    public SupportFileRecycleOperations asFileRecycleIO() {
        Preconditions.checkArgument((boolean)this.supportsFileRecycle());
        return ((AuthenticatedFileIO)this.io).asFileRecycleIO();
    }

    public InputFile newInputFile(String path) {
        return this.io.newInputFile(path);
    }

    public InputFile newInputFile(String path, long length) {
        return this.io.newInputFile(path, length);
    }

    public OutputFile newOutputFile(String path) {
        return this.io.newOutputFile(path);
    }

    public void deleteFile(String path) {
        this.io.deleteFile(path);
    }

    public void deleteFile(InputFile file) {
        this.io.deleteFile(file);
    }

    public void deleteFile(OutputFile file) {
        this.io.deleteFile(file);
    }

    public Map<String, String> properties() {
        return this.io.properties();
    }

    public void initialize(Map<String, String> properties) {
        this.io.initialize(properties);
    }

    public void close() {
        this.io.close();
    }
}

