/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.data;

import java.io.Serializable;
import java.util.Objects;

public class ChangedLsn
implements Comparable<ChangedLsn>,
Serializable {
    private final long transactionId;
    private final long fileOffset;

    public static ChangedLsn of(long transactionId, long fileOffset) {
        return new ChangedLsn(transactionId, fileOffset);
    }

    public static ChangedLsn of(byte[] bytes) {
        return ChangedLsn.of((long)bytes[15] << 56 | ((long)bytes[14] & 0xFFL) << 48 | ((long)bytes[13] & 0xFFL) << 40 | ((long)bytes[12] & 0xFFL) << 32 | ((long)bytes[11] & 0xFFL) << 24 | ((long)bytes[10] & 0xFFL) << 16 | ((long)bytes[9] & 0xFFL) << 8 | (long)bytes[8] & 0xFFL, (long)bytes[7] << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL);
    }

    private ChangedLsn(long transactionId, long fileOffset) {
        this.transactionId = transactionId;
        this.fileOffset = fileOffset;
    }

    public long transactionId() {
        return this.transactionId;
    }

    public long fileOffset() {
        return this.fileOffset;
    }

    @Override
    public int compareTo(ChangedLsn another) {
        if (this.transactionId > another.transactionId()) {
            return 1;
        }
        if (this.transactionId < another.transactionId) {
            return -1;
        }
        if (this.fileOffset > another.fileOffset()) {
            return 1;
        }
        if (this.fileOffset < another.fileOffset) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedLsn recordLsn = (ChangedLsn)o;
        return this.transactionId == recordLsn.transactionId && this.fileOffset == recordLsn.fileOffset;
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.fileOffset);
    }

    public String toString() {
        return "RecordLsn(" + this.transactionId + ", " + this.fileOffset + ")";
    }

    public byte[] toBytes() {
        return new byte[]{(byte)this.transactionId, (byte)(this.transactionId >> 8), (byte)(this.transactionId >> 16), (byte)(this.transactionId >> 24), (byte)(this.transactionId >> 32), (byte)(this.transactionId >> 40), (byte)(this.transactionId >> 48), (byte)(this.transactionId >> 56), (byte)this.fileOffset, (byte)(this.fileOffset >> 8), (byte)(this.fileOffset >> 16), (byte)(this.fileOffset >> 24), (byte)(this.fileOffset >> 32), (byte)(this.fileOffset >> 40), (byte)(this.fileOffset >> 48), (byte)(this.fileOffset >> 56)};
    }
}

