/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

public class SampleClause {
    private SampleKeyword keyword;
    private SampleMethod method;
    private Number percentageArgument;
    private Number repeatArgument;
    private Number seedArgument;

    public SampleClause(String keyword, String method, Number percentageArgument, Number repeatArgument, Number seedArgument) {
        this.keyword = SampleKeyword.from(keyword);
        this.method = method == null || method.length() == 0 ? null : SampleMethod.from(method);
        this.percentageArgument = percentageArgument;
        this.repeatArgument = repeatArgument;
        this.seedArgument = seedArgument;
    }

    public SampleClause() {
        this(SampleKeyword.TABLESAMPLE.toString(), null, null, null, null);
    }

    public SampleClause(String keyword) {
        this(keyword, null, null, null, null);
    }

    public SampleKeyword getKeyword() {
        return this.keyword;
    }

    public SampleClause setKeyword(SampleKeyword keyword) {
        this.keyword = keyword;
        return this;
    }

    public Number getPercentageArgument() {
        return this.percentageArgument;
    }

    public SampleClause setPercentageArgument(Number percentageArgument) {
        this.percentageArgument = percentageArgument;
        return this;
    }

    public Number getRepeatArgument() {
        return this.repeatArgument;
    }

    public SampleClause setRepeatArgument(Number repeatArgument) {
        this.repeatArgument = repeatArgument;
        return this;
    }

    public Number getSeedArgument() {
        return this.seedArgument;
    }

    public SampleClause setSeedArgument(Number seedArgument) {
        this.seedArgument = seedArgument;
        return this;
    }

    public SampleMethod getMethod() {
        return this.method;
    }

    public SampleClause setMethod(SampleMethod method) {
        this.method = method;
        return this;
    }

    public SampleClause setMethod(String method) {
        this.method = method == null || method.length() == 0 ? null : SampleMethod.from(method);
        return this;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append(" ").append((Object)this.keyword);
        if (this.method != null) {
            builder.append(" ").append((Object)this.method);
        }
        if (this.percentageArgument != null) {
            builder.append(" (").append(this.percentageArgument).append(")");
        }
        if (this.repeatArgument != null) {
            builder.append(" REPEATABLE (").append(this.repeatArgument).append(")");
        }
        if (this.seedArgument != null) {
            builder.append(" SEED (").append(this.seedArgument).append(")");
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public static enum SampleMethod {
        BERNOULLI,
        SYSTEM,
        BLOCK;


        public static SampleMethod from(String sampleMethod) {
            return Enum.valueOf(SampleMethod.class, sampleMethod.toUpperCase());
        }
    }

    public static enum SampleKeyword {
        SAMPLE,
        TABLESAMPLE;


        public static SampleKeyword from(String sampleKeyword) {
            return Enum.valueOf(SampleKeyword.class, sampleKeyword.toUpperCase());
        }
    }
}

