/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.op;

import java.util.Locale;
import java.util.Map;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.op.BaseSchemaUpdate;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.table.MixedTable;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.util.PropertyUtil;

public class HiveSchemaUpdate
extends BaseSchemaUpdate {
    private final MixedTable mixedTable;
    private final HMSClientPool hiveClient;
    private final HMSClientPool transactionClient;
    private final UpdateSchema updateSchema;

    public HiveSchemaUpdate(MixedTable mixedTable, HMSClientPool hiveClient, HMSClientPool transactionClient, UpdateSchema updateSchema) {
        super(mixedTable, updateSchema);
        this.mixedTable = mixedTable;
        this.hiveClient = hiveClient;
        this.updateSchema = updateSchema;
        this.transactionClient = transactionClient;
    }

    @Override
    public void commit() {
        Table tbl = HiveTableUtil.loadHmsTable(this.hiveClient, this.mixedTable.id());
        if (tbl == null) {
            throw new RuntimeException(String.format("there is no such hive table named %s", this.mixedTable.id().toString()));
        }
        Schema newSchema = (Schema)this.updateSchema.apply();
        this.updateSchema.commit();
        this.syncSchemaToHive(newSchema, tbl);
    }

    private void syncSchemaToHive(Schema newSchema, Table tbl) {
        tbl.setSd(HiveTableUtil.storageDescriptor(newSchema, this.mixedTable.spec(), tbl.getSd().getLocation(), FileFormat.valueOf((String)PropertyUtil.propertyAsString((Map)this.mixedTable.properties(), (String)"write.format.default", (String)"parquet").toUpperCase(Locale.ENGLISH))));
        HiveTableUtil.persistTable(this.transactionClient, tbl);
    }
}

