/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.data.SparkAvroReader;
import org.apache.iceberg.spark.data.SparkOrcReader;
import org.apache.iceberg.spark.data.SparkParquetReaders;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.iceberg.types.TypeUtil;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.catalyst.InternalRow;

abstract class BaseRowReader<T extends ScanTask>
extends BaseReader<InternalRow, T> {
    BaseRowReader(Table table, ScanTaskGroup<T> taskGroup, Schema tableSchema, Schema expectedSchema, boolean caseSensitive) {
        super(table, taskGroup, tableSchema, expectedSchema, caseSensitive);
    }

    protected CloseableIterable<InternalRow> newIterable(InputFile file, FileFormat format, long start, long length, Expression residual, Schema projection, Map<Integer, ?> idToConstant) {
        switch (format) {
            case PARQUET: {
                return this.newParquetIterable(file, start, length, residual, projection, idToConstant);
            }
            case AVRO: {
                return this.newAvroIterable(file, start, length, projection, idToConstant);
            }
            case ORC: {
                return this.newOrcIterable(file, start, length, residual, projection, idToConstant);
            }
        }
        throw new UnsupportedOperationException("Cannot read unknown format: " + format);
    }

    private CloseableIterable<InternalRow> newAvroIterable(InputFile file, long start, long length, Schema projection, Map<Integer, ?> idToConstant) {
        return Avro.read((InputFile)file).reuseContainers().project(projection).split(start, length).createReaderFunc(readSchema -> new SparkAvroReader(projection, (org.apache.avro.Schema)readSchema, idToConstant)).withNameMapping(this.nameMapping()).build();
    }

    private CloseableIterable<InternalRow> newParquetIterable(InputFile file, long start, long length, Expression residual, Schema readSchema, Map<Integer, ?> idToConstant) {
        return Parquet.read((InputFile)file).reuseContainers().split(start, length).project(readSchema).createReaderFunc(fileSchema -> SparkParquetReaders.buildReader(readSchema, fileSchema, idToConstant)).filter(residual).caseSensitive(this.caseSensitive()).withNameMapping(this.nameMapping()).build();
    }

    private CloseableIterable<InternalRow> newOrcIterable(InputFile file, long start, long length, Expression residual, Schema readSchema, Map<Integer, ?> idToConstant) {
        Schema readSchemaWithoutConstantAndMetadataFields = TypeUtil.selectNot((Schema)readSchema, (Set)Sets.union(idToConstant.keySet(), (Set)MetadataColumns.metadataFieldIds()));
        return ORC.read((InputFile)file).project(readSchemaWithoutConstantAndMetadataFields).split(start, length).createReaderFunc(readOrcSchema -> new SparkOrcReader(readSchema, (TypeDescription)readOrcSchema, idToConstant)).filter(residual).caseSensitive(this.caseSensitive()).withNameMapping(this.nameMapping()).build();
    }
}

