/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;

@Internal
public class Bzip2InputStreamFactory
implements InflaterInputStreamFactory<BZip2CompressorInputStream> {
    private static final Bzip2InputStreamFactory INSTANCE = new Bzip2InputStreamFactory();

    public static Bzip2InputStreamFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public BZip2CompressorInputStream create(InputStream in) throws IOException {
        return new BZip2CompressorInputStream(in);
    }

    @Override
    public Collection<String> getCommonFileExtensions() {
        return Collections.singleton("bz2");
    }
}

