/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.core.JavalinConfig;
import io.javalin.core.util.Util;
import io.javalin.http.Context;
import io.javalin.http.HandlerType;
import io.javalin.http.HttpCode;
import io.javalin.http.OutputStreamWrapper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponseWrapper;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0015\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0016\u0010\r\u00a8\u0006!"}, d2={"Lio/javalin/http/JavalinResponseWrapper;", "Ljavax/servlet/http/HttpServletResponseWrapper;", "ctx", "Lio/javalin/http/Context;", "config", "Lio/javalin/core/JavalinConfig;", "requestType", "Lio/javalin/http/HandlerType;", "(Lio/javalin/http/Context;Lio/javalin/core/JavalinConfig;Lio/javalin/http/HandlerType;)V", "clientEtag", "", "kotlin.jvm.PlatformType", "getClientEtag", "()Ljava/lang/String;", "clientEtag$delegate", "Lkotlin/Lazy;", "outputStreamWrapper", "Lio/javalin/http/OutputStreamWrapper;", "getOutputStreamWrapper", "()Lio/javalin/http/OutputStreamWrapper;", "outputStreamWrapper$delegate", "serverEtag", "getServerEtag", "serverEtag$delegate", "closeWith304", "", "inputStream", "Ljava/io/InputStream;", "generateEtagWriteAndClose", "resultStream", "getOutputStream", "write", "writeToWrapperAndClose", "javalin"})
public final class JavalinResponseWrapper
extends HttpServletResponseWrapper {
    @NotNull
    private final Context ctx;
    @NotNull
    private final JavalinConfig config;
    @NotNull
    private final HandlerType requestType;
    @NotNull
    private final Lazy outputStreamWrapper$delegate;
    @NotNull
    private final Lazy serverEtag$delegate;
    @NotNull
    private final Lazy clientEtag$delegate;

    public JavalinResponseWrapper(@NotNull Context ctx, @NotNull JavalinConfig config, @NotNull HandlerType requestType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)requestType), (String)"requestType");
        super(ctx.res);
        this.ctx = ctx;
        this.config = config;
        this.requestType = requestType;
        this.outputStreamWrapper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OutputStreamWrapper>(this){
            final /* synthetic */ JavalinResponseWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OutputStreamWrapper invoke() {
                return new OutputStreamWrapper(JavalinResponseWrapper.access$getConfig$p(this.this$0), JavalinResponseWrapper.access$getCtx$p(this.this$0), null, 4, null);
            }
        }));
        this.serverEtag$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ JavalinResponseWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.getHeader("ETag");
            }
        }));
        this.clientEtag$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ JavalinResponseWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return JavalinResponseWrapper.access$getCtx$p((JavalinResponseWrapper)this.this$0).req.getHeader("If-None-Match");
            }
        }));
    }

    private final OutputStreamWrapper getOutputStreamWrapper() {
        Lazy lazy = this.outputStreamWrapper$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (OutputStreamWrapper)((Object)lazy.getValue());
    }

    @NotNull
    public OutputStreamWrapper getOutputStream() {
        return this.getOutputStreamWrapper();
    }

    private final String getServerEtag() {
        Lazy lazy = this.serverEtag$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getClientEtag() {
        Lazy lazy = this.clientEtag$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public final void write(@Nullable InputStream resultStream) {
        if (resultStream != null) {
            if (this.getServerEtag() != null && Intrinsics.areEqual((Object)this.getServerEtag(), (Object)this.getClientEtag())) {
                this.closeWith304(resultStream);
            } else if (this.getServerEtag() == null && this.requestType == HandlerType.GET && this.config.autogenerateEtags) {
                this.generateEtagWriteAndClose(resultStream);
            } else {
                this.writeToWrapperAndClose(resultStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateEtagWriteAndClose(InputStream resultStream) {
        ByteArrayInputStream byteArrayInputStream;
        Closeable closeable = resultStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
            boolean bl4 = false;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ByteArrayInputStream inputStream = byteArrayInputStream;
        String generatedEtag = Util.INSTANCE.getChecksumAndReset(inputStream);
        this.setHeader("ETag", generatedEtag);
        String string = generatedEtag;
        if (Intrinsics.areEqual((Object)string, (Object)this.getClientEtag())) {
            this.closeWith304(inputStream);
        } else {
            this.writeToWrapperAndClose(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeToWrapperAndClose(InputStream inputStream) {
        Closeable closeable = inputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = (Closeable)((Object)this.getOutputStreamWrapper());
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                OutputStreamWrapper output = (OutputStreamWrapper)((Object)closeable2);
                boolean bl6 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)((OutputStream)((Object)output)), (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeWith304(InputStream inputStream) {
        Closeable closeable = inputStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            Context context = this.ctx.status(HttpCode.NOT_MODIFIED);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ JavalinConfig access$getConfig$p(JavalinResponseWrapper $this) {
        return $this.config;
    }

    public static final /* synthetic */ Context access$getCtx$p(JavalinResponseWrapper $this) {
        return $this.ctx;
    }
}

