/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.thrift.org.apache.thrift.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.amoro.shade.thrift.jakarta.servlet.ServletConfig;
import org.apache.amoro.shade.thrift.jakarta.servlet.ServletException;
import org.apache.amoro.shade.thrift.jakarta.servlet.ServletInputStream;
import org.apache.amoro.shade.thrift.jakarta.servlet.ServletOutputStream;
import org.apache.amoro.shade.thrift.jakarta.servlet.http.HttpServlet;
import org.apache.amoro.shade.thrift.jakarta.servlet.http.HttpServletRequest;
import org.apache.amoro.shade.thrift.jakarta.servlet.http.HttpServletResponse;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.shade.thrift.org.apache.thrift.TProcessor;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TProtocol;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TProtocolFactory;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TIOStreamTransport;

public abstract class TExtensibleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private TProcessor processor;
    private TProtocolFactory inFactory;
    private Collection<Map.Entry<String, String>> customHeaders;

    protected abstract TProcessor getProcessor();

    protected abstract TProtocolFactory getInProtocolFactory();

    protected abstract TProtocolFactory getOutProtocolFactory();

    @Override
    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.processor = this.getProcessor();
        this.inFactory = this.getInProtocolFactory();
        TProtocolFactory outFactory = this.getOutProtocolFactory();
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
        if (this.processor == null) {
            throw new ServletException("processor must be set");
        }
        if (this.inFactory == null) {
            throw new ServletException("inFactory must be set");
        }
        if (outFactory == null) {
            throw new ServletException("outFactory must be set");
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            TIOStreamTransport inTransport = transport = new TIOStreamTransport(in, (OutputStream)out);
            TIOStreamTransport outTransport = transport;
            TProtocol inProtocol = this.inFactory.getProtocol(inTransport);
            TProtocol outProtocol = this.inFactory.getProtocol(outTransport);
            this.processor.process(inProtocol, outProtocol);
            out.flush();
        }
        catch (TException te) {
            throw new ServletException(te);
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void addCustomHeader(final String key, final String value) {
        this.customHeaders.add(new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                return null;
            }
        });
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

