/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.AdaptHiveParquetConversions;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

public class AdaptHiveParquetUtil {
    private AdaptHiveParquetUtil() {
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig, Schema schema) {
        return AdaptHiveParquetUtil.footerMetrics(metadata, fieldMetrics, metricsConfig, null, schema);
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, Stream<FieldMetrics<?>> fieldMetrics, MetricsConfig metricsConfig, NameMapping nameMapping, Schema schema) {
        Preconditions.checkNotNull(fieldMetrics, (Object)"fieldMetrics should not be null");
        long rowCount = 0L;
        HashMap columnSizes = Maps.newHashMap();
        HashMap valueCounts = Maps.newHashMap();
        HashMap nullValueCounts = Maps.newHashMap();
        HashMap lowerBounds = Maps.newHashMap();
        HashMap upperBounds = Maps.newHashMap();
        HashSet missingStats = Sets.newHashSet();
        MessageType parquetTypeWithIds = AdaptHiveParquetUtil.getParquetTypeWithIds(metadata, nameMapping);
        Schema fileSchema = ParquetSchemaUtil.convertAndPrune((MessageType)parquetTypeWithIds);
        fileSchema = AdaptHiveParquetUtil.refineTimestampType(fileSchema, schema);
        Map<Integer, FieldMetrics<?>> fieldMetricsMap = fieldMetrics.collect(Collectors.toMap(FieldMetrics::id, Function.identity()));
        List blocks = metadata.getBlocks();
        for (BlockMetaData block : blocks) {
            rowCount += block.getRowCount();
            for (ColumnChunkMetaData column : block.getColumns()) {
                Types.NestedField field;
                Integer fieldId = fileSchema.aliasToId(column.getPath().toDotString());
                if (fieldId == null) continue;
                AdaptHiveParquetUtil.increment(columnSizes, fieldId, column.getTotalSize());
                MetricsModes.MetricsMode metricsMode = MetricsUtil.metricsMode((Schema)fileSchema, (MetricsConfig)metricsConfig, (int)fieldId);
                if (metricsMode == MetricsModes.None.get()) continue;
                AdaptHiveParquetUtil.increment(valueCounts, fieldId, column.getValueCount());
                Statistics stats = column.getStatistics();
                if (stats == null) {
                    missingStats.add(fieldId);
                    continue;
                }
                if (stats.isEmpty()) continue;
                AdaptHiveParquetUtil.increment(nullValueCounts, fieldId, stats.getNumNulls());
                if (metricsMode == MetricsModes.Counts.get() || fieldMetricsMap.containsKey(fieldId) || (field = fileSchema.findField(fieldId.intValue())) == null || !stats.hasNonNullValue() || !AdaptHiveParquetUtil.shouldStoreBounds(column, fileSchema)) continue;
                Literal min = AdaptHiveParquetConversions.fromParquetPrimitive(field.type(), column.getPrimitiveType(), stats.genericGetMin());
                AdaptHiveParquetUtil.updateMin(lowerBounds, fieldId, field.type(), min, metricsMode);
                Literal max = AdaptHiveParquetConversions.fromParquetPrimitive(field.type(), column.getPrimitiveType(), stats.genericGetMax());
                AdaptHiveParquetUtil.updateMax(upperBounds, fieldId, field.type(), max, metricsMode);
            }
        }
        for (Integer fieldId : missingStats) {
            nullValueCounts.remove(fieldId);
            lowerBounds.remove(fieldId);
            upperBounds.remove(fieldId);
        }
        AdaptHiveParquetUtil.updateFromFieldMetrics(fieldMetricsMap, metricsConfig, fileSchema, lowerBounds, upperBounds);
        return new Metrics(Long.valueOf(rowCount), (Map)columnSizes, (Map)valueCounts, (Map)nullValueCounts, MetricsUtil.createNanValueCounts(fieldMetricsMap.values().stream(), (MetricsConfig)metricsConfig, (Schema)fileSchema), AdaptHiveParquetUtil.toBufferMap(fileSchema, lowerBounds), AdaptHiveParquetUtil.toBufferMap(fileSchema, upperBounds));
    }

    private static Schema refineTimestampType(Schema schema, Schema original) {
        List columns = schema.columns();
        ArrayList<Types.NestedField> result = new ArrayList<Types.NestedField>();
        for (Types.NestedField nestedField : columns) {
            if (nestedField.type().typeId() == Type.TypeID.TIMESTAMP) {
                result.add(Types.NestedField.of((int)nestedField.fieldId(), (boolean)nestedField.isOptional(), (String)nestedField.name(), (Type)original.findType(nestedField.fieldId()), (String)nestedField.doc()));
                continue;
            }
            result.add(nestedField);
        }
        return new Schema(result, schema.getAliases(), schema.identifierFieldIds());
    }

    private static void updateFromFieldMetrics(Map<Integer, FieldMetrics<?>> idToFieldMetricsMap, MetricsConfig metricsConfig, Schema schema, Map<Integer, Literal<?>> lowerBounds, Map<Integer, Literal<?>> upperBounds) {
        idToFieldMetricsMap.entrySet().forEach(entry -> {
            int fieldId = (Integer)entry.getKey();
            FieldMetrics metrics = (FieldMetrics)entry.getValue();
            MetricsModes.MetricsMode metricsMode = MetricsUtil.metricsMode((Schema)schema, (MetricsConfig)metricsConfig, (int)fieldId);
            if (metricsMode != MetricsModes.None.get()) {
                if (!metrics.hasBounds()) {
                    lowerBounds.remove(fieldId);
                    upperBounds.remove(fieldId);
                } else if (metrics.upperBound() instanceof Float) {
                    lowerBounds.put(fieldId, Literal.of((float)((Float)metrics.lowerBound()).floatValue()));
                    upperBounds.put(fieldId, Literal.of((float)((Float)metrics.upperBound()).floatValue()));
                } else if (metrics.upperBound() instanceof Double) {
                    lowerBounds.put(fieldId, Literal.of((double)((Double)metrics.lowerBound())));
                    upperBounds.put(fieldId, Literal.of((double)((Double)metrics.upperBound())));
                } else {
                    throw new UnsupportedOperationException("Expected only float or double column metrics");
                }
            }
        });
    }

    private static MessageType getParquetTypeWithIds(ParquetMetadata metadata, NameMapping nameMapping) {
        MessageType type = metadata.getFileMetaData().getSchema();
        if (ParquetSchemaUtil.hasIds((MessageType)type)) {
            return type;
        }
        if (nameMapping != null) {
            return ParquetSchemaUtil.applyNameMapping((MessageType)type, (NameMapping)nameMapping);
        }
        return ParquetSchemaUtil.addFallbackIds((MessageType)type);
    }

    private static boolean shouldStoreBounds(ColumnChunkMetaData column, Schema schema) {
        ColumnPath columnPath = column.getPath();
        Iterator pathIterator = columnPath.iterator();
        Types.StructType currentType = schema.asStruct();
        while (pathIterator.hasNext()) {
            if (currentType == null || !currentType.isStructType()) {
                return false;
            }
            String fieldName = (String)pathIterator.next();
            currentType = currentType.asStructType().fieldType(fieldName);
        }
        return currentType != null && currentType.isPrimitiveType();
    }

    private static void increment(Map<Integer, Long> columns, int fieldId, long amount) {
        if (columns != null) {
            if (columns.containsKey(fieldId)) {
                columns.put(fieldId, columns.get(fieldId) + amount);
            } else {
                columns.put(fieldId, amount);
            }
        }
    }

    private static <T> void updateMin(Map<Integer, Literal<?>> lowerBounds, int id, Type type, Literal<T> min, MetricsModes.MetricsMode metricsMode) {
        Literal<?> currentMin = lowerBounds.get(id);
        if (currentMin == null || min.comparator().compare(min.value(), currentMin.value()) < 0) {
            if (metricsMode == MetricsModes.Full.get()) {
                lowerBounds.put(id, min);
            } else {
                MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
                int truncateLength = truncateMode.length();
                switch (type.typeId()) {
                    case STRING: {
                        lowerBounds.put(id, UnicodeUtil.truncateStringMin(min, (int)truncateLength));
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        lowerBounds.put(id, BinaryUtil.truncateBinaryMin(min, (int)truncateLength));
                        break;
                    }
                    default: {
                        lowerBounds.put(id, min);
                    }
                }
            }
        }
    }

    private static <T> void updateMax(Map<Integer, Literal<?>> upperBounds, int id, Type type, Literal<T> max, MetricsModes.MetricsMode metricsMode) {
        Literal<?> currentMax = upperBounds.get(id);
        if (currentMax == null || max.comparator().compare(max.value(), currentMax.value()) > 0) {
            if (metricsMode == MetricsModes.Full.get()) {
                upperBounds.put(id, max);
            } else {
                MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
                int truncateLength = truncateMode.length();
                switch (type.typeId()) {
                    case STRING: {
                        Literal truncatedMaxString = UnicodeUtil.truncateStringMax(max, (int)truncateLength);
                        if (truncatedMaxString == null) break;
                        upperBounds.put(id, truncatedMaxString);
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        Literal truncatedMaxBinary = BinaryUtil.truncateBinaryMax(max, (int)truncateLength);
                        if (truncatedMaxBinary == null) break;
                        upperBounds.put(id, truncatedMaxBinary);
                        break;
                    }
                    default: {
                        upperBounds.put(id, max);
                    }
                }
            }
        }
    }

    private static Map<Integer, ByteBuffer> toBufferMap(Schema schema, Map<Integer, Literal<?>> map) {
        HashMap bufferMap = Maps.newHashMap();
        for (Map.Entry<Integer, Literal<?>> entry : map.entrySet()) {
            bufferMap.put(entry.getKey(), Conversions.toByteBuffer((Type)schema.findType(entry.getKey().intValue()), (Object)entry.getValue().value()));
        }
        return bufferMap;
    }
}

