/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.optimizing;

import java.util.List;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.hive.io.writer.AdaptHiveGenericTaskWriterBuilder;
import org.apache.amoro.hive.optimizing.MixFormatOptimizingDataReader;
import org.apache.amoro.io.writer.MixedTreeNodePosDeleteWriter;
import org.apache.amoro.optimizing.AbstractRewriteFilesExecutor;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.WriteOperationKind;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.TaskWriter;

public class MixFormatRewriteExecutor
extends AbstractRewriteFilesExecutor {
    private final String outputDir;

    public MixFormatRewriteExecutor(RewriteFilesInput input, MixedTable table, StructLikeCollections structLikeCollections, String outputDir) {
        super(input, table, structLikeCollections);
        this.outputDir = outputDir;
    }

    protected OptimizingDataReader dataReader() {
        return new MixFormatOptimizingDataReader(this.table, this.structLikeCollections, this.input);
    }

    protected FileWriter<PositionDelete<Record>, DeleteWriteResult> posWriter() {
        FileAppenderFactory appenderFactory = this.fullMetricAppenderFactory(this.table.spec());
        return new MixedTreeNodePosDeleteWriter(appenderFactory, this.deleteFileFormat(), this.partition(), this.io, this.encryptionManager(), Long.valueOf(this.getTransactionId(this.input.rePosDeletedDataFilesForMixed())), this.baseLocation(), this.table.spec());
    }

    protected TaskWriter<Record> dataWriter() {
        return AdaptHiveGenericTaskWriterBuilder.builderFor(this.table).withTransactionId(this.table.isKeyedTable() ? Long.valueOf(this.getTransactionId(this.input.rewrittenDataFilesForMixed())) : null).withTaskId(0).withCustomHiveSubdirectory(this.outputDir).withTargetFileSize(this.targetSize()).buildWriter(StringUtils.isBlank((CharSequence)this.outputDir) ? WriteOperationKind.MAJOR_OPTIMIZE : WriteOperationKind.FULL_OPTIMIZE);
    }

    public long getTransactionId(List<PrimaryKeyedFile> dataFiles) {
        return dataFiles.stream().mapToLong(PrimaryKeyedFile::transactionId).max().orElse(0L);
    }

    public String baseLocation() {
        if (this.table.isKeyedTable()) {
            return this.table.asKeyedTable().baseTable().location();
        }
        return this.table.asUnkeyedTable().location();
    }
}

