/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.ArrayLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.Localiser;

public class ArrayIsEmptyMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(Localiser.msg((String)"060015", (Object[])new Object[]{"isEmpty", "ArrayExpression"}));
        }
        if (expr instanceof ArrayLiteral) {
            Object arr = ((ArrayLiteral)expr).getValue();
            boolean isEmpty = arr == null || Array.getLength(arr) == 0;
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, false);
            return new BooleanLiteral(this.stmt, m, isEmpty ? Boolean.TRUE : Boolean.FALSE);
        }
        SQLExpression sizeExpr = this.exprFactory.invokeMethod(this.stmt, "ARRAY", "size", expr, args);
        JavaTypeMapping mapping = this.exprFactory.getMappingForType(Integer.class, true);
        SQLExpression zeroExpr = this.exprFactory.newLiteral(this.stmt, mapping, 0);
        return sizeExpr.eq(zeroExpr);
    }
}

