/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;

public class GetWorkflowRunsIterable
implements SdkIterable<GetWorkflowRunsResponse> {
    private final GlueClient client;
    private final GetWorkflowRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetWorkflowRunsIterable(GlueClient client, GetWorkflowRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetWorkflowRunsResponseFetcher();
    }

    public Iterator<GetWorkflowRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetWorkflowRunsResponseFetcher
    implements SyncPageFetcher<GetWorkflowRunsResponse> {
        private GetWorkflowRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetWorkflowRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetWorkflowRunsResponse nextPage(GetWorkflowRunsResponse previousPage) {
            if (previousPage == null) {
                return GetWorkflowRunsIterable.this.client.getWorkflowRuns(GetWorkflowRunsIterable.this.firstRequest);
            }
            return GetWorkflowRunsIterable.this.client.getWorkflowRuns((GetWorkflowRunsRequest)((Object)GetWorkflowRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

