/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.StatementOutput;
import software.amazon.awssdk.services.glue.model.StatementState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Statement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Statement> {
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(Statement.getter(Statement::id)).setter(Statement.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(Statement.getter(Statement::code)).setter(Statement.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Statement.getter(Statement::stateAsString)).setter(Statement.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<StatementOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(Statement.getter(Statement::output)).setter(Statement.setter(Builder::output)).constructor(StatementOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<Double> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Progress").getter(Statement.getter(Statement::progress)).setter(Statement.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()}).build();
    private static final SdkField<Long> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartedOn").getter(Statement.getter(Statement::startedOn)).setter(Statement.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Long> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CompletedOn").getter(Statement.getter(Statement::completedOn)).setter(Statement.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CODE_FIELD, STATE_FIELD, OUTPUT_FIELD, PROGRESS_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer id;
    private final String code;
    private final String state;
    private final StatementOutput output;
    private final Double progress;
    private final Long startedOn;
    private final Long completedOn;

    private Statement(BuilderImpl builder) {
        this.id = builder.id;
        this.code = builder.code;
        this.state = builder.state;
        this.output = builder.output;
        this.progress = builder.progress;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
    }

    public final Integer id() {
        return this.id;
    }

    public final String code() {
        return this.code;
    }

    public final StatementState state() {
        return StatementState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StatementOutput output() {
        return this.output;
    }

    public final Double progress() {
        return this.progress;
    }

    public final Long startedOn() {
        return this.startedOn;
    }

    public final Long completedOn() {
        return this.completedOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn());
    }

    public final String toString() {
        return ToString.builder((String)"Statement").add("Id", (Object)this.id()).add("Code", (Object)this.code()).add("State", (Object)this.stateAsString()).add("Output", (Object)this.output()).add("Progress", (Object)this.progress()).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statement, T> g) {
        return obj -> g.apply((Statement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer id;
        private String code;
        private String state;
        private StatementOutput output;
        private Double progress;
        private Long startedOn;
        private Long completedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            this.id(model.id);
            this.code(model.code);
            this.state(model.state);
            this.output(model.output);
            this.progress(model.progress);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StatementState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StatementOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(StatementOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(StatementOutput output) {
            this.output = output;
            return this;
        }

        public final Double getProgress() {
            return this.progress;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final Long getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Long startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Long startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Long getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Long completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Long completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public Statement build() {
            return new Statement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Statement> {
        public Builder id(Integer var1);

        public Builder code(String var1);

        public Builder state(String var1);

        public Builder state(StatementState var1);

        public Builder output(StatementOutput var1);

        default public Builder output(Consumer<StatementOutput.Builder> output) {
            return this.output((StatementOutput)((StatementOutput.Builder)StatementOutput.builder().applyMutation(output)).build());
        }

        public Builder progress(Double var1);

        public Builder startedOn(Long var1);

        public Builder completedOn(Long var1);
    }
}

