/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.parquet.hadoop.ParquetReader;

public class ParquetIterable<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final ParquetReader.Builder<T> builder;

    ParquetIterable(ParquetReader.Builder<T> builder) {
        this.builder = builder;
    }

    public CloseableIterator<T> iterator() {
        try {
            ParquetReader reader = this.builder.build();
            this.addCloseable((Closeable)reader);
            return new ParquetIterator(reader);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create Parquet reader", new Object[0]);
        }
    }

    private static class ParquetIterator<T>
    implements CloseableIterator<T> {
        private final ParquetReader<T> parquet;
        private boolean needsAdvance = false;
        private boolean hasNext = false;
        private T next;

        ParquetIterator(ParquetReader<T> parquet) {
            this.parquet = parquet;
            this.next = this.advance();
        }

        public boolean hasNext() {
            if (this.needsAdvance) {
                this.next = this.advance();
            }
            return this.hasNext;
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.needsAdvance = true;
            return this.next;
        }

        private T advance() {
            try {
                Object nextRecord = this.parquet.read();
                this.needsAdvance = false;
                this.hasNext = nextRecord != null;
                return (T)nextRecord;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        public void close() throws IOException {
            this.parquet.close();
        }
    }
}

