/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.internal;

import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.util.LocationUtil;

public class InternalIcebergCreator
implements InternalTableCreator {
    protected final AuthenticatedFileIO io;
    protected final CreateTableRequest request;
    private final CatalogMeta catalogMeta;
    protected final String database;
    protected final String tableName;
    private boolean closed = false;
    private String metadataFileLocation;
    protected final org.apache.iceberg.TableMetadata icebergMetadata;

    public InternalIcebergCreator(CatalogMeta catalog, String database, String tableName, CreateTableRequest request) {
        this.io = InternalTableUtil.newIcebergFileIo(catalog);
        this.catalogMeta = catalog;
        this.database = database;
        this.tableName = tableName;
        this.request = request;
        String tableLocation = this.tableLocation();
        PartitionSpec spec = request.spec();
        SortOrder sortOrder = request.writeOrder();
        this.icebergMetadata = org.apache.iceberg.TableMetadata.newTableMetadata((Schema)request.schema(), (PartitionSpec)(spec != null ? spec : PartitionSpec.unpartitioned()), (SortOrder)(sortOrder != null ? sortOrder : SortOrder.unsorted()), (String)tableLocation, (Map)request.properties());
    }

    @Override
    public TableMetadata create() {
        this.checkClosed();
        String icebergMetadataFileLocation = InternalTableUtil.genNewMetadataFileLocation(null, this.icebergMetadata);
        TableMeta meta = new TableMeta();
        meta.putToLocations("table", this.icebergMetadata.location());
        meta.putToLocations("base", this.icebergMetadata.location());
        meta.setFormat(this.format().name());
        meta.putToProperties("iceberg.metadata.location", icebergMetadataFileLocation);
        ServerTableIdentifier serverTableIdentifier = ServerTableIdentifier.of((String)this.catalogMeta.getCatalogName(), (String)this.database, (String)this.tableName, (TableFormat)this.format());
        meta.setTableIdentifier(serverTableIdentifier.getIdentifier());
        OutputFile outputFile = this.io.newOutputFile(icebergMetadataFileLocation);
        this.metadataFileLocation = icebergMetadataFileLocation;
        TableMetadataParser.overwrite((org.apache.iceberg.TableMetadata)this.icebergMetadata, (OutputFile)outputFile);
        return new TableMetadata(serverTableIdentifier, meta, this.catalogMeta);
    }

    protected TableFormat format() {
        return TableFormat.ICEBERG;
    }

    @Override
    public void rollback() {
        this.checkClosed();
        if (StringUtils.isNotEmpty((CharSequence)this.metadataFileLocation)) {
            this.io.deleteFile(this.metadataFileLocation);
        }
    }

    @Override
    public void close() {
        this.io.close();
        this.closed = true;
    }

    private void checkClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)(this.getClass().getSimpleName() + " for table [" + this.catalogMeta.getCatalogName() + "." + this.database + "." + this.tableName + "] is closed"));
    }

    private String tableLocation() {
        String location = this.request.location();
        if (StringUtils.isBlank((CharSequence)location)) {
            String warehouse = (String)this.catalogMeta.getCatalogProperties().get("warehouse");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)warehouse), (Object)"catalog warehouse is not configured");
            warehouse = LocationUtil.stripTrailingSlash((String)warehouse);
            location = warehouse + "/" + this.database + "/" + this.tableName;
        } else {
            location = LocationUtil.stripTrailingSlash((String)location);
        }
        return location;
    }
}

