/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.config.TableConfiguration;
import org.apache.amoro.server.optimizing.maintainer.TableMaintainer;
import org.apache.amoro.server.table.TableManager;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsAutoCreatingExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TagsAutoCreatingExecutor.class);
    private final long interval;

    protected TagsAutoCreatingExecutor(TableManager tableManager, int poolSize, long interval) {
        super(tableManager, poolSize);
        this.interval = interval;
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return this.interval;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return tableRuntime.getTableConfiguration().getTagConfiguration().isAutoCreateTag() && tableRuntime.getFormat() == TableFormat.ICEBERG;
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        try {
            AmoroTable<?> amoroTable = this.loadTable(tableRuntime);
            TableMaintainer tableMaintainer = TableMaintainer.ofTable(amoroTable);
            tableMaintainer.autoCreateTags(tableRuntime);
        }
        catch (Throwable t) {
            LOG.error("Failed to create tags on {}", (Object)tableRuntime.getTableIdentifier(), (Object)t);
        }
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }
}

