/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.plan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.server.optimizing.plan.CommonPartitionEvaluator;
import org.apache.amoro.server.optimizing.plan.MixedHivePartitionPlan;
import org.apache.amoro.server.optimizing.plan.MixedIcebergPartitionPlan;
import org.apache.amoro.server.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.server.optimizing.scan.IcebergTableFileScanHelper;
import org.apache.amoro.server.optimizing.scan.KeyedTableFileScanHelper;
import org.apache.amoro.server.optimizing.scan.TableFileScanHelper;
import org.apache.amoro.server.optimizing.scan.UnkeyedTableFileScanHelper;
import org.apache.amoro.server.table.KeyedTableSnapshot;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableSnapshot;
import org.apache.amoro.server.utils.IcebergTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizingEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizingEvaluator.class);
    protected final MixedTable mixedTable;
    protected final TableRuntime tableRuntime;
    protected final TableSnapshot currentSnapshot;
    protected final int maxPendingPartitions;
    protected boolean isInitialized = false;
    protected Map<String, PartitionEvaluator> partitionPlanMap = Maps.newHashMap();

    public OptimizingEvaluator(TableRuntime tableRuntime, MixedTable table, int maxPendingPartitions) {
        this.tableRuntime = tableRuntime;
        this.mixedTable = table;
        this.currentSnapshot = IcebergTableUtil.getSnapshot(table, tableRuntime);
        this.maxPendingPartitions = maxPendingPartitions;
    }

    public TableRuntime getTableRuntime() {
        return this.tableRuntime;
    }

    protected void initEvaluator() {
        long startTime = System.currentTimeMillis();
        TableFileScanHelper tableFileScanHelper = TableFormat.ICEBERG == this.mixedTable.format() ? new IcebergTableFileScanHelper((Table)this.mixedTable.asUnkeyedTable(), this.currentSnapshot.snapshotId()) : (this.mixedTable.isUnkeyedTable() ? new UnkeyedTableFileScanHelper(this.mixedTable.asUnkeyedTable(), this.currentSnapshot.snapshotId()) : new KeyedTableFileScanHelper(this.mixedTable.asKeyedTable(), (KeyedTableSnapshot)this.currentSnapshot));
        tableFileScanHelper.withPartitionFilter(this.getPartitionFilter());
        this.initPartitionPlans(tableFileScanHelper);
        this.isInitialized = true;
        LOG.info("{} finished evaluating, found {} partitions that need optimizing in {} ms", new Object[]{this.mixedTable.id(), this.partitionPlanMap.size(), System.currentTimeMillis() - startTime});
    }

    protected Expression getPartitionFilter() {
        return Expressions.alwaysTrue();
    }

    private void initPartitionPlans(TableFileScanHelper tableFileScanHelper) {
        long startTime = System.currentTimeMillis();
        long count = 0L;
        try (CloseableIterable<TableFileScanHelper.FileScanResult> results = tableFileScanHelper.scan();){
            for (TableFileScanHelper.FileScanResult fileScanResult : results) {
                PartitionSpec partitionSpec = MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)this.mixedTable, (int)fileScanResult.file().specId());
                StructLike partition = fileScanResult.file().partition();
                String partitionPath = partitionSpec.partitionToPath(partition);
                PartitionEvaluator evaluator = this.partitionPlanMap.computeIfAbsent(partitionPath, ignore -> this.buildEvaluator((Pair<Integer, StructLike>)Pair.of((Object)partitionSpec.specId(), (Object)partition)));
                evaluator.addFile(fileScanResult.file(), fileScanResult.deleteFiles());
                ++count;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        LOG.info("{} finished file scanning, scanning {} files in {} ms", new Object[]{this.mixedTable.id(), count, System.currentTimeMillis() - startTime});
        this.partitionPlanMap = this.partitionPlanMap.entrySet().stream().filter(entry -> ((PartitionEvaluator)entry.getValue()).isNecessary()).limit(this.maxPendingPartitions).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> partitionProperties(Pair<Integer, StructLike> partition) {
        return TablePropertyUtil.getPartitionProperties((MixedTable)this.mixedTable, (StructLike)((StructLike)partition.second()));
    }

    protected PartitionEvaluator buildEvaluator(Pair<Integer, StructLike> partition) {
        if (TableFormat.ICEBERG == this.mixedTable.format()) {
            return new CommonPartitionEvaluator(this.tableRuntime, partition, System.currentTimeMillis());
        }
        Map<String, String> partitionProperties = this.partitionProperties(partition);
        if (TableTypeUtil.isHive((MixedTable)this.mixedTable)) {
            String hiveLocation = ((SupportHive)this.mixedTable).hiveLocation();
            return new MixedHivePartitionPlan.MixedHivePartitionEvaluator(this.tableRuntime, partition, partitionProperties, hiveLocation, System.currentTimeMillis(), this.mixedTable.isKeyedTable());
        }
        return new MixedIcebergPartitionPlan.MixedIcebergPartitionEvaluator(this.tableRuntime, partition, partitionProperties, System.currentTimeMillis(), this.mixedTable.isKeyedTable());
    }

    public boolean isNecessary() {
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        return !this.partitionPlanMap.isEmpty();
    }

    public PendingInput getPendingInput() {
        if (!this.isInitialized) {
            this.initEvaluator();
        }
        return new PendingInput(this.partitionPlanMap.values());
    }

    public static class PendingInput {
        @JsonIgnore
        private final Map<Integer, Set<StructLike>> partitions = Maps.newHashMap();
        private int dataFileCount = 0;
        private long dataFileSize = 0L;
        private int equalityDeleteFileCount = 0;
        private int positionalDeleteFileCount = 0;
        private long positionalDeleteBytes = 0L;
        private long equalityDeleteBytes = 0L;

        public PendingInput() {
        }

        public PendingInput(Collection<PartitionEvaluator> evaluators) {
            for (PartitionEvaluator evaluator : evaluators) {
                this.partitions.computeIfAbsent((Integer)evaluator.getPartition().first(), ignore -> Sets.newHashSet()).add((StructLike)evaluator.getPartition().second());
                this.dataFileCount += evaluator.getFragmentFileCount() + evaluator.getSegmentFileCount();
                this.dataFileSize += evaluator.getFragmentFileSize() + evaluator.getSegmentFileSize();
                this.positionalDeleteBytes += evaluator.getPosDeleteFileSize();
                this.positionalDeleteFileCount += evaluator.getPosDeleteFileCount();
                this.equalityDeleteBytes += evaluator.getEqualityDeleteFileSize();
                this.equalityDeleteFileCount += evaluator.getEqualityDeleteFileCount();
            }
        }

        public Map<Integer, Set<StructLike>> getPartitions() {
            return this.partitions;
        }

        public int getDataFileCount() {
            return this.dataFileCount;
        }

        public long getDataFileSize() {
            return this.dataFileSize;
        }

        public int getEqualityDeleteFileCount() {
            return this.equalityDeleteFileCount;
        }

        public int getPositionalDeleteFileCount() {
            return this.positionalDeleteFileCount;
        }

        public long getPositionalDeleteBytes() {
            return this.positionalDeleteBytes;
        }

        public long getEqualityDeleteBytes() {
            return this.equalityDeleteBytes;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitions", this.partitions).add("dataFileCount", this.dataFileCount).add("dataFileSize", this.dataFileSize).add("equalityDeleteFileCount", this.equalityDeleteFileCount).add("positionalDeleteFileCount", this.positionalDeleteFileCount).add("positionalDeleteBytes", this.positionalDeleteBytes).add("equalityDeleteBytes", this.equalityDeleteBytes).toString();
        }
    }
}

