/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.metrics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.amoro.api.metrics.Metric;
import org.apache.amoro.api.metrics.MetricDefine;
import org.apache.amoro.api.metrics.MetricKey;
import org.apache.amoro.api.metrics.MetricRegisterListener;
import org.apache.amoro.api.metrics.MetricSet;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.commons.lang3.tuple.Pair;

public class MetricRegistry
implements MetricSet {
    private final List<MetricRegisterListener> listeners = new CopyOnWriteArrayList<MetricRegisterListener>();
    private final ConcurrentMap<MetricKey, Metric> registeredMetrics = Maps.newConcurrentMap();
    private final Map<String, Pair<MetricDefine, Integer>> definedMetrics = Maps.newConcurrentMap();

    public void addListener(MetricRegisterListener listener) {
        this.listeners.add(listener);
    }

    public <T extends Metric> MetricKey register(MetricDefine define, Map<String, String> tags, T metric) {
        Preconditions.checkNotNull(metric, (Object)"Metric must not be null");
        Preconditions.checkNotNull((Object)define, (Object)"Metric define must not be null");
        Preconditions.checkArgument((boolean)define.getType().isType(metric), (String)"Metric type miss-match, required\uff1a%s, but found implement:%s ", (Object)define.getType(), (Object)metric.getClass().getName());
        Pair exists = this.definedMetrics.computeIfAbsent(define.getName(), name -> Pair.of((Object)define, (Object)0));
        Preconditions.checkArgument((boolean)((MetricDefine)exists.getLeft()).equals((Object)define), (String)"The metric define with name: %s has been already exists, but the define is different.", (Object)define.getName());
        MetricKey key = new MetricKey(define, tags);
        this.definedMetrics.computeIfPresent(define.getName(), (name, existsDefine) -> {
            Preconditions.checkArgument((boolean)define.equals(existsDefine.getLeft()), (String)"Metric define:%s is not equal to existed define:%s", (Object)define, (Object)existsDefine.getLeft());
            Metric existedMetric = this.registeredMetrics.putIfAbsent(key, metric);
            Preconditions.checkArgument((existedMetric == null ? 1 : 0) != 0, (Object)"Metric is already been registered.");
            return Pair.of((Object)((MetricDefine)existsDefine.getLeft()), (Object)((Integer)existsDefine.getRight() + 1));
        });
        this.callListener(listener -> listener.onMetricRegistered(key, metric));
        return key;
    }

    public void unregister(MetricKey key) {
        Metric exists = (Metric)this.registeredMetrics.remove(key);
        if (exists != null) {
            this.callListener(listener -> listener.onMetricUnregistered(key));
        }
        this.definedMetrics.computeIfPresent(key.getDefine().getName(), (name, pair) -> {
            int count = (Integer)pair.getRight() - 1;
            if (count <= 0) {
                return null;
            }
            return Pair.of((Object)((MetricDefine)pair.getLeft()), (Object)count);
        });
    }

    @VisibleForTesting
    int metricDefineCount(String name) {
        return Optional.ofNullable(this.definedMetrics.getOrDefault(name, null)).map(Pair::getRight).orElseGet(() -> 0);
    }

    public Map<MetricKey, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.registeredMetrics);
    }

    private void callListener(Consumer<MetricRegisterListener> consumer) {
        this.listeners.forEach(consumer);
    }
}

