/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.server.manager.AbstractResourceContainer;
import org.apache.amoro.server.utils.FlinkClientUtil;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Function;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.base.Supplier;
import org.apache.amoro.shade.guava32.com.google.common.base.Suppliers;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.FileUpload;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.handler.legacy.messages.ClusterOverviewWithVersion;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarListHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarListInfo;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarRunMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunResponseBody;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class FlinkOptimizerContainer
extends AbstractResourceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkOptimizerContainer.class);
    public static final String FLINK_HOME_PROPERTY = "flink-home";
    public static final String FLINK_CONFIG_PATH = "/conf";
    public static final String FLINK_CONFIG_YAML = "/flink-conf.yaml";
    public static final String ENV_FLINK_CONF_DIR = "FLINK_CONF_DIR";
    public static final String FLINK_CLIENT_TIMEOUT_SECOND = "flink-client-timeout-second";
    private static final String DEFAULT_JOB_URI = "/plugin/optimizer/flink/optimizer-job.jar";
    private static final String FLINK_JOB_MAIN_CLASS = "org.apache.amoro.optimizer.flink.FlinkOptimizer";
    @Deprecated
    public static final String TASK_MANAGER_MEMORY_PROPERTY = "taskmanager.memory";
    @Deprecated
    public static final String JOB_MANAGER_MEMORY_PROPERTY = "jobmanager.memory";
    public static final String FLINK_RUN_TARGET = "target";
    public static final String FLINK_JOB_URI = "job-uri";
    public static final String YARN_APPLICATION_ID_PROPERTY = "yarn-application-id";
    public static final String KUBERNETES_CLUSTER_ID_PROPERTY = "kubernetes-cluster-id";
    public static final String SESSION_CLUSTER_JOB_ID = "session-cluster-job-id";
    private static final Pattern APPLICATION_ID_PATTERN = Pattern.compile("(.*)application_(\\d+)_(\\d+)");
    private static final int MAX_READ_APP_ID_TIME = 600000;
    private static final long FLINK_CLIENT_TIMEOUT_SECOND_DEFAULT = 30L;
    private static final Function<String, String> yarnApplicationIdReader = readLine -> {
        Matcher matcher = APPLICATION_ID_PATTERN.matcher((CharSequence)readLine);
        if (matcher.matches()) {
            return String.format("application_%s_%s", matcher.group(2), matcher.group(3));
        }
        return null;
    };
    private final Supplier<ExecutorService> clientExecutorServiceSupplier = Suppliers.memoize(() -> Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("flink-rest-cluster-client-io-%d").setDaemon(true).build()));
    private Target target;
    private String flinkHome;
    private String flinkConfDir;
    private String jobUri;
    private long flinkClientTimeoutSecond;

    @Override
    public void init(String name, Map<String, String> containerProperties) {
        super.init(name, containerProperties);
        this.flinkHome = this.getFlinkHome();
        this.flinkConfDir = this.getFlinkConfDir();
        this.flinkClientTimeoutSecond = this.getFlinkClientTimeoutSecond();
        String runTarget = Optional.ofNullable(containerProperties.get(FLINK_RUN_TARGET)).orElse(Target.YARN_PER_JOB.getValue());
        this.target = Target.valueToEnum(runTarget);
        String jobUri = containerProperties.get(FLINK_JOB_URI);
        if (this.target.isApplicationMode()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)jobUri), (String)"The property: %s  is required if running target in application mode.", (Object)FLINK_JOB_URI);
        }
        if (StringUtils.isEmpty((CharSequence)jobUri)) {
            jobUri = this.amsHome + DEFAULT_JOB_URI;
        }
        this.jobUri = jobUri;
        if (Target.KUBERNETES_APPLICATION == this.target) {
            FlinkConf flinkConf = FlinkConf.buildFor(this.loadFlinkConfig(), containerProperties).build();
            String imageRef = flinkConf.configValue("kubernetes.container.image");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)imageRef), (String)"The flink-conf: %s is required if running target is %s", (Object)"kubernetes.container.image", (Object)this.target.getValue());
        }
    }

    @Override
    protected Map<String, String> doScaleOut(Resource resource) {
        if (this.target.runByFlinkRestClient()) {
            try {
                Configuration configuration = FlinkConf.buildFor(this.loadFlinkConfig(), this.getContainerProperties()).withGroupProperties(resource.getProperties()).build().toConfiguration();
                JobID jobID = this.runFlinkOptimizerJob(resource, configuration);
                HashMap startUpStatesMap = Maps.newHashMap();
                startUpStatesMap.put(SESSION_CLUSTER_JOB_ID, jobID.toString());
                return startUpStatesMap;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to scale out flink optimizer in session cluster.", e);
            }
        }
        String startUpArgs = this.buildOptimizerStartupArgsString(resource);
        Runtime runtime = Runtime.getRuntime();
        try {
            String exportCmd = String.join((CharSequence)" && ", this.exportSystemProperties());
            String startUpCmd = String.format("%s && %s", exportCmd, startUpArgs);
            String[] cmd = new String[]{"/bin/sh", "-c", startUpCmd};
            LOG.info("Starting flink optimizer using command : {}", (Object)startUpCmd);
            Process exec = runtime.exec(cmd);
            HashMap startUpStatesMap = Maps.newHashMap();
            switch (this.target) {
                case YARN_PER_JOB: 
                case YARN_APPLICATION: {
                    String applicationId = this.fetchCommandOutput(exec, yarnApplicationIdReader);
                    if (applicationId == null) break;
                    startUpStatesMap.put(YARN_APPLICATION_ID_PROPERTY, applicationId);
                    break;
                }
                case KUBERNETES_APPLICATION: {
                    startUpStatesMap.put(KUBERNETES_CLUSTER_ID_PROPERTY, this.kubernetesClusterId(resource));
                }
            }
            return startUpStatesMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to scale out flink optimizer.", e);
        }
    }

    @Override
    protected String buildOptimizerStartupArgsString(Resource resource) {
        String flinkAction;
        Map properties = resource.getProperties();
        Map<String, String> flinkConfig = this.loadFlinkConfig();
        FlinkConf resourceFlinkConf = FlinkConf.buildFor(flinkConfig, this.getContainerProperties()).withGroupProperties(resource.getProperties()).build();
        long jobManagerMemory = this.getMemorySizeValue(properties, resourceFlinkConf, JOB_MANAGER_MEMORY_PROPERTY, "jobmanager.memory.process.size");
        long taskManagerMemory = this.getMemorySizeValue(properties, resourceFlinkConf, TASK_MANAGER_MEMORY_PROPERTY, "taskmanager.memory.process.size");
        resourceFlinkConf.putToOptions("jobmanager.memory.process.size", jobManagerMemory + "m");
        resourceFlinkConf.putToOptions("taskmanager.memory.process.size", taskManagerMemory + "m");
        resourceFlinkConf.putToOptions("yarn.application.name", String.join((CharSequence)"-", "Amoro-flink-optimizer", resource.getGroupName(), resource.getResourceId()));
        String string = flinkAction = this.target.isApplicationMode() ? "run-application" : "run";
        if (Target.KUBERNETES_APPLICATION == this.target) {
            this.addKubernetesProperties(resource, resourceFlinkConf);
        } else if (Target.YARN_PER_JOB == this.target || Target.YARN_APPLICATION == this.target) {
            this.addYarnProperties(resourceFlinkConf);
        }
        String flinkOptions = resourceFlinkConf.toCliOptions();
        String jobArgs = super.buildOptimizerStartupArgsString(resource);
        return String.format("%s/bin/flink %s --target=%s %s -c %s %s %s", this.flinkHome, flinkAction, this.target.getValue(), flinkOptions, FLINK_JOB_MAIN_CLASS, this.jobUri, jobArgs);
    }

    private Map<String, String> loadFlinkConfig() {
        try {
            return (Map)new Yaml().load(Files.newInputStream(Paths.get(this.flinkConfDir + FLINK_CONFIG_YAML, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            LOG.error("load flink conf yaml failed: {}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    private void addKubernetesProperties(Resource resource, FlinkConf flinkConf) {
        String clusterId = this.kubernetesClusterId(resource);
        flinkConf.putToOptions("kubernetes.cluster-id", clusterId);
        Object[] labels = new String[]{"amoro.optimizing-group:" + resource.getGroupName(), "amoro.optimizer-implement:flink-native-kubernetes", "amoro.optimizer-id:" + resource.getResourceId()};
        String resourceLabel = Joiner.on((char)',').join(labels);
        flinkConf.putToOptions("kubernetes.taskmanager.labels", resourceLabel);
        flinkConf.putToOptions("kubernetes.jobmanager.labels", resourceLabel);
    }

    private void addYarnProperties(FlinkConf flinkConf) {
        flinkConf.putToOptions("yarn.per-job-cluster.include-user-jar", "FIRST");
    }

    @VisibleForTesting
    protected long getMemorySizeValue(Map<String, String> resourceProperties, FlinkConf conf, String resourcePropertyKey, String flinkConfKey) {
        String value = resourceProperties.get(resourcePropertyKey);
        if (value == null) {
            value = conf.configValue(flinkConfKey);
        }
        return this.parseMemorySize(value);
    }

    @VisibleForTesting
    protected long parseMemorySize(String memoryStr) {
        if (memoryStr == null || memoryStr.isEmpty()) {
            return 0L;
        }
        memoryStr = memoryStr.toLowerCase().trim().replaceAll("\\s", "");
        Matcher matcher = Pattern.compile("(\\d+)([mg])").matcher(memoryStr);
        if (matcher.matches()) {
            String unit;
            long size = Long.parseLong(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "m": {
                    return size;
                }
                case "g": {
                    return size * 1024L;
                }
            }
            LOG.error("Invalid memory size unit: {}, Please use m or g as the unit", (Object)unit);
            return 0L;
        }
        try {
            return Long.parseLong(memoryStr);
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid memory size format: {}", (Object)memoryStr);
            return 0L;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T fetchCommandOutput(Process exec, Function<String, T> commandReader) {
        Object value = null;
        try (InputStreamReader inputStreamReader = new InputStreamReader(exec.getInputStream());){
            Object object;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String readLine;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < 600000L && (readLine = bufferedReader.readLine()) != null) {
                    LOG.info("{}", (Object)readLine);
                    value = commandReader.apply((Object)readLine);
                    if (value == null) continue;
                    break;
                }
                object = value;
            }
            return (T)object;
        }
        catch (IOException e) {
            LOG.error("Read application id from output failed", (Throwable)e);
            return null;
        }
    }

    public void releaseOptimizer(Resource resource) {
        block16: {
            String releaseCommand;
            if (this.target.runByFlinkRestClient()) {
                Preconditions.checkArgument((boolean)resource.getProperties().containsKey(SESSION_CLUSTER_JOB_ID), (String)"Cannot find {} from optimizer start up stats", (Object)SESSION_CLUSTER_JOB_ID);
                String jobId = (String)resource.getProperties().get(SESSION_CLUSTER_JOB_ID);
                Configuration configuration = FlinkConf.buildFor(this.loadFlinkConfig(), this.getContainerProperties()).withGroupProperties(resource.getProperties()).build().toConfiguration();
                try (RestClusterClient<String> restClusterClient = FlinkClientUtil.getRestClusterClient(configuration);){
                    Acknowledge acknowledge = (Acknowledge)restClusterClient.cancel(JobID.fromHexString((String)jobId)).get(this.flinkClientTimeoutSecond, TimeUnit.SECONDS);
                    break block16;
                }
                catch (TimeoutException timeoutException) {
                    throw new RuntimeException(String.format("Timed out stopping the optimizer in Flink cluster, please configure a larger timeout via '%s'", FLINK_CLIENT_TIMEOUT_SECOND));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to release flink optimizer", e);
                }
            }
            switch (this.target) {
                case YARN_PER_JOB: 
                case YARN_APPLICATION: {
                    releaseCommand = this.buildReleaseYarnCommand(resource);
                    break;
                }
                case KUBERNETES_APPLICATION: {
                    releaseCommand = this.buildReleaseKubernetesCommand(resource);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported running target: " + this.target.getValue());
                }
            }
            try {
                String exportCmd = String.join((CharSequence)" && ", this.exportSystemProperties());
                String releaseCmd = exportCmd + " && " + releaseCommand;
                String[] cmd = new String[]{"/bin/sh", "-c", releaseCmd};
                LOG.info("Releasing flink optimizer using command: {}", (Object)releaseCmd);
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to release flink optimizer.", e);
            }
        }
    }

    private String buildReleaseYarnCommand(Resource resource) {
        Preconditions.checkArgument((boolean)resource.getProperties().containsKey(YARN_APPLICATION_ID_PROPERTY), (String)"Cannot find {} from optimizer start up stats", (Object)YARN_APPLICATION_ID_PROPERTY);
        String applicationId = (String)resource.getProperties().get(YARN_APPLICATION_ID_PROPERTY);
        String options = "-Dyarn.application.id=" + applicationId;
        Preconditions.checkArgument((boolean)resource.getProperties().containsKey("job-id"), (String)"Cannot find {} from optimizer properties", (Object)"job-id");
        String jobId = (String)resource.getProperties().get("job-id");
        return String.format("%s/bin/flink cancel -t %s %s %s", this.flinkHome, this.target.getValue(), options, jobId);
    }

    private String buildReleaseKubernetesCommand(Resource resource) {
        Preconditions.checkArgument((boolean)resource.getProperties().containsKey(KUBERNETES_CLUSTER_ID_PROPERTY), (String)"Cannot find {} from optimizer start up stats.", (Object)KUBERNETES_CLUSTER_ID_PROPERTY);
        String clusterId = (String)resource.getProperties().get(KUBERNETES_CLUSTER_ID_PROPERTY);
        FlinkConf conf = FlinkConf.buildFor(this.loadFlinkConfig(), this.getContainerProperties()).withGroupProperties(resource.getProperties()).build();
        conf.putToOptions("kubernetes.cluster-id", clusterId);
        String options = conf.toCliOptions();
        return String.format(" echo 'stop' | %s/bin/kubernetes-session.sh %s -Dexecution.attached=true", this.flinkHome, options);
    }

    protected JobID runFlinkOptimizerJob(Resource resource, Configuration configuration) throws Exception {
        try (RestClusterClient<String> client = FlinkClientUtil.getRestClusterClient(configuration);){
            ClusterOverviewWithVersion overviewWithVersion = (ClusterOverviewWithVersion)client.getClusterOverview().get(this.flinkClientTimeoutSecond, TimeUnit.SECONDS);
            LOG.debug("cluster overview: {}", (Object)overviewWithVersion);
            File jarFile = new File(this.jobUri);
            Preconditions.checkArgument((boolean)jarFile.exists(), (Object)String.format("The jar file %s not exists", jarFile.getAbsolutePath()));
            URL url = new URL(client.getWebInterfaceURL());
            JobID jobID = this.runJar(this.uploadJar(jarFile, url.getHost(), url.getPort(), configuration), configuration, resource);
            return jobID;
        }
    }

    @VisibleForTesting
    protected String uploadJar(File jarFile, String host, int port, Configuration configuration) throws Exception {
        Preconditions.checkArgument((boolean)jarFile.exists(), (Object)String.format("The jar file %s not exists", jarFile.getAbsolutePath()));
        try (RestClient restClient = FlinkClientUtil.getRestClient(configuration, (ExecutorService)this.clientExecutorServiceSupplier.get());){
            JarListHeaders jarListHeaders = JarListHeaders.getInstance();
            JarListInfo jarListInfo = (JarListInfo)restClient.sendRequest(host, port, (MessageHeaders)jarListHeaders, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance()).get(this.flinkClientTimeoutSecond, TimeUnit.SECONDS);
            Optional<JarListInfo.JarFileInfo> optimizerJarOptional = jarListInfo.jarFileList.stream().filter(jarFileInfo -> jarFile.getName().equals(jarFileInfo.name)).findFirst();
            if (optimizerJarOptional.isPresent()) {
                String string = optimizerJarOptional.get().id;
                return string;
            }
            JarUploadHeaders jarUploadHeaders = JarUploadHeaders.getInstance();
            JarUploadResponseBody jarUploadResponseBody = (JarUploadResponseBody)restClient.sendRequest(host, port, (MessageHeaders)jarUploadHeaders, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), Collections.singletonList(new FileUpload(jarFile.toPath(), "application/java-archive"))).get(this.flinkClientTimeoutSecond, TimeUnit.SECONDS);
            String string = jarUploadResponseBody.getFilename().substring(jarUploadResponseBody.getFilename().lastIndexOf("/") + 1);
            return string;
        }
    }

    @VisibleForTesting
    protected JobID runJar(String jarId, Configuration configuration, Resource resource) throws Exception {
        JarRunHeaders headers = JarRunHeaders.getInstance();
        JarRunMessageParameters parameters = headers.getUnresolvedMessageParameters();
        parameters.jarIdPathParameter.resolve((Object)jarId);
        String args = super.buildOptimizerStartupArgsString(resource);
        JobID jobID = JobID.generate();
        JarRunRequestBody runRequestBody = new JarRunRequestBody(FLINK_JOB_MAIN_CLASS, args, null, null, jobID, Boolean.valueOf(true), null, RestoreMode.DEFAULT, null);
        LOG.info("Submitting job: {} to session cluster, args: {}", (Object)jobID, (Object)args);
        try (RestClusterClient<String> restClusterClient = FlinkClientUtil.getRestClusterClient(configuration);){
            JarRunResponseBody jarRunResponseBody = (JarRunResponseBody)restClusterClient.sendRequest((MessageHeaders)headers, (MessageParameters)parameters, (RequestBody)runRequestBody).get(this.flinkClientTimeoutSecond, TimeUnit.SECONDS);
            JobID jobID2 = jarRunResponseBody.getJobId();
            return jobID2;
        }
    }

    private String getFlinkHome() {
        String flinkHome = this.getContainerProperties().get(FLINK_HOME_PROPERTY);
        Preconditions.checkNotNull((Object)flinkHome, (String)"Container property: %s is required", (Object)FLINK_HOME_PROPERTY);
        return flinkHome.replaceAll("/$", "");
    }

    private String getFlinkConfDir() {
        String flinkConfDir = this.getContainerProperties().get("export.FLINK_CONF_DIR");
        if (StringUtils.isNotEmpty((CharSequence)flinkConfDir)) {
            return flinkConfDir;
        }
        return this.flinkHome + FLINK_CONFIG_PATH;
    }

    private long getFlinkClientTimeoutSecond() {
        return this.getContainerProperties().get(FLINK_CLIENT_TIMEOUT_SECOND) != null ? Long.parseLong(this.getContainerProperties().get(FLINK_CLIENT_TIMEOUT_SECOND)) : 30L;
    }

    private String kubernetesClusterId(Resource resource) {
        return "amoro-optimizer-" + resource.getResourceId();
    }

    private static enum Target {
        YARN_PER_JOB("yarn-per-job", false, false),
        YARN_APPLICATION("yarn-application", true, false),
        KUBERNETES_APPLICATION("kubernetes-application", true, false),
        SESSION("session", false, true);

        private final String value;
        private final boolean applicationMode;
        private final boolean runByFlinkRestClient;

        private Target(String value, boolean applicationMode, boolean runByFlinkRestClient) {
            this.value = value;
            this.applicationMode = applicationMode;
            this.runByFlinkRestClient = runByFlinkRestClient;
        }

        public static Target valueToEnum(String value) {
            return Arrays.stream(Target.values()).filter(t -> t.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("can't parse value: " + value));
        }

        public boolean isApplicationMode() {
            return this.applicationMode;
        }

        public boolean runByFlinkRestClient() {
            return this.runByFlinkRestClient;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class FlinkConf {
        public static final String FLINK_PARAMETER_PREFIX = "flink-conf.";
        final Map<String, String> flinkConf;
        final Map<String, String> flinkOptions;

        public FlinkConf(Map<String, String> flinkConf, Map<String, String> flinkOptions) {
            this.flinkConf = flinkConf;
            this.flinkOptions = flinkOptions;
        }

        public String configValue(String key) {
            if (this.flinkOptions.containsKey(key)) {
                return this.flinkOptions.get(key);
            }
            return this.flinkConf.get(key);
        }

        public void putToOptions(String key, String value) {
            this.flinkOptions.put(key, value);
        }

        public String toCliOptions() {
            return this.flinkOptions.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" "));
        }

        public static Builder buildFor(Map<String, String> flinkConf, Map<String, String> containerProperties) {
            return new Builder(flinkConf, containerProperties);
        }

        public Configuration toConfiguration() {
            HashMap<String, String> config = new HashMap<String, String>();
            config.putAll(this.flinkConf);
            config.putAll(this.flinkOptions);
            return Configuration.fromMap(config);
        }

        public static class Builder {
            final Map<String, String> flinkConf;
            Map<String, String> containerProperties;
            Map<String, String> groupProperties = Collections.emptyMap();

            public Builder(Map<String, String> flinkConf, Map<String, String> containerProperties) {
                this.flinkConf = Maps.newHashMap(flinkConf);
                this.containerProperties = containerProperties == null ? Collections.emptyMap() : containerProperties;
            }

            public Builder withGroupProperties(Map<String, String> groupProperties) {
                this.groupProperties = groupProperties;
                return this;
            }

            public FlinkConf build() {
                HashMap options = Maps.newHashMap();
                this.containerProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(FlinkConf.FLINK_PARAMETER_PREFIX)).forEach(entry -> options.put(((String)entry.getKey()).substring(FlinkConf.FLINK_PARAMETER_PREFIX.length()), (String)entry.getValue()));
                this.groupProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(FlinkConf.FLINK_PARAMETER_PREFIX)).forEach(entry -> options.put(((String)entry.getKey()).substring(FlinkConf.FLINK_PARAMETER_PREFIX.length()), (String)entry.getValue()));
                return new FlinkConf(this.flinkConf, options);
            }
        }
    }

    public static class FlinkConfKeys {
        public static final String JOB_MANAGER_TOTAL_PROCESS_MEMORY = "jobmanager.memory.process.size";
        public static final String TASK_MANAGER_TOTAL_PROCESS_MEMORY = "taskmanager.memory.process.size";
        public static final String CLASSPATH_INCLUDE_USER_JAR = "yarn.per-job-cluster.include-user-jar";
        public static final String CLASSPATH_INCLUDE_USER_JAR_DEFAULT = "FIRST";
        public static final String KUBERNETES_IMAGE_REF = "kubernetes.container.image";
        public static final String KUBERNETES_CLUSTER_ID = "kubernetes.cluster-id";
        public static final String KUBERNETES_TASKMANAGER_LABELS = "kubernetes.taskmanager.labels";
        public static final String KUBERNETES_JOBMANAGER_LABELS = "kubernetes.jobmanager.labels";
        public static final String YARN_APPLICATION_JOB_NAME = "yarn.application.name";
    }
}

