/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class PropertiesUtil {
    public static void putNotNullProperties(Map<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public static void removeHiddenProperties(Map<String, String> properties, Set<String> skipKeys) {
        for (String skipKey : skipKeys) {
            properties.remove(skipKey);
        }
    }

    public static Map<String, String> extractTableProperties(Map<String, String> catalogProperties) {
        HashMap result = Maps.newHashMap();
        catalogProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("table.")).forEach(entry -> result.put(((String)entry.getKey()).replaceFirst("table.", ""), (String)entry.getValue()));
        return result;
    }

    public static Map<String, String> extractCatalogMetaProperties(Map<String, String> catalogProperties) {
        HashMap result = Maps.newHashMap();
        catalogProperties.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("table.")).forEach(entry -> result.put((String)entry.getKey(), (String)entry.getValue()));
        return result;
    }

    public static Map<String, String> unionCatalogProperties(Map<String, String> tableProperties, Map<String, String> catalogMetaProperties) {
        HashMap result = Maps.newHashMap(catalogMetaProperties);
        tableProperties.forEach((key, value) -> result.put("table." + key, value));
        return result;
    }
}

