/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.model;

import java.util.Map;
import org.apache.amoro.server.dashboard.model.FilesStatistics;
import org.apache.amoro.server.optimizing.TaskRuntime;

public class OptimizingTaskInfo {
    public static String RETRY_COUNT_PROP = "retry-count";
    public static String OPTIMIZER_TOKEN_PROP = "optimizer.token";
    public static String OPTIMIZER_THREAD_ID_PROP = "optimizer.thread-id";
    private Long tableId;
    private Long processId;
    private int taskId;
    private String partitionData;
    private TaskRuntime.Status status;
    private int retryNum;
    private String optimizerToken;
    private int threadId;
    private long startTime;
    private long endTime;
    private long costTime;
    private String failReason;
    private FilesStatistics inputFiles;
    private FilesStatistics outputFiles;
    private Map<String, String> summary;
    private Map<String, String> properties;

    public OptimizingTaskInfo(Long tableId, Long processId, int taskId, String partitionData, TaskRuntime.Status status, int retryNum, String optimizerToken, int threadId, long startTime, long endTime, long costTime, String failReason, FilesStatistics inputFiles, FilesStatistics outputFiles, Map<String, String> summary, Map<String, String> properties) {
        this.tableId = tableId;
        this.processId = processId;
        this.taskId = taskId;
        this.partitionData = partitionData;
        this.status = status;
        this.retryNum = retryNum;
        this.optimizerToken = optimizerToken;
        this.threadId = threadId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.costTime = costTime == 0L && startTime != 0L && endTime == 0L ? System.currentTimeMillis() - startTime : costTime;
        this.failReason = failReason;
        this.inputFiles = inputFiles;
        this.outputFiles = outputFiles;
        this.summary = summary;
        this.properties = properties;
        this.summary.put(RETRY_COUNT_PROP, String.valueOf(retryNum));
        if (this.optimizerToken != null) {
            this.summary.put(OPTIMIZER_TOKEN_PROP, optimizerToken);
            this.summary.put(OPTIMIZER_THREAD_ID_PROP, String.valueOf(threadId));
        }
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public String getPartitionData() {
        return this.partitionData;
    }

    public void setPartitionData(String partitionData) {
        this.partitionData = partitionData;
    }

    public TaskRuntime.Status getStatus() {
        return this.status;
    }

    public void setStatus(TaskRuntime.Status status) {
        this.status = status;
    }

    public int getRetryNum() {
        return this.retryNum;
    }

    public void setRetryNum(int retryNum) {
        this.retryNum = retryNum;
    }

    public String getOptimizerToken() {
        return this.optimizerToken;
    }

    public void setOptimizerToken(String optimizerToken) {
        this.optimizerToken = optimizerToken;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public Map<String, String> getSummary() {
        return this.summary;
    }

    public void setSummary(Map<String, String> summary) {
        this.summary = summary;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public FilesStatistics getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(FilesStatistics inputFiles) {
        this.inputFiles = inputFiles;
    }

    public FilesStatistics getOutputFiles() {
        return this.outputFiles;
    }

    public void setOutputFiles(FilesStatistics outputFiles) {
        this.outputFiles = outputFiles;
    }
}

