/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.model;

import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;

public class FilesStatistics {
    private int fileCnt;
    private long totalSize;
    private long averageSize;

    public static FilesStatistics build(int fileCnt, long totalSize) {
        return new FilesStatistics(fileCnt, totalSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    public FilesStatistics() {
    }

    public FilesStatistics(Integer fileCnt, Long totalSize) {
        this.fileCnt = fileCnt;
        this.totalSize = totalSize;
        if (fileCnt != 0) {
            this.averageSize = totalSize / (long)fileCnt.intValue();
        }
    }

    public int getFileCnt() {
        return this.fileCnt;
    }

    public void setFileCnt(int fileCnt) {
        this.fileCnt = fileCnt;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public long getAverageSize() {
        return this.averageSize;
    }

    public void setAverageSize(long averageSize) {
        this.averageSize = averageSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileCnt", this.fileCnt).add("totalSize", this.totalSize).add("averageSize", this.averageSize).toString();
    }

    public static class Builder {
        private int fileCnt = 0;
        private long totalSize = 0L;

        public Builder addFile(long fileSize) {
            this.totalSize += fileSize;
            ++this.fileCnt;
            return this;
        }

        public Builder addFilesStatistics(FilesStatistics fs) {
            this.totalSize += fs.getTotalSize();
            this.fileCnt += fs.getFileCnt();
            return this;
        }

        public Builder addFiles(long totalSize, int fileCnt) {
            this.totalSize += totalSize;
            this.fileCnt += fileCnt;
            return this;
        }

        public FilesStatistics build() {
            return FilesStatistics.build(this.fileCnt, this.totalSize);
        }
    }
}

