/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.server.catalog.CatalogService;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.dashboard.PlatformFileManager;
import org.apache.amoro.server.dashboard.model.CatalogRegisterInfo;
import org.apache.amoro.server.dashboard.model.CatalogSettingInfo;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.server.dashboard.utils.DesensitizationUtil;
import org.apache.amoro.server.dashboard.utils.PropertiesUtil;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.iceberg.aws.glue.GlueCatalog;

public class CatalogController {
    private static final String CONFIG_TYPE_STORAGE = "storage-config";
    private static final String CONFIG_TYPE_AUTH = "auth-config";
    private static final String EMPTY_XML_BASE64 = "PGNvbmZpZ3VyYXRpb24+PC9jb25maWd1cmF0aW9uPg==";
    private static final Map<String, List<String>> CATALOG_REQUIRED_PROPERTIES = Maps.newHashMap();
    private static final Set<CatalogDescriptor> VALIDATE_CATALOGS;
    private final PlatformFileManager platformFileInfoService;
    private final CatalogService tableService;

    public CatalogController(TableService tableService, PlatformFileManager platformFileInfoService) {
        this.tableService = tableService;
        this.platformFileInfoService = platformFileInfoService;
    }

    private static Set<String> getHiddenCatalogTableProperties() {
        return Sets.newHashSet((Object[])new String[]{"self-optimizing.group"});
    }

    private static Set<String> getHiddenCatalogProperties(CatalogRegisterInfo info) {
        return CatalogController.getHiddenCatalogProperties(info.getType(), info.getAuthConfig(), info.getStorageConfig());
    }

    private static Set<String> getHiddenCatalogProperties(CatalogSettingInfo info) {
        return CatalogController.getHiddenCatalogProperties(info.getType(), info.getAuthConfig(), info.getStorageConfig());
    }

    private static Set<String> getHiddenCatalogProperties(String type, Map<String, ?> authConfig, Map<String, ?> storageConfig) {
        HashSet hiddenProperties = Sets.newHashSet((Object[])new String[]{"table-formats"});
        if (!"custom".equals(type)) {
            hiddenProperties.add("catalog-impl");
        }
        if ("ak/sk".equalsIgnoreCase(String.valueOf(authConfig.get("auth.type")))) {
            hiddenProperties.add("s3.access-key-id");
            hiddenProperties.add("s3.secret-access-key");
        }
        if ("S3".equals(storageConfig.get("storage.type"))) {
            hiddenProperties.add("client.region");
            hiddenProperties.add("s3.endpoint");
        }
        return hiddenProperties;
    }

    public void getCatalogTypeList(Context ctx) {
        ArrayList<ImmutableMap> catalogTypes = new ArrayList<ImmutableMap>();
        String valueKey = "value";
        String displayKey = "display";
        catalogTypes.add(ImmutableMap.of((Object)valueKey, (Object)"ams", (Object)displayKey, (Object)"Amoro Metastore"));
        catalogTypes.add(ImmutableMap.of((Object)valueKey, (Object)"hive", (Object)displayKey, (Object)"Hive Metastore"));
        catalogTypes.add(ImmutableMap.of((Object)valueKey, (Object)"hadoop", (Object)displayKey, (Object)"Filesystem"));
        catalogTypes.add(ImmutableMap.of((Object)valueKey, (Object)"glue", (Object)displayKey, (Object)"Glue"));
        catalogTypes.add(ImmutableMap.of((Object)valueKey, (Object)"custom", (Object)displayKey, (Object)"Custom"));
        ctx.json(OkResponse.of(catalogTypes));
    }

    private void fillAuthConfigs2CatalogMeta(CatalogMeta catalogMeta, Map<String, String> serverAuthConfig, CatalogMeta oldCatalogMeta) {
        HashMap<String, String> metaAuthConfig = new HashMap<String, String>();
        String authType = serverAuthConfig.getOrDefault("auth.type", "simple").toLowerCase();
        metaAuthConfig.put("auth.type", authType);
        Map oldAuthConfig = new HashMap();
        if (oldCatalogMeta != null) {
            oldAuthConfig = oldCatalogMeta.getAuthConfigs();
        }
        switch (authType) {
            case "simple": {
                metaAuthConfig.put("auth.simple.hadoop_username", serverAuthConfig.get("auth.simple.hadoop_username"));
                break;
            }
            case "kerberos": {
                String keytabFileId = serverAuthConfig.get("auth.kerberos.keytab");
                if (!StringUtils.isEmpty((String)keytabFileId)) {
                    String keytabB64 = this.platformFileInfoService.getFileContentB64ById(Integer.valueOf(keytabFileId));
                    metaAuthConfig.put("auth.kerberos.keytab", keytabB64);
                } else {
                    metaAuthConfig.put("auth.kerberos.keytab", (String)oldAuthConfig.get("auth.kerberos.keytab"));
                }
                String krbFileId = serverAuthConfig.get("auth.kerberos.krb5");
                if (!StringUtils.isEmpty((String)krbFileId)) {
                    String krbB64 = this.platformFileInfoService.getFileContentB64ById(Integer.valueOf(krbFileId));
                    metaAuthConfig.put("auth.kerberos.krb5", krbB64);
                } else {
                    metaAuthConfig.put("auth.kerberos.krb5", (String)oldAuthConfig.get("auth.kerberos.krb5"));
                }
                metaAuthConfig.put("auth.kerberos.principal", serverAuthConfig.get("auth.kerberos.principal"));
                break;
            }
            case "ak/sk": {
                metaAuthConfig.put("auth.ak_sk.access_key", serverAuthConfig.get("auth.ak_sk.access_key"));
                metaAuthConfig.put("auth.ak_sk.secret_key", serverAuthConfig.get("auth.ak_sk.secret_key"));
                MixedCatalogUtil.copyProperty(serverAuthConfig, (Map)catalogMeta.getCatalogProperties(), (String)"auth.ak_sk.access_key", (String)"s3.access-key-id");
                MixedCatalogUtil.copyProperty(serverAuthConfig, (Map)catalogMeta.getCatalogProperties(), (String)"auth.ak_sk.secret_key", (String)"s3.secret-access-key");
            }
        }
        catalogMeta.setAuthConfigs(metaAuthConfig);
    }

    private Map<String, Object> extractAuthConfigsFromCatalogMeta(String catalogName, CatalogMeta catalogMeta) {
        HashMap<String, Object> serverAuthConfig = new HashMap<String, Object>();
        Map metaAuthConfig = catalogMeta.getAuthConfigs();
        String authType = metaAuthConfig.getOrDefault("auth.type", "simple");
        serverAuthConfig.put("auth.type", authType.toUpperCase());
        switch (authType) {
            case "simple": {
                serverAuthConfig.put("auth.simple.hadoop_username", metaAuthConfig.get("auth.simple.hadoop_username"));
                break;
            }
            case "kerberos": {
                serverAuthConfig.put("auth.kerberos.principal", metaAuthConfig.get("auth.kerberos.principal"));
                serverAuthConfig.put("auth.kerberos.keytab", new CatalogSettingInfo.ConfigFileItem(catalogName + ".keytab", this.constructCatalogConfigFileUrl(catalogName, CONFIG_TYPE_AUTH, "auth.kerberos.keytab".replace("\\.", "-"))));
                serverAuthConfig.put("auth.kerberos.krb5", new CatalogSettingInfo.ConfigFileItem("krb5.conf", this.constructCatalogConfigFileUrl(catalogName, CONFIG_TYPE_AUTH, "auth.kerberos.krb5".replace("\\.", "-"))));
                break;
            }
            case "ak/sk": {
                MixedCatalogUtil.copyProperty((Map)catalogMeta.getCatalogProperties(), serverAuthConfig, (String)"s3.access-key-id", (String)"auth.ak_sk.access_key");
                MixedCatalogUtil.copyProperty((Map)catalogMeta.getCatalogProperties(), serverAuthConfig, (String)"s3.secret-access-key", (String)"auth.ak_sk.secret_key");
            }
        }
        return serverAuthConfig;
    }

    private Map<String, Object> extractStorageConfigsFromCatalogMeta(String catalogName, CatalogMeta catalogMeta) {
        HashMap<String, Object> storageConfig = new HashMap<String, Object>();
        Map config = catalogMeta.getStorageConfigs();
        String storageType = MixedCatalogUtil.getCompatibleStorageType((Map)config);
        storageConfig.put("storage.type", storageType);
        if ("Hadoop".equals(storageType)) {
            storageConfig.put("hadoop.core.site", new CatalogSettingInfo.ConfigFileItem("core-site.xml", this.constructCatalogConfigFileUrl(catalogName, CONFIG_TYPE_STORAGE, "hadoop.core.site".replace("\\.", "-"))));
            storageConfig.put("hadoop.hdfs.site", new CatalogSettingInfo.ConfigFileItem("hdfs-site.xml", this.constructCatalogConfigFileUrl(catalogName, CONFIG_TYPE_STORAGE, "hadoop.hdfs.site".replace("\\.", "-"))));
            storageConfig.put("hive.site", new CatalogSettingInfo.ConfigFileItem("hive-site.xml", this.constructCatalogConfigFileUrl(catalogName, CONFIG_TYPE_STORAGE, "hive.site".replace("\\.", "-"))));
        } else if ("S3".equals(storageType)) {
            MixedCatalogUtil.copyProperty((Map)catalogMeta.getCatalogProperties(), storageConfig, (String)"client.region", (String)"storage.s3.region");
            MixedCatalogUtil.copyProperty((Map)catalogMeta.getCatalogProperties(), storageConfig, (String)"s3.endpoint", (String)"storage.s3.endpoint");
        }
        return storageConfig;
    }

    private CatalogMeta constructCatalogMeta(CatalogRegisterInfo info, CatalogMeta oldCatalogMeta) {
        String tableFormats;
        CatalogMeta catalogMeta = new CatalogMeta();
        catalogMeta.setCatalogName(info.getName());
        catalogMeta.setCatalogType(info.getType());
        catalogMeta.setCatalogProperties(PropertiesUtil.unionCatalogProperties(info.getTableProperties(), info.getProperties()));
        if ("glue".equals(info.getType())) {
            catalogMeta.putToCatalogProperties("catalog-impl", GlueCatalog.class.getName());
        }
        catalogMeta.putToCatalogProperties("table.self-optimizing.group", info.getOptimizerGroup());
        try {
            tableFormats = info.getTableFormatList().stream().map(item -> TableFormat.valueOf((String)item).name()).collect(Collectors.joining(","));
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid table format list, " + String.join((CharSequence)",", info.getTableFormatList()));
        }
        catalogMeta.getCatalogProperties().put("table-formats", tableFormats);
        this.fillAuthConfigs2CatalogMeta(catalogMeta, info.getAuthConfig(), oldCatalogMeta);
        HashMap<String, String> metaStorageConfig = new HashMap<String, String>();
        String storageType = info.getStorageConfig().getOrDefault("storage.type", "Hadoop");
        metaStorageConfig.put("storage.type", storageType);
        if (storageType.equals("Hadoop")) {
            List<String> metaKeyList = Arrays.asList("hadoop.hdfs.site", "hadoop.core.site", "hive.site");
            boolean fillUseOld = oldCatalogMeta != null;
            for (int idx = 0; idx < metaKeyList.size(); ++idx) {
                String fileSite;
                String fileId = info.getStorageConfig().get(metaKeyList.get(idx));
                if (!StringUtils.isEmpty((String)fileId)) {
                    metaStorageConfig.put(metaKeyList.get(idx), StringUtils.isEmpty((String)(fileSite = this.platformFileInfoService.getFileContentB64ById(Integer.valueOf(fileId)))) ? EMPTY_XML_BASE64 : fileSite);
                    continue;
                }
                if (fillUseOld) {
                    metaStorageConfig.put(metaKeyList.get(idx), StringUtils.isEmpty((String)(fileSite = (String)oldCatalogMeta.getStorageConfigs().get(metaKeyList.get(idx)))) ? EMPTY_XML_BASE64 : fileSite);
                    continue;
                }
                metaStorageConfig.put(metaKeyList.get(idx), EMPTY_XML_BASE64);
            }
        } else if (storageType.equals("S3")) {
            MixedCatalogUtil.copyProperty(info.getStorageConfig(), (Map)catalogMeta.getCatalogProperties(), (String)"storage.s3.region", (String)"client.region");
            MixedCatalogUtil.copyProperty(info.getStorageConfig(), (Map)catalogMeta.getCatalogProperties(), (String)"storage.s3.endpoint", (String)"s3.endpoint");
        } else {
            throw new RuntimeException("Invalid storage type " + storageType);
        }
        catalogMeta.setStorageConfigs(metaStorageConfig);
        return catalogMeta;
    }

    private void checkHiddenProperties(CatalogRegisterInfo info) {
        CatalogController.getHiddenCatalogTableProperties().stream().filter(info.getTableProperties()::containsKey).findAny().ifPresent(hiddenCatalogTableProperty -> {
            throw new IllegalArgumentException(String.format("Table property %s is not allowed to set", hiddenCatalogTableProperty));
        });
        CatalogController.getHiddenCatalogProperties(info).stream().filter(info.getProperties()::containsKey).findAny().ifPresent(hiddenCatalogProperty -> {
            throw new IllegalArgumentException(String.format("Catalog property %s is not allowed to set", hiddenCatalogProperty));
        });
    }

    private void removeHiddenProperties(CatalogSettingInfo info) {
        CatalogController.getHiddenCatalogTableProperties().forEach(info.getTableProperties()::remove);
        CatalogController.getHiddenCatalogProperties(info).forEach(info.getProperties()::remove);
    }

    private void maskSensitiveData(CatalogSettingInfo info) {
        if (info.getAuthConfig().containsKey("auth.ak_sk.secret_key")) {
            info.getAuthConfig().put("auth.ak_sk.secret_key", DesensitizationUtil.desensitize(info.getAuthConfig().get("auth.ak_sk.secret_key")));
        }
    }

    private void unMaskSensitiveData(CatalogRegisterInfo newInfo, CatalogMeta oldCatalogMeta) {
        String secretKey;
        if (newInfo.getAuthConfig().containsKey("auth.ak_sk.secret_key") && DesensitizationUtil.isDesensitized(secretKey = newInfo.getAuthConfig().get("auth.ak_sk.secret_key"))) {
            Preconditions.checkArgument((boolean)oldCatalogMeta.getCatalogProperties().containsKey("s3.secret-access-key"), (Object)"Secret key is not set before\uff0cmust provide a valid secret key");
            newInfo.getAuthConfig().put("auth.ak_sk.secret_key", (String)oldCatalogMeta.getCatalogProperties().get("s3.secret-access-key"));
        }
    }

    public void createCatalog(Context ctx) {
        CatalogRegisterInfo info = (CatalogRegisterInfo)ctx.bodyAsClass(CatalogRegisterInfo.class);
        this.validateCatalogRegisterInfo(info);
        if (this.tableService.catalogExist(info.getName())) {
            throw new RuntimeException("Duplicate catalog name!");
        }
        CatalogMeta catalogMeta = this.constructCatalogMeta(info, null);
        this.tableService.createCatalog(catalogMeta);
        ctx.json(OkResponse.of(""));
    }

    private void validateCatalogRegisterInfo(CatalogRegisterInfo info) {
        Preconditions.checkNotNull(info.getAuthConfig(), (Object)"Catalog auth config must not be null");
        Preconditions.checkNotNull(info.getStorageConfig(), (Object)"Catalog storage config must not be null");
        Preconditions.checkNotNull(info.getProperties(), (Object)"Catalog properties must not be null");
        Preconditions.checkNotNull(info.getTableProperties(), (Object)"Catalog table properties must not be null");
        Preconditions.checkArgument((info.getTableFormatList() != null && !info.getTableFormatList().isEmpty() ? 1 : 0) != 0, (Object)"Catalog table format list must not be empty");
        CatalogDescriptor.of(info).validate();
        this.checkHiddenProperties(info);
        List<String> requiredProperties = CATALOG_REQUIRED_PROPERTIES.get(info.getType());
        if (requiredProperties != null && !requiredProperties.isEmpty()) {
            for (String propertyName : requiredProperties) {
                Preconditions.checkArgument((boolean)info.getProperties().containsKey(propertyName), (Object)String.format("Catalog type:%s require property:%s.", info.getType(), propertyName));
            }
        }
    }

    public void getCatalogDetail(Context ctx) {
        String catalogName = ctx.pathParam("catalogName");
        CatalogMeta catalogMeta = this.tableService.getCatalogMeta(catalogName);
        CatalogSettingInfo info = new CatalogSettingInfo();
        if (this.tableService.catalogExist(catalogName)) {
            info.setName(catalogMeta.getCatalogName());
            if ("hadoop".equals(catalogMeta.getCatalogType()) && !catalogMeta.getCatalogProperties().containsKey("table-formats")) {
                info.setType("ams");
            } else {
                info.setType(catalogMeta.getCatalogType());
            }
            info.setAuthConfig(this.extractAuthConfigsFromCatalogMeta(catalogName, catalogMeta));
            info.setStorageConfig(this.extractStorageConfigsFromCatalogMeta(catalogName, catalogMeta));
            String tableFormat = (String)catalogMeta.getCatalogProperties().get("table-formats");
            if (StringUtils.isEmpty((String)tableFormat)) {
                tableFormat = catalogMeta.getCatalogType().equals("hive") ? TableFormat.MIXED_HIVE.name() : TableFormat.MIXED_ICEBERG.name();
            }
            info.setTableFormatList(Arrays.asList(tableFormat.split(",")));
            info.setProperties(PropertiesUtil.extractCatalogMetaProperties(catalogMeta.getCatalogProperties()));
            info.setTableProperties(PropertiesUtil.extractTableProperties(catalogMeta.getCatalogProperties()));
            info.setOptimizerGroup(info.getTableProperties().getOrDefault("self-optimizing.group", "default"));
            this.removeHiddenProperties(info);
            this.maskSensitiveData(info);
            ctx.json(OkResponse.of(info));
            return;
        }
        ctx.json(OkResponse.of(null));
    }

    public void updateCatalog(Context ctx) {
        CatalogRegisterInfo info = (CatalogRegisterInfo)ctx.bodyAsClass(CatalogRegisterInfo.class);
        this.validateCatalogRegisterInfo(info);
        CatalogMeta optCatalog = this.tableService.getCatalogMeta(info.getName());
        Preconditions.checkNotNull((Object)optCatalog, (Object)"Catalog not exist!");
        this.unMaskSensitiveData(info, optCatalog);
        CatalogMeta catalogMeta = this.constructCatalogMeta(info, optCatalog);
        this.tableService.updateCatalog(catalogMeta);
        ctx.json(OkResponse.ok());
    }

    public void catalogDeleteCheck(Context ctx) {
        String catalogName = ctx.pathParam("catalogName");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)ctx.pathParam("catalogName")), (Object)"Catalog name is empty!");
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalogName);
        if (serverCatalog instanceof InternalCatalog) {
            ctx.json(OkResponse.of(serverCatalog.listTables().size() == 0));
        } else {
            ctx.json(OkResponse.of(true));
        }
    }

    public void deleteCatalog(Context ctx) {
        String catalogName = ctx.pathParam("catalogName");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)ctx.pathParam("catalogName")), (Object)"Catalog name is empty!");
        this.tableService.dropCatalog(catalogName);
        ctx.json(OkResponse.of("OK"));
    }

    private String constructCatalogConfigFileUrl(String catalogName, String type, String key) {
        return String.format("/ams/v1/catalogs/%s/config/%s/%s", catalogName, type, key.replaceAll("\\.", "-"));
    }

    public void getCatalogConfFileContent(Context ctx) {
        String catalogName = ctx.pathParam("catalogName");
        String confType = ctx.pathParam("type");
        String configKey = ctx.pathParam("key");
        Preconditions.checkArgument((StringUtils.isNotEmpty((String)catalogName) && StringUtils.isNotEmpty((String)confType) && StringUtils.isNotEmpty((String)configKey) ? 1 : 0) != 0, (Object)"Catalog name or auth type or config key is null!");
        CatalogMeta catalogMeta = this.tableService.getCatalogMeta(catalogName);
        if (CONFIG_TYPE_STORAGE.equalsIgnoreCase(confType)) {
            Map storageConfig = catalogMeta.getStorageConfigs();
            String key = configKey.replaceAll("-", "\\.");
            ctx.result(Base64.getDecoder().decode((String)storageConfig.get(key)));
        } else if (CONFIG_TYPE_AUTH.equalsIgnoreCase(confType)) {
            Map storageConfig = catalogMeta.getAuthConfigs();
            String key = configKey.replaceAll("-", "\\.");
            ctx.result(Base64.getDecoder().decode((String)storageConfig.get(key)));
        } else {
            throw new RuntimeException("Invalid request for " + confType);
        }
    }

    static {
        CATALOG_REQUIRED_PROPERTIES.put("ams", Lists.newArrayList((Object[])new String[]{"warehouse"}));
        CATALOG_REQUIRED_PROPERTIES.put("hadoop", Lists.newArrayList((Object[])new String[]{"warehouse"}));
        CATALOG_REQUIRED_PROPERTIES.put("glue", Lists.newArrayList((Object[])new String[]{"warehouse"}));
        CATALOG_REQUIRED_PROPERTIES.put("custom", Lists.newArrayList((Object[])new String[]{"catalog-impl"}));
        VALIDATE_CATALOGS = Sets.newHashSet();
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("ams", "S3", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("ams", "S3", TableFormat.MIXED_ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("ams", "Hadoop", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("ams", "Hadoop", TableFormat.MIXED_ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hive", "Hadoop", TableFormat.MIXED_ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hive", "Hadoop", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hive", "Hadoop", TableFormat.MIXED_HIVE));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hive", "Hadoop", TableFormat.PAIMON));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hadoop", "Hadoop", TableFormat.MIXED_ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hadoop", "Hadoop", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hadoop", "Hadoop", TableFormat.PAIMON));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("hadoop", "S3", TableFormat.PAIMON));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("glue", "S3", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("glue", "S3", TableFormat.MIXED_ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("custom", "S3", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("custom", "Hadoop", TableFormat.ICEBERG));
        VALIDATE_CATALOGS.add(CatalogDescriptor.of("custom", "Hadoop", TableFormat.MIXED_ICEBERG));
    }

    private static class CatalogDescriptor {
        private final String catalogType;
        private final String storageType;
        private final TableFormat tableFormat;

        public CatalogDescriptor(String catalogType, String storageType, TableFormat tableFormat) {
            this.catalogType = catalogType;
            this.storageType = storageType;
            this.tableFormat = tableFormat;
        }

        public static CatalogDescriptor of(String catalogType, String storageType, TableFormat tableFormat) {
            return new CatalogDescriptor(catalogType, storageType, tableFormat);
        }

        public static CatalogDescriptor of(CatalogRegisterInfo info) {
            String tableFormat = info.getTableFormatList().get(0);
            String storageType = info.getStorageConfig().get("storage.type");
            String catalogType = info.getType();
            return CatalogDescriptor.of(catalogType, storageType, TableFormat.valueOf((String)tableFormat));
        }

        public void validate() {
            Preconditions.checkArgument((boolean)VALIDATE_CATALOGS.contains(this), (Object)("Not support " + this));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CatalogDescriptor that = (CatalogDescriptor)o;
            return Objects.equal((Object)this.catalogType, (Object)that.catalogType) && Objects.equal((Object)this.storageType, (Object)that.storageType) && this.tableFormat == that.tableFormat;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.catalogType, this.storageType, this.tableFormat});
        }

        public String toString() {
            return String.format("Metastore [%s], Storage Type [%s], Table Format [%s]", this.catalogType, this.storageType, this.tableFormat);
        }
    }
}

