/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.component.reverser;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.server.dashboard.component.reverser.MetadataChangeHandler;
import org.apache.amoro.server.dashboard.component.reverser.TableMetaExtract;

public class SparkMetadataChangeHandler
implements MetadataChangeHandler {
    private static final String ALTER_TABLE = "ALTER TABLE %s";
    private static final String ADD_COLUMN = " ADD COLUMNS %s";
    private static final String ALTER_COLUMN = " ALTER COLUMN %s";
    private static final String RENAME_COLUMN = " RENAME COLUMN %s TO %s";
    private static final String DROP_COLUMNS = " DROP COLUMN %s";
    private static final String SET_PROPERTIES = " SET TBLPROPERTIES (%s)";
    private static final String UNSET_PROPERTIES = " UNSET TBLPROPERTIES (%s)";
    private static final String IS_OPTIONAL = " DROP NOT NULL";
    private static final String NOT_OPTIONAL = " SET NOT NULL";
    private static final String DOC = " COMMENT '%s'";
    private static final String TYPE = " TYPE %s";
    private final String tableName;

    public SparkMetadataChangeHandler(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String changeAndAddProperties(Map<String, String> diffProperties) {
        String template = "ALTER TABLE %s SET TBLPROPERTIES (%s)";
        String properties = diffProperties.entrySet().stream().map(entry -> String.format("'%s' = '%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
        return String.format(template, this.tableName, properties);
    }

    @Override
    public String removeProperties(Set<String> removeKeys) {
        String template = "ALTER TABLE %s UNSET TBLPROPERTIES (%s)";
        String properties = removeKeys.stream().map(key -> String.format("'%s'", key)).collect(Collectors.joining(","));
        return String.format(template, this.tableName, properties);
    }

    @Override
    public String addNewColumns(List<TableMetaExtract.InternalSchema> newSchemas) {
        String template = "ALTER TABLE %s ADD COLUMNS %s";
        return String.format(template, this.tableName, newSchemas.stream().map(TableMetaExtract.InternalSchema::columnString).collect(Collectors.joining(",", "(", ")")));
    }

    @Override
    public String renameColumnName(String oldName, String newName) {
        String template = "ALTER TABLE %s RENAME COLUMN %s TO %s";
        return String.format(template, this.tableName, oldName, newName);
    }

    @Override
    public String dropColumns(Set<String> dropColumns) {
        String template = "ALTER TABLE %s DROP COLUMN %s";
        return String.format(template, this.tableName, String.join((CharSequence)",", dropColumns));
    }

    @Override
    public String changeColumnsRequire(String columnName, boolean required) {
        String template = "ALTER TABLE %s ALTER COLUMN %s" + (required ? IS_OPTIONAL : NOT_OPTIONAL);
        return String.format(template, this.tableName, columnName);
    }

    @Override
    public String changeColumnsComment(String columnName, String comment) {
        String template = "ALTER TABLE %s ALTER COLUMN %s COMMENT '%s'";
        return String.format(template, this.tableName, columnName, comment);
    }

    @Override
    public String changeColumnType(String columnName, String newType) {
        String template = "ALTER TABLE %s ALTER COLUMN %s TYPE %s";
        return String.format(template, this.tableName, columnName, newType);
    }
}

