/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.Map;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.formats.iceberg.IcebergTable;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.exception.ObjectNotExistsException;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalIcebergCreator;
import org.apache.amoro.server.table.internal.InternalIcebergHandler;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.requests.CreateTableRequest;

public class InternalIcebergCatalogImpl
extends InternalCatalog {
    private static final String URI = "uri";
    final int httpPort;
    final String exposedHost;

    protected InternalIcebergCatalogImpl(CatalogMeta metadata, Configurations serverConfiguration) {
        super(metadata);
        this.httpPort = serverConfiguration.getInteger(AmoroManagementConf.HTTP_SERVER_PORT);
        this.exposedHost = serverConfiguration.getString(AmoroManagementConf.SERVER_EXPOSE_HOST);
    }

    @Override
    public CatalogMeta getMetadata() {
        CatalogMeta meta = super.getMetadata();
        if (!meta.getCatalogProperties().containsKey(URI)) {
            meta.putToCatalogProperties(URI, this.defaultRestURI());
        }
        meta.putToCatalogProperties("catalog-impl", RESTCatalog.class.getName());
        return meta.deepCopy();
    }

    @Override
    public void updateMetadata(CatalogMeta metadata) {
        String uri;
        String defaultUrl = this.defaultRestURI();
        if (defaultUrl.equals(uri = metadata.getCatalogProperties().getOrDefault(URI, defaultUrl))) {
            metadata.getCatalogProperties().remove(URI);
        }
        super.updateMetadata(metadata);
    }

    @Override
    public AmoroTable<?> loadTable(String database, String tableName) {
        InternalTableHandler handler;
        try {
            handler = this.newTableHandler(database, tableName);
        }
        catch (ObjectNotExistsException e) {
            return null;
        }
        TableMetadata tableMetadata = handler.tableMetadata();
        TableOperations ops = (TableOperations)handler.newTableOperator();
        BaseTable table = new BaseTable(ops, TableIdentifier.of((String[])new String[]{tableMetadata.getTableIdentifier().getDatabase(), tableMetadata.getTableIdentifier().getTableName()}).toString());
        org.apache.amoro.table.TableIdentifier tableIdentifier = org.apache.amoro.table.TableIdentifier.of((String)this.name(), (String)database, (String)tableName);
        return IcebergTable.newIcebergTable((org.apache.amoro.table.TableIdentifier)tableIdentifier, (Table)table, (TableMetaStore)MixedCatalogUtil.buildMetaStore((CatalogMeta)this.getMetadata()), (Map)this.getMetadata().getCatalogProperties());
    }

    protected AuthenticatedFileIO fileIO(CatalogMeta catalogMeta) {
        return InternalTableUtil.newIcebergFileIo(catalogMeta);
    }

    private String defaultRestURI() {
        return "http://" + this.exposedHost + ":" + this.httpPort + "/api/iceberg/rest";
    }

    @Override
    public InternalTableCreator newTableCreator(String database, String tableName, TableFormat format, CreateTableRequest creatorArguments) {
        Preconditions.checkArgument((format == this.format() ? 1 : 0) != 0, (String)"the catalog only support to create %s table", (Object)this.format().name());
        if (this.tableExists(database, tableName)) {
            throw new AlreadyExistsException("Table " + this.name() + "." + database + "." + tableName + " already exists.", new Object[0]);
        }
        return this.newTableCreator(database, tableName, creatorArguments);
    }

    protected TableFormat format() {
        return TableFormat.ICEBERG;
    }

    protected InternalTableCreator newTableCreator(String database, String tableName, CreateTableRequest request) {
        return new InternalIcebergCreator(this.getMetadata(), database, tableName, request);
    }

    @Override
    public <O> InternalTableHandler<O> newTableHandler(String database, String tableName) {
        TableMetadata metadata = this.loadTableMetadata(database, tableName);
        Preconditions.checkState((metadata.getFormat() == this.format() ? 1 : 0) != 0, (String)"the catalog only support to handle %s table", (Object)this.format().name());
        return new InternalIcebergHandler(this.getMetadata(), metadata);
    }
}

