/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import org.apache.amoro.TableFormat;
import org.apache.amoro.spark.SparkUnifiedCatalog;
import org.apache.amoro.spark.SparkUnifiedCatalogBase;
import org.apache.amoro.spark.SparkUnifiedSessionCatalogBase;
import org.apache.iceberg.spark.functions.SparkFunctions;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkUnifiedSessionCatalog<T extends TableCatalog & SupportsNamespaces>
extends SparkUnifiedSessionCatalogBase<T> {
    protected SparkUnifiedCatalogBase createUnifiedCatalog(String name, CaseInsensitiveStringMap options) {
        return new SparkUnifiedCatalog();
    }

    public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        try {
            TableCatalog catalog = this.getTargetCatalog();
            SparkUnifiedCatalogBase unifiedCatalog = (SparkUnifiedCatalogBase)catalog;
            return unifiedCatalog.tableCatalog(TableFormat.ICEBERG).loadTable(ident, version);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            return this.getSessionCatalog().loadTable(ident, version);
        }
    }

    public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        try {
            TableCatalog catalog = this.getTargetCatalog();
            SparkUnifiedCatalogBase unifiedCatalog = (SparkUnifiedCatalogBase)catalog;
            return unifiedCatalog.tableCatalog(TableFormat.ICEBERG).loadTable(ident, timestamp);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            return this.getSessionCatalog().loadTable(ident, timestamp);
        }
    }

    public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        SparkUnifiedCatalog catalog = (SparkUnifiedCatalog)this.getTargetCatalog();
        return catalog.listFunctions(namespace);
    }

    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        UnboundFunction func;
        String[] namespace = ident.namespace();
        String name = ident.name();
        if ((namespace.length == 0 || SparkUnifiedSessionCatalog.isSystemNamespace(namespace)) && (func = SparkFunctions.load((String)name)) != null) {
            return func;
        }
        throw new NoSuchFunctionException(ident);
    }

    private static boolean isSystemNamespace(String[] namespace) {
        return namespace.length == 1 && namespace[0].equalsIgnoreCase("system");
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException, NonEmptyNamespaceException {
        SparkUnifiedCatalog catalog = (SparkUnifiedCatalog)this.getTargetCatalog();
        return catalog.dropNamespace(namespace, cascade);
    }
}

