/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.spark.sql.utils.ProjectingInternalRow;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.Seq;

public class SparkInternalRowCastWrapper
extends GenericInternalRow {
    private final InternalRow row;
    private final StructType schema;
    private ChangeAction changeAction = ChangeAction.INSERT;
    private List<DataType> dataTypeList;

    public SparkInternalRowCastWrapper(InternalRow row, ChangeAction changeAction, StructType schema) {
        this.row = row;
        this.changeAction = changeAction;
        this.schema = row instanceof ProjectingInternalRow ? ((ProjectingInternalRow)row).schema() : schema;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public Object genericGet(int ordinal) {
        return this.row.get(ordinal, this.schema.apply(ordinal).dataType());
    }

    public Seq<Object> toSeq(Seq<DataType> fieldTypes) {
        return super.toSeq(fieldTypes);
    }

    public int numFields() {
        return this.schema.size() / 2;
    }

    public void setNullAt(int i) {
        super.setNullAt(i);
    }

    public void update(int i, Object value) {
        super.update(i, value);
    }

    public boolean isNullAt(int ordinal) {
        this.dataTypeList = Arrays.stream(this.schema.fields()).map(StructField::dataType).collect(Collectors.toList());
        return this.row.get(ordinal, this.dataTypeList.get(ordinal)) == null;
    }

    public Object get(int pos, DataType dt) {
        return this.row.get(pos, dt);
    }

    public boolean getBoolean(int ordinal) {
        return super.getBoolean(ordinal);
    }

    public byte getByte(int ordinal) {
        return super.getByte(ordinal);
    }

    public short getShort(int ordinal) {
        return super.getShort(ordinal);
    }

    public int getInt(int ordinal) {
        return super.getInt(ordinal);
    }

    public long getLong(int ordinal) {
        return super.getLong(ordinal);
    }

    public float getFloat(int ordinal) {
        return super.getFloat(ordinal);
    }

    public double getDouble(int ordinal) {
        return super.getDouble(ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return super.getDecimal(ordinal, precision, scale);
    }

    public UTF8String getUTF8String(int ordinal) {
        return super.getUTF8String(ordinal);
    }

    public byte[] getBinary(int ordinal) {
        return super.getBinary(ordinal);
    }

    public ArrayData getArray(int ordinal) {
        return super.getArray(ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        return super.getInterval(ordinal);
    }

    public MapData getMap(int ordinal) {
        return super.getMap(ordinal);
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return super.getStruct(ordinal, numFields);
    }

    public InternalRow getRow() {
        return this.row;
    }

    public ChangeAction getChangeAction() {
        return this.changeAction;
    }

    public String toString() {
        return super.toString();
    }

    public GenericInternalRow copy() {
        return super.copy();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object[] values() {
        return super.values();
    }

    public InternalRow setFileOffset(Long fileOffset) {
        List dataTypeList = Arrays.stream(this.schema.fields()).map(StructField::dataType).collect(Collectors.toList());
        ArrayList<Long> objectSeq = new ArrayList<Long>(dataTypeList.size() + 1);
        this.row.toSeq(this.schema).toStream().foreach(objectSeq::add);
        objectSeq.add(fileOffset);
        return new GenericInternalRow(objectSeq.toArray());
    }
}

