/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.util.Preconditions;

class WorkerCounter {
    private final Map<WorkerResourceSpec, Integer> workerNums = new HashMap<WorkerResourceSpec, Integer>();

    WorkerCounter() {
    }

    int getTotalNum() {
        return this.workerNums.values().stream().reduce(0, Integer::sum);
    }

    int getNum(WorkerResourceSpec workerResourceSpec) {
        return this.workerNums.getOrDefault(Preconditions.checkNotNull((Object)workerResourceSpec), 0);
    }

    int increaseAndGet(WorkerResourceSpec workerResourceSpec) {
        return this.workerNums.compute((WorkerResourceSpec)Preconditions.checkNotNull((Object)workerResourceSpec), (ignored, num) -> num != null ? num + 1 : 1);
    }

    int decreaseAndGet(WorkerResourceSpec workerResourceSpec) {
        Integer newValue = this.workerNums.compute((WorkerResourceSpec)Preconditions.checkNotNull((Object)workerResourceSpec), (ignored, num) -> {
            Preconditions.checkState((num != null && num > 0 ? 1 : 0) != 0, (String)"Cannot decrease, no worker of spec %s.", (Object[])new Object[]{workerResourceSpec});
            return num == 1 ? null : Integer.valueOf(num - 1);
        });
        return newValue != null ? newValue : 0;
    }
}

