/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

final class CheckpointStartRequest
extends ChannelStateWriteRequest {
    private final ChannelStateWriter.ChannelStateWriteResult targetResult;
    private final CheckpointStorageLocationReference locationReference;

    CheckpointStartRequest(JobVertexID jobVertexID, int subtaskIndex, long checkpointId, ChannelStateWriter.ChannelStateWriteResult targetResult, CheckpointStorageLocationReference locationReference) {
        super(jobVertexID, subtaskIndex, checkpointId, "Start");
        this.targetResult = (ChannelStateWriter.ChannelStateWriteResult)Preconditions.checkNotNull((Object)targetResult);
        this.locationReference = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)locationReference);
    }

    ChannelStateWriter.ChannelStateWriteResult getTargetResult() {
        return this.targetResult;
    }

    public CheckpointStorageLocationReference getLocationReference() {
        return this.locationReference;
    }

    @Override
    public void cancel(Throwable cause) {
        this.targetResult.fail(cause);
    }
}

