/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniClusterClient
implements ClusterClient<MiniClusterId> {
    private static final Logger LOG = LoggerFactory.getLogger(MiniClusterClient.class);
    private final MiniCluster miniCluster;
    private final Configuration configuration;

    public MiniClusterClient(@Nonnull Configuration configuration, @Nonnull MiniCluster miniCluster) {
        this.configuration = configuration;
        this.miniCluster = miniCluster;
    }

    @Override
    public Configuration getFlinkConfiguration() {
        return new Configuration(this.configuration);
    }

    @Override
    public CompletableFuture<JobID> submitJob(@Nonnull JobGraph jobGraph) {
        return this.miniCluster.submitJob(jobGraph).thenApply(JobSubmissionResult::getJobID);
    }

    @Override
    public CompletableFuture<JobResult> requestJobResult(@Nonnull JobID jobId) {
        return this.miniCluster.requestJobResult(jobId);
    }

    @Override
    public CompletableFuture<Acknowledge> cancel(JobID jobId) {
        return this.miniCluster.cancelJob(jobId);
    }

    @Override
    public CompletableFuture<String> cancelWithSavepoint(JobID jobId, @Nullable String savepointDirectory, SavepointFormatType formatType) {
        return this.miniCluster.triggerSavepoint(jobId, savepointDirectory, true, formatType);
    }

    @Override
    public CompletableFuture<String> stopWithSavepoint(JobID jobId, boolean advanceToEndOfEventTime, @Nullable String savepointDirectory, SavepointFormatType formatType) {
        return this.miniCluster.stopWithSavepoint(jobId, savepointDirectory, advanceToEndOfEventTime, formatType);
    }

    @Override
    public CompletableFuture<String> triggerSavepoint(JobID jobId, @Nullable String savepointDirectory, SavepointFormatType formatType) {
        return this.miniCluster.triggerSavepoint(jobId, savepointDirectory, false, formatType);
    }

    @Override
    public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath) {
        return this.miniCluster.disposeSavepoint(savepointPath);
    }

    @Override
    public CompletableFuture<Collection<JobStatusMessage>> listJobs() {
        return this.miniCluster.listJobs();
    }

    @Override
    public CompletableFuture<Map<String, Object>> getAccumulators(JobID jobID, ClassLoader loader) {
        return ((CompletableFuture)this.miniCluster.getExecutionGraph(jobID).thenApply(AccessExecutionGraph::getAccumulatorsSerialized)).thenApply(accumulators -> {
            try {
                return AccumulatorHelper.deserializeAndUnwrapAccumulators((Map)accumulators, (ClassLoader)loader);
            }
            catch (Exception e) {
                throw new CompletionException("Cannot deserialize and unwrap accumulators properly.", e);
            }
        });
    }

    @Override
    public CompletableFuture<JobStatus> getJobStatus(JobID jobId) {
        return this.miniCluster.getJobStatus(jobId);
    }

    @Override
    public void close() {
    }

    @Override
    public MiniClusterId getClusterId() {
        return MiniClusterId.INSTANCE;
    }

    @Override
    public void shutDownCluster() {
        try {
            this.miniCluster.closeAsync().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Error while shutting down cluster", (Throwable)e);
        }
    }

    @Override
    public String getWebInterfaceURL() {
        try {
            return ((URI)this.miniCluster.getRestAddress().get()).toString();
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtils.checkInterrupted((Throwable)e);
            LOG.warn("Could not retrieve the web interface URL for the cluster.", (Throwable)e);
            return "Unknown address.";
        }
    }

    @Override
    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(JobID jobId, OperatorID operatorId, CoordinationRequest request) {
        try {
            SerializedValue serializedRequest = new SerializedValue((Object)request);
            return this.miniCluster.deliverCoordinationRequestToCoordinator(jobId, operatorId, serializedRequest);
        }
        catch (IOException e) {
            LOG.error("Error while sending coordination request", (Throwable)e);
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Set<AbstractID>> listCompletedClusterDatasetIds() {
        return this.miniCluster.listCompletedClusterDatasetIds();
    }

    @Override
    public CompletableFuture<Void> invalidateClusterDataset(AbstractID clusterDatasetId) {
        return this.miniCluster.invalidateClusterDataset((AbstractID)new IntermediateDataSetID(clusterDatasetId));
    }

    @Override
    public CompletableFuture<Void> reportHeartbeat(JobID jobId, long expiredTimestamp) {
        return this.miniCluster.reportHeartbeat(jobId, expiredTimestamp);
    }

    public static enum MiniClusterId {
        INSTANCE;

    }
}

