/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.ListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.Exceptions;
import org.apache.iceberg.util.Tasks;

abstract class ManifestMergeManager<F extends ContentFile<F>> {
    private final long targetSizeBytes;
    private final int minCountToMerge;
    private final boolean mergeEnabled;
    private final Map<List<ManifestFile>, ManifestFile> mergedManifests = Maps.newConcurrentMap();
    private final Supplier<ExecutorService> workerPoolSupplier;

    ManifestMergeManager(long targetSizeBytes, int minCountToMerge, boolean mergeEnabled, Supplier<ExecutorService> executorSupplier) {
        this.targetSizeBytes = targetSizeBytes;
        this.minCountToMerge = minCountToMerge;
        this.mergeEnabled = mergeEnabled;
        this.workerPoolSupplier = executorSupplier;
    }

    protected abstract long snapshotId();

    protected abstract PartitionSpec spec(int var1);

    protected abstract void deleteFile(String var1);

    protected abstract ManifestWriter<F> newManifestWriter(PartitionSpec var1);

    protected abstract ManifestReader<F> newManifestReader(ManifestFile var1);

    Iterable<ManifestFile> mergeManifests(Iterable<ManifestFile> manifests) {
        Iterator<ManifestFile> manifestIter = manifests.iterator();
        if (!this.mergeEnabled || !manifestIter.hasNext()) {
            return manifests;
        }
        ManifestFile first = manifestIter.next();
        ArrayList merged = Lists.newArrayList();
        ListMultimap<Integer, ManifestFile> groups = this.groupBySpec(first, manifestIter);
        for (Integer specId : groups.keySet()) {
            Iterables.addAll((Collection)merged, this.mergeGroup(first, specId, groups.get((Object)specId)));
        }
        return merged;
    }

    void cleanUncommitted(Set<ManifestFile> committed) {
        ArrayList entries = Lists.newArrayList(this.mergedManifests.entrySet());
        for (Map.Entry entry : entries) {
            ManifestFile merged = (ManifestFile)entry.getValue();
            if (committed.contains(merged)) continue;
            this.deleteFile(merged.path());
            this.mergedManifests.remove(entry.getKey());
        }
    }

    private ListMultimap<Integer, ManifestFile> groupBySpec(ManifestFile first, Iterator<ManifestFile> remaining) {
        ListMultimap groups = Multimaps.newListMultimap((Map)Maps.newTreeMap(Comparator.reverseOrder()), Lists::newArrayList);
        groups.put((Object)first.partitionSpecId(), (Object)first);
        remaining.forEachRemaining(manifest -> groups.put((Object)manifest.partitionSpecId(), manifest));
        return groups;
    }

    private Iterable<ManifestFile> mergeGroup(ManifestFile first, int specId, List<ManifestFile> group) {
        BinPacking.ListPacker<ManifestFile> packer = new BinPacking.ListPacker<ManifestFile>(this.targetSizeBytes, 1, false);
        List<List<ManifestFile>> bins = packer.packEnd(group, ManifestFile::length);
        Iterable[] binResults = (List[])Array.newInstance(List.class, bins.size());
        Tasks.range(bins.size()).stopOnFailure().throwFailureWhenFinished().executeWith(this.workerPoolSupplier.get()).run(arg_0 -> this.lambda$mergeGroup$1(bins, (List[])binResults, first, specId, arg_0));
        return Iterables.concat((Iterable[])binResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile createManifest(int specId, List<ManifestFile> bin) {
        if (this.mergedManifests.containsKey(bin)) {
            return this.mergedManifests.get(bin);
        }
        ManifestWriter<F> writer = this.newManifestWriter(this.spec(specId));
        boolean threw = true;
        try {
            for (ManifestFile manifest : bin) {
                try {
                    ManifestReader<F> reader = this.newManifestReader(manifest);
                    Throwable throwable = null;
                    try {
                        for (ManifestEntry entry : reader.entries()) {
                            if (entry.status() == ManifestEntry.Status.DELETED) {
                                if (entry.snapshotId().longValue() != this.snapshotId()) continue;
                                writer.delete(entry);
                                continue;
                            }
                            if (entry.status() == ManifestEntry.Status.ADDED && entry.snapshotId().longValue() == this.snapshotId()) {
                                writer.add(entry);
                                continue;
                            }
                            writer.existing(entry);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close manifest reader", new Object[0]);
                }
            }
            threw = false;
        }
        finally {
            Exceptions.close(writer, threw);
        }
        ManifestFile manifest = writer.toManifestFile();
        this.mergedManifests.put(bin, manifest);
        return manifest;
    }

    private /* synthetic */ void lambda$mergeGroup$1(List bins, List[] binResults, ManifestFile first, int specId, Integer index) throws RuntimeException {
        List bin = (List)bins.get(index);
        ArrayList outputManifests = Lists.newArrayList();
        binResults[index.intValue()] = outputManifests;
        if (bin.size() == 1) {
            outputManifests.add((ManifestFile)bin.get(0));
            return;
        }
        if (bin.contains(first) && bin.size() < this.minCountToMerge) {
            outputManifests.addAll(bin);
        } else {
            outputManifests.add(this.createManifest(specId, bin));
        }
    }
}

