/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.utils;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.IcebergBucketTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergDayTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergHourTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergMonthTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergTruncateTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergYearTransform;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.utils.DistributionAndOrderingUtils$BucketTransform$;
import org.apache.spark.sql.catalyst.utils.DistributionAndOrderingUtils$TruncateTransform$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.expressions.DaysTransform;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.MonthsTransform;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.YearsTransform;
import org.apache.spark.sql.internal.SQLConf;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.compat.immutable.ArraySeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class DistributionAndOrderingUtils$ {
    public static DistributionAndOrderingUtils$ MODULE$;

    static {
        new DistributionAndOrderingUtils$();
    }

    public LogicalPlan prepareQuery(Distribution requiredDistribution, org.apache.spark.sql.connector.expressions.SortOrder[] requiredOrdering, LogicalPlan query, SQLConf conf) {
        org.apache.spark.sql.catalyst.expressions.Expression[] expressionArray;
        Function2 resolver = conf.resolver();
        Distribution distribution = requiredDistribution;
        if (distribution instanceof OrderedDistribution) {
            OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
            expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orderedDistribution.ordering())).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.toCatalyst((Expression)e, query, (Function2<String, String, Object>)resolver), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class)));
        } else if (distribution instanceof ClusteredDistribution) {
            ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
            expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering())).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.toCatalyst((Expression)e, query, (Function2<String, String, Object>)resolver), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class)));
        } else if (distribution instanceof UnspecifiedDistribution) {
            expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
        } else {
            throw new MatchError((Object)distribution);
        }
        org.apache.spark.sql.catalyst.expressions.Expression[] distribution2 = expressionArray;
        LogicalPlan queryWithDistribution = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distribution2)).nonEmpty() ? new RepartitionByExpression(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distribution2)).toSeq(), query, (Option)None$.MODULE$) : query;
        SortOrder[] ordering = (SortOrder[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredOrdering)).map((Function1 & Serializable & scala.Serializable)e -> (SortOrder)MODULE$.toCatalyst((Expression)e, query, (Function2<String, String, Object>)resolver), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SortOrder.class)));
        LogicalPlan queryWithDistributionAndOrdering = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ordering)).nonEmpty() ? new Sort((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)ordering), false, queryWithDistribution) : queryWithDistribution;
        return queryWithDistributionAndOrdering;
    }

    private org.apache.spark.sql.catalyst.expressions.Expression toCatalyst(Expression expr, LogicalPlan query, Function2<String, String, Object> resolver) {
        Option<Tuple2<FieldReference, Object>> option;
        boolean bl = false;
        Transform transform = null;
        Expression expression = expr;
        if (expression instanceof org.apache.spark.sql.connector.expressions.SortOrder) {
            org.apache.spark.sql.connector.expressions.SortOrder sortOrder = (org.apache.spark.sql.connector.expressions.SortOrder)expression;
            org.apache.spark.sql.catalyst.expressions.Expression catalystChild = this.toCatalyst(sortOrder.expression(), query, resolver);
            return new SortOrder(catalystChild, this.toCatalyst(sortOrder.direction()), this.toCatalyst(sortOrder.nullOrdering()), (Seq)Nil$.MODULE$);
        }
        if (expression instanceof IdentityTransform) {
            IdentityTransform identityTransform = (IdentityTransform)expression;
            return (org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)identityTransform.ref().fieldNames()), query, resolver);
        }
        if (expression instanceof Transform) {
            bl = true;
            transform = (Transform)expression;
            Option<Tuple2<Object, FieldReference>> option2 = DistributionAndOrderingUtils$BucketTransform$.MODULE$.unapply(transform);
            if (!option2.isEmpty()) {
                int numBuckets = ((Tuple2)option2.get())._1$mcI$sp();
                FieldReference ref = (FieldReference)((Tuple2)option2.get())._2();
                return new IcebergBucketTransform(numBuckets, (org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)ref.fieldNames()), query, resolver));
            }
        }
        if (bl && !(option = DistributionAndOrderingUtils$TruncateTransform$.MODULE$.unapply(transform)).isEmpty()) {
            FieldReference ref = (FieldReference)((Tuple2)option.get())._1();
            int width = ((Tuple2)option.get())._2$mcI$sp();
            return new IcebergTruncateTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)ref.fieldNames()), query, resolver), width);
        }
        if (expression instanceof YearsTransform) {
            YearsTransform yearsTransform = (YearsTransform)expression;
            return new IcebergYearTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)yearsTransform.ref().fieldNames()), query, resolver));
        }
        if (expression instanceof MonthsTransform) {
            MonthsTransform monthsTransform = (MonthsTransform)expression;
            return new IcebergMonthTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)monthsTransform.ref().fieldNames()), query, resolver));
        }
        if (expression instanceof DaysTransform) {
            DaysTransform daysTransform = (DaysTransform)expression;
            return new IcebergDayTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)daysTransform.ref().fieldNames()), query, resolver));
        }
        if (expression instanceof HoursTransform) {
            HoursTransform hoursTransform = (HoursTransform)expression;
            return new IcebergHourTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)hoursTransform.ref().fieldNames()), query, resolver));
        }
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            return (org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)fieldReference.fieldNames()), query, resolver);
        }
        throw new RuntimeException(new StringBuilder(27).append(expr).append(" is not currently supported").toString());
    }

    private org.apache.spark.sql.catalyst.expressions.SortDirection toCatalyst(SortDirection direction) {
        SortDirection sortDirection = direction;
        if (SortDirection.ASCENDING.equals(sortDirection)) {
            return Ascending$.MODULE$;
        }
        if (SortDirection.DESCENDING.equals(sortDirection)) {
            return Descending$.MODULE$;
        }
        throw new MatchError((Object)sortDirection);
    }

    private NullOrdering toCatalyst(org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering) {
        org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering2 = nullOrdering;
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
            return NullsFirst$.MODULE$;
        }
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_LAST.equals(nullOrdering2)) {
            return NullsLast$.MODULE$;
        }
        throw new MatchError((Object)nullOrdering2);
    }

    private static final NamedExpression resolve$1(Seq parts, LogicalPlan query$2, Function2 resolver$2) {
        Option option = query$2.resolve(parts, resolver$2);
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression attr = (NamedExpression)some.value();
            return attr;
        }
        if (None$.MODULE$.equals(option)) {
            String ref = CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(parts).quoted();
            throw new AnalysisException(new StringBuilder(24).append("Cannot resolve '").append(ref).append("' using ").append(query$2.output()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        throw new MatchError((Object)option);
    }

    private DistributionAndOrderingUtils$() {
        MODULE$ = this;
    }
}

