/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Objects;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkColumnarReaderFactory;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.spark.source.SparkRowReaderFactory;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

class SparkBatch
implements Batch {
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final String branch;
    private final SparkReadConf readConf;
    private final Types.StructType groupingKeyType;
    private final List<? extends ScanTaskGroup<?>> taskGroups;
    private final Schema expectedSchema;
    private final boolean caseSensitive;
    private final boolean localityEnabled;
    private final int scanHashCode;

    SparkBatch(JavaSparkContext sparkContext, Table table, SparkReadConf readConf, Types.StructType groupingKeyType, List<? extends ScanTaskGroup<?>> taskGroups, Schema expectedSchema, int scanHashCode) {
        this.sparkContext = sparkContext;
        this.table = table;
        this.branch = readConf.branch();
        this.readConf = readConf;
        this.groupingKeyType = groupingKeyType;
        this.taskGroups = taskGroups;
        this.expectedSchema = expectedSchema;
        this.caseSensitive = readConf.caseSensitive();
        this.localityEnabled = readConf.localityEnabled();
        this.scanHashCode = scanHashCode;
    }

    public InputPartition[] planInputPartitions() {
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(this.table));
        String expectedSchemaString = SchemaParser.toJson((Schema)this.expectedSchema);
        InputPartition[] partitions = new InputPartition[this.taskGroups.size()];
        Tasks.range((int)partitions.length).stopOnFailure().executeWith(this.localityEnabled ? ThreadPools.getWorkerPool() : null).run(index -> {
            partitions[index.intValue()] = new SparkInputPartition(this.groupingKeyType, this.taskGroups.get((int)index), (Broadcast<Table>)tableBroadcast, this.branch, expectedSchemaString, this.caseSensitive, this.localityEnabled);
        });
        return partitions;
    }

    public PartitionReaderFactory createReaderFactory() {
        if (this.useParquetBatchReads()) {
            int batchSize = this.readConf.parquetBatchSize();
            return new SparkColumnarReaderFactory(batchSize);
        }
        if (this.useOrcBatchReads()) {
            int batchSize = this.readConf.orcBatchSize();
            return new SparkColumnarReaderFactory(batchSize);
        }
        return new SparkRowReaderFactory();
    }

    private boolean useParquetBatchReads() {
        return this.readConf.parquetVectorizationEnabled() && this.expectedSchema.columns().size() > 0 && this.expectedSchema.columns().stream().allMatch(c -> c.type().isPrimitiveType()) && this.taskGroups.stream().allMatch(this::supportsParquetBatchReads);
    }

    private boolean supportsParquetBatchReads(ScanTask task) {
        if (task instanceof ScanTaskGroup) {
            ScanTaskGroup taskGroup = (ScanTaskGroup)task;
            return taskGroup.tasks().stream().allMatch(this::supportsParquetBatchReads);
        }
        if (task.isFileScanTask() && !task.isDataTask()) {
            FileScanTask fileScanTask = task.asFileScanTask();
            return ((DataFile)fileScanTask.file()).format() == FileFormat.PARQUET;
        }
        return false;
    }

    private boolean useOrcBatchReads() {
        return this.readConf.orcVectorizationEnabled() && this.taskGroups.stream().allMatch(this::supportsOrcBatchReads);
    }

    private boolean supportsOrcBatchReads(ScanTask task) {
        if (task instanceof ScanTaskGroup) {
            ScanTaskGroup taskGroup = (ScanTaskGroup)task;
            return taskGroup.tasks().stream().allMatch(this::supportsOrcBatchReads);
        }
        if (task.isFileScanTask() && !task.isDataTask()) {
            FileScanTask fileScanTask = task.asFileScanTask();
            return ((DataFile)fileScanTask.file()).format() == FileFormat.ORC && fileScanTask.deletes().isEmpty();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkBatch that = (SparkBatch)o;
        return this.table.name().equals(that.table.name()) && this.scanHashCode == that.scanHashCode;
    }

    public int hashCode() {
        return Objects.hash(this.table.name(), this.scanHashCode);
    }
}

