/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.ImmutableRewritePositionDeleteFiles;
import org.apache.iceberg.actions.RewritePositionDeleteFiles;
import org.apache.iceberg.actions.RewritePositionDeletesCommitManager;
import org.apache.iceberg.actions.RewritePositionDeletesGroup;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Queues;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.math.IntMath;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.spark.actions.BaseSnapshotUpdateSparkAction;
import org.apache.iceberg.spark.actions.SparkBinPackPositionDeletesRewriter;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.Tasks;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewritePositionDeleteFilesSparkAction
extends BaseSnapshotUpdateSparkAction<RewritePositionDeleteFilesSparkAction>
implements RewritePositionDeleteFiles {
    private static final Logger LOG = LoggerFactory.getLogger(RewritePositionDeleteFilesSparkAction.class);
    private static final Set<String> VALID_OPTIONS = ImmutableSet.of((Object)"max-concurrent-file-group-rewrites", (Object)"partial-progress.enabled", (Object)"partial-progress.max-commits", (Object)"rewrite-job-order");
    private static final RewritePositionDeleteFiles.Result EMPTY_RESULT = ImmutableRewritePositionDeleteFiles.Result.builder().build();
    private final Table table;
    private final SparkBinPackPositionDeletesRewriter rewriter;
    private Expression filter = Expressions.alwaysTrue();
    private int maxConcurrentFileGroupRewrites;
    private int maxCommits;
    private boolean partialProgressEnabled;
    private RewriteJobOrder rewriteJobOrder;

    RewritePositionDeleteFilesSparkAction(SparkSession spark, Table table) {
        super(spark);
        this.table = table;
        this.rewriter = new SparkBinPackPositionDeletesRewriter(this.spark(), table);
    }

    @Override
    protected RewritePositionDeleteFilesSparkAction self() {
        return this;
    }

    public RewritePositionDeleteFilesSparkAction filter(Expression expression) {
        this.filter = Expressions.and((Expression)this.filter, (Expression)expression);
        return this;
    }

    public RewritePositionDeleteFiles.Result execute() {
        if (this.table.currentSnapshot() == null) {
            LOG.info("Nothing found to rewrite in empty table {}", (Object)this.table.name());
            return EMPTY_RESULT;
        }
        this.validateAndInitOptions();
        StructLikeMap<List<List<PositionDeletesScanTask>>> fileGroupsByPartition = this.planFileGroups();
        RewriteExecutionContext ctx = new RewriteExecutionContext(fileGroupsByPartition);
        if (ctx.totalGroupCount() == 0) {
            LOG.info("Nothing found to rewrite in {}", (Object)this.table.name());
            return EMPTY_RESULT;
        }
        Stream<RewritePositionDeletesGroup> groupStream = this.toGroupStream(ctx, (Map<StructLike, List<List<PositionDeletesScanTask>>>)fileGroupsByPartition);
        if (this.partialProgressEnabled) {
            return this.doExecuteWithPartialProgress(ctx, groupStream, this.commitManager());
        }
        return this.doExecute(ctx, groupStream, this.commitManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructLikeMap<List<List<PositionDeletesScanTask>>> planFileGroups() {
        CloseableIterable<PositionDeletesScanTask> fileTasks = this.planFiles();
        try {
            Types.StructType partitionType = Partitioning.partitionType((Table)this.table);
            StructLikeMap<List<PositionDeletesScanTask>> fileTasksByPartition = this.groupByPartition(partitionType, (Iterable<PositionDeletesScanTask>)fileTasks);
            StructLikeMap<List<List<PositionDeletesScanTask>>> structLikeMap = this.fileGroupsByPartition(fileTasksByPartition);
            return structLikeMap;
        }
        finally {
            try {
                fileTasks.close();
            }
            catch (IOException io) {
                LOG.error("Cannot properly close file iterable while planning for rewrite", (Throwable)io);
            }
        }
    }

    private CloseableIterable<PositionDeletesScanTask> planFiles() {
        Table deletesTable = MetadataTableUtils.createMetadataTableInstance((Table)this.table, (MetadataTableType)MetadataTableType.POSITION_DELETES);
        PositionDeletesTable.PositionDeletesBatchScan scan = (PositionDeletesTable.PositionDeletesBatchScan)deletesTable.newBatchScan();
        return CloseableIterable.transform((CloseableIterable)((BatchScan)scan.baseTableFilter(this.filter).ignoreResiduals()).planFiles(), task -> (PositionDeletesScanTask)task);
    }

    private StructLikeMap<List<PositionDeletesScanTask>> groupByPartition(Types.StructType partitionType, Iterable<PositionDeletesScanTask> tasks) {
        StructLikeMap filesByPartition = StructLikeMap.create((Types.StructType)partitionType);
        for (PositionDeletesScanTask task : tasks) {
            StructLike coerced = this.coercePartition(task, partitionType);
            List partitionTasks = (List)filesByPartition.get((Object)coerced);
            if (partitionTasks == null) {
                partitionTasks = Lists.newArrayList();
            }
            partitionTasks.add(task);
            filesByPartition.put(coerced, (Object)partitionTasks);
        }
        return filesByPartition;
    }

    private StructLikeMap<List<List<PositionDeletesScanTask>>> fileGroupsByPartition(StructLikeMap<List<PositionDeletesScanTask>> filesByPartition) {
        return filesByPartition.transformValues(this::planFileGroups);
    }

    private List<List<PositionDeletesScanTask>> planFileGroups(List<PositionDeletesScanTask> tasks) {
        return ImmutableList.copyOf((Iterable)this.rewriter.planFileGroups(tasks));
    }

    private RewritePositionDeletesGroup rewriteDeleteFiles(RewriteExecutionContext ctx, RewritePositionDeletesGroup fileGroup) {
        String desc = this.jobDesc(fileGroup, ctx);
        Set addedFiles = this.withJobGroupInfo(this.newJobGroupInfo("REWRITE-POSITION-DELETES", desc), () -> this.rewriter.rewrite(fileGroup.tasks()));
        fileGroup.setOutputFiles(addedFiles);
        LOG.info("Rewrite position deletes ready to be committed - {}", (Object)desc);
        return fileGroup;
    }

    private ExecutorService rewriteService() {
        return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(this.maxConcurrentFileGroupRewrites, new ThreadFactoryBuilder().setNameFormat("Rewrite-Position-Delete-Service-%d").build())));
    }

    private RewritePositionDeletesCommitManager commitManager() {
        return new RewritePositionDeletesCommitManager(this.table);
    }

    private RewritePositionDeleteFiles.Result doExecute(RewriteExecutionContext ctx, Stream<RewritePositionDeletesGroup> groupStream, RewritePositionDeletesCommitManager commitManager) {
        ExecutorService rewriteService = this.rewriteService();
        ConcurrentLinkedQueue rewrittenGroups = Queues.newConcurrentLinkedQueue();
        Tasks.Builder rewriteTaskBuilder = Tasks.foreach(groupStream).executeWith(rewriteService).stopOnFailure().noRetry().onFailure((fileGroup, exception) -> LOG.warn("Failure during rewrite process for group {}", (Object)fileGroup.info(), (Object)exception));
        try {
            rewriteTaskBuilder.run(fileGroup -> rewrittenGroups.add(this.rewriteDeleteFiles(ctx, (RewritePositionDeletesGroup)fileGroup)));
        }
        catch (Exception e) {
            LOG.error("Cannot complete rewrite, {} is not enabled and one of the file set groups failed to be rewritten. This error occurred during the writing of new files, not during the commit process. This indicates something is wrong that doesn't involve conflicts with other Iceberg operations. Enabling {} may help in this case but the root cause should be investigated. Cleaning up {} groups which finished being written.", new Object[]{"partial-progress.enabled", "partial-progress.enabled", rewrittenGroups.size(), e});
            Tasks.foreach((Iterable)rewrittenGroups).suppressFailureWhenFinished().run(arg_0 -> ((RewritePositionDeletesCommitManager)commitManager).abort(arg_0));
            throw e;
        }
        finally {
            rewriteService.shutdown();
        }
        try {
            commitManager.commitOrClean((Set)Sets.newHashSet((Iterable)rewrittenGroups));
        }
        catch (CommitFailedException | ValidationException e) {
            String errorMessage = String.format("Cannot commit rewrite because of a ValidationException or CommitFailedException. This usually means that this rewrite has conflicted with another concurrent Iceberg operation. To reduce the likelihood of conflicts, set %s which will break up the rewrite into multiple smaller commits controlled by %s. Separate smaller rewrite commits can succeed independently while any commits that conflict with another Iceberg operation will be ignored. This mode will create additional snapshots in the table history, one for each commit.", "partial-progress.enabled", "partial-progress.max-commits");
            throw new RuntimeException(errorMessage, e);
        }
        List rewriteResults = rewrittenGroups.stream().map(RewritePositionDeletesGroup::asResult).collect(Collectors.toList());
        return ImmutableRewritePositionDeleteFiles.Result.builder().rewriteResults(rewriteResults).build();
    }

    private RewritePositionDeleteFiles.Result doExecuteWithPartialProgress(RewriteExecutionContext ctx, Stream<RewritePositionDeletesGroup> groupStream, RewritePositionDeletesCommitManager commitManager) {
        ExecutorService rewriteService = this.rewriteService();
        int groupsPerCommit = IntMath.divide((int)ctx.totalGroupCount(), (int)this.maxCommits, (RoundingMode)RoundingMode.CEILING);
        RewritePositionDeletesCommitManager.CommitService commitService = commitManager.service(groupsPerCommit);
        commitService.start();
        Tasks.foreach(groupStream).suppressFailureWhenFinished().executeWith(rewriteService).noRetry().onFailure((fileGroup, exception) -> LOG.error("Failure during rewrite group {}", (Object)fileGroup.info(), (Object)exception)).run(fileGroup -> commitService.offer((Object)this.rewriteDeleteFiles(ctx, (RewritePositionDeletesGroup)fileGroup)));
        rewriteService.shutdown();
        commitService.close();
        List commitResults = commitService.results();
        if (commitResults.size() == 0) {
            LOG.error("{} is true but no rewrite commits succeeded. Check the logs to determine why the individual commits failed. If this is persistent it may help to increase {} which will break the rewrite operation into smaller commits.", (Object)"partial-progress.enabled", (Object)"partial-progress.max-commits");
        }
        List rewriteResults = commitResults.stream().map(RewritePositionDeletesGroup::asResult).collect(Collectors.toList());
        return ImmutableRewritePositionDeleteFiles.Result.builder().rewriteResults(rewriteResults).build();
    }

    private Stream<RewritePositionDeletesGroup> toGroupStream(RewriteExecutionContext ctx, Map<StructLike, List<List<PositionDeletesScanTask>>> groupsByPartition) {
        return groupsByPartition.entrySet().stream().filter((? super T e) -> ((List)e.getValue()).size() != 0).flatMap(e -> {
            StructLike partition = (StructLike)e.getKey();
            List scanGroups = (List)e.getValue();
            return scanGroups.stream().map(tasks -> this.newRewriteGroup(ctx, partition, (List<PositionDeletesScanTask>)tasks));
        }).sorted(RewritePositionDeletesGroup.comparator((RewriteJobOrder)this.rewriteJobOrder));
    }

    private RewritePositionDeletesGroup newRewriteGroup(RewriteExecutionContext ctx, StructLike partition, List<PositionDeletesScanTask> tasks) {
        int globalIndex = ctx.currentGlobalIndex();
        int partitionIndex = ctx.currentPartitionIndex(partition);
        ImmutableRewritePositionDeleteFiles.FileGroupInfo info = ImmutableRewritePositionDeleteFiles.FileGroupInfo.builder().globalIndex(globalIndex).partitionIndex(partitionIndex).partition(partition).build();
        return new RewritePositionDeletesGroup((RewritePositionDeleteFiles.FileGroupInfo)info, tasks);
    }

    private void validateAndInitOptions() {
        HashSet validOptions = Sets.newHashSet((Iterable)this.rewriter.validOptions());
        validOptions.addAll(VALID_OPTIONS);
        HashSet invalidKeys = Sets.newHashSet(this.options().keySet());
        invalidKeys.removeAll(validOptions);
        Preconditions.checkArgument((boolean)invalidKeys.isEmpty(), (String)"Cannot use options %s, they are not supported by the action or the rewriter %s", (Object)invalidKeys, (Object)this.rewriter.description());
        this.rewriter.init(this.options());
        this.maxConcurrentFileGroupRewrites = PropertyUtil.propertyAsInt(this.options(), (String)"max-concurrent-file-group-rewrites", (int)5);
        this.maxCommits = PropertyUtil.propertyAsInt(this.options(), (String)"partial-progress.max-commits", (int)10);
        this.partialProgressEnabled = PropertyUtil.propertyAsBoolean(this.options(), (String)"partial-progress.enabled", (boolean)false);
        this.rewriteJobOrder = RewriteJobOrder.fromName((String)PropertyUtil.propertyAsString(this.options(), (String)"rewrite-job-order", (String)REWRITE_JOB_ORDER_DEFAULT));
        Preconditions.checkArgument((this.maxConcurrentFileGroupRewrites >= 1 ? 1 : 0) != 0, (String)"Cannot set %s to %s, the value must be positive.", (Object)"max-concurrent-file-group-rewrites", (int)this.maxConcurrentFileGroupRewrites);
        Preconditions.checkArgument((!this.partialProgressEnabled || this.maxCommits > 0 ? 1 : 0) != 0, (String)"Cannot set %s to %s, the value must be positive when %s is true", (Object)"partial-progress.max-commits", (Object)this.maxCommits, (Object)"partial-progress.enabled");
    }

    private String jobDesc(RewritePositionDeletesGroup group, RewriteExecutionContext ctx) {
        StructLike partition = group.info().partition();
        if (partition.size() > 0) {
            return String.format("Rewriting %d position delete files (%s, file group %d/%d, %s (%d/%d)) in %s", group.rewrittenDeleteFiles().size(), this.rewriter.description(), group.info().globalIndex(), ctx.totalGroupCount(), partition, group.info().partitionIndex(), ctx.groupsInPartition(partition), this.table.name());
        }
        return String.format("Rewriting %d position files (%s, file group %d/%d) in %s", group.rewrittenDeleteFiles().size(), this.rewriter.description(), group.info().globalIndex(), ctx.totalGroupCount(), this.table.name());
    }

    private StructLike coercePartition(PositionDeletesScanTask task, Types.StructType partitionType) {
        return PartitionUtil.coercePartition((Types.StructType)partitionType, (PartitionSpec)task.spec(), (StructLike)task.partition());
    }

    static class RewriteExecutionContext {
        private final StructLikeMap<Integer> numGroupsByPartition;
        private final int totalGroupCount;
        private final Map<StructLike, Integer> partitionIndexMap;
        private final AtomicInteger groupIndex;

        RewriteExecutionContext(StructLikeMap<List<List<PositionDeletesScanTask>>> fileTasksByPartition) {
            this.numGroupsByPartition = fileTasksByPartition.transformValues(List::size);
            this.totalGroupCount = this.numGroupsByPartition.values().stream().reduce(Integer::sum).orElse(0);
            this.partitionIndexMap = Maps.newConcurrentMap();
            this.groupIndex = new AtomicInteger(1);
        }

        public int currentGlobalIndex() {
            return this.groupIndex.getAndIncrement();
        }

        public int currentPartitionIndex(StructLike partition) {
            return this.partitionIndexMap.merge(partition, 1, Integer::sum);
        }

        public int groupsInPartition(StructLike partition) {
            return (Integer)this.numGroupsByPartition.get((Object)partition);
        }

        public int totalGroupCount() {
            return this.totalGroupCount;
        }
    }
}

