/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.math.LongMath;
import org.apache.iceberg.spark.PruneColumnsWithoutReordering;
import org.apache.iceberg.spark.SparkFixupTimestampType;
import org.apache.iceberg.spark.SparkFixupTypes;
import org.apache.iceberg.spark.SparkTypeToType;
import org.apache.iceberg.spark.SparkTypeVisitor;
import org.apache.iceberg.spark.TypeToSparkType;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class SparkSchemaUtil {
    private SparkSchemaUtil() {
    }

    public static Schema schemaForTable(SparkSession spark, String name) {
        StructType sparkType = spark.table(name).schema();
        Type converted = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType));
        return new Schema(converted.asNestedType().asStructType().fields());
    }

    public static PartitionSpec specForTable(SparkSession spark, String name) throws AnalysisException {
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((char)'.').limit(2).split((CharSequence)name));
        String db = parts.size() == 1 ? "default" : (String)parts.get(0);
        String table = (String)parts.get(parts.size() == 1 ? 0 : 1);
        PartitionSpec spec = SparkSchemaUtil.identitySpec(SparkSchemaUtil.schemaForTable(spark, name), spark.catalog().listColumns(db, table).collectAsList());
        return spec == null ? PartitionSpec.unpartitioned() : spec;
    }

    public static StructType convert(Schema schema) {
        return (StructType)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeToSparkType());
    }

    public static DataType convert(Type type) {
        return (DataType)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToSparkType());
    }

    public static Schema convert(StructType sparkType) {
        return SparkSchemaUtil.convert(sparkType, false);
    }

    public static Schema convert(StructType sparkType, boolean useTimestampWithoutZone) {
        Type converted = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType));
        Schema schema = new Schema(converted.asNestedType().asStructType().fields());
        if (useTimestampWithoutZone) {
            schema = SparkFixupTimestampType.fixup(schema);
        }
        return schema;
    }

    public static Type convert(DataType sparkType) {
        return SparkTypeVisitor.visit(sparkType, new SparkTypeToType());
    }

    public static Schema convert(Schema baseSchema, StructType sparkType) {
        return SparkSchemaUtil.convert(baseSchema, sparkType, true);
    }

    public static Schema convert(Schema baseSchema, StructType sparkType, boolean caseSensitive) {
        Types.StructType struct = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType)).asStructType();
        Schema schema = TypeUtil.reassignIds((Schema)new Schema(struct.fields()), (Schema)baseSchema, (boolean)caseSensitive);
        return SparkFixupTypes.fixup(schema, baseSchema);
    }

    public static Schema convertWithFreshIds(Schema baseSchema, StructType sparkType) {
        return SparkSchemaUtil.convertWithFreshIds(baseSchema, sparkType, true);
    }

    public static Schema convertWithFreshIds(Schema baseSchema, StructType sparkType, boolean caseSensitive) {
        Types.StructType struct = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType)).asStructType();
        Schema schema = TypeUtil.reassignOrRefreshIds((Schema)new Schema(struct.fields()), (Schema)baseSchema, (boolean)caseSensitive);
        return SparkFixupTypes.fixup(schema, baseSchema);
    }

    public static Schema prune(Schema schema, StructType requestedType) {
        return new Schema(((Type)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)new PruneColumnsWithoutReordering(requestedType, (Set<Integer>)ImmutableSet.of()))).asNestedType().asStructType().fields());
    }

    public static Schema prune(Schema schema, StructType requestedType, List<Expression> filters) {
        Set filterRefs = Binder.boundReferences((Types.StructType)schema.asStruct(), filters, (boolean)true);
        return new Schema(((Type)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)new PruneColumnsWithoutReordering(requestedType, filterRefs))).asNestedType().asStructType().fields());
    }

    public static Schema prune(Schema schema, StructType requestedType, Expression filter, boolean caseSensitive) {
        Set filterRefs = Binder.boundReferences((Types.StructType)schema.asStruct(), Collections.singletonList(filter), (boolean)caseSensitive);
        return new Schema(((Type)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)new PruneColumnsWithoutReordering(requestedType, filterRefs))).asNestedType().asStructType().fields());
    }

    private static PartitionSpec identitySpec(Schema schema, Collection<Column> columns) {
        ArrayList names = Lists.newArrayList();
        for (Column column : columns) {
            if (!column.isPartition()) continue;
            names.add(column.name());
        }
        return SparkSchemaUtil.identitySpec(schema, names);
    }

    private static PartitionSpec identitySpec(Schema schema, List<String> partitionNames) {
        if (partitionNames == null || partitionNames.isEmpty()) {
            return null;
        }
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        for (String partitionName : partitionNames) {
            builder.identity(partitionName);
        }
        return builder.build();
    }

    public static long estimateSize(StructType tableSchema, long totalRecords) {
        long result;
        if (totalRecords == Long.MAX_VALUE) {
            return totalRecords;
        }
        try {
            result = LongMath.checkedMultiply((long)tableSchema.defaultSize(), (long)totalRecords);
        }
        catch (ArithmeticException e) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    public static void validateMetadataColumnReferences(Schema tableSchema, Schema readSchema) {
        List conflictingColumnNames = readSchema.columns().stream().map(Types.NestedField::name).filter(name -> MetadataColumns.isMetadataColumn((String)name) && tableSchema.findField(name) != null).collect(Collectors.toList());
        ValidationException.check((boolean)conflictingColumnNames.isEmpty(), (String)"Table column names conflict with names reserved for Iceberg metadata columns: %s.\nPlease, use ALTER TABLE statements to rename the conflicting table columns.", (Object[])new Object[]{conflictingColumnNames});
    }

    public static Map<Integer, String> indexQuotedNameById(Schema schema) {
        Function<String, String> quotingFunc = name -> String.format("`%s`", name.replace("`", "``"));
        return TypeUtil.indexQuotedNameById((Types.StructType)schema.asStruct(), quotingFunc);
    }
}

