/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.amoro.utils.MixedDataFiles;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.FileMetadata;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinReader;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeMap;

public class StatisticsFileUtil {
    public static WriterBuilder writerBuilder(Table table) {
        return new WriterBuilder(table);
    }

    public static Reader reader(Table table) {
        return new Reader(table);
    }

    public static StatisticsFile copyToSnapshot(StatisticsFile statisticsFile, long snapshotId) {
        return new GenericStatisticsFile(snapshotId, statisticsFile.path(), statisticsFile.fileSizeInBytes(), statisticsFile.fileFooterSizeInBytes(), statisticsFile.blobMetadata());
    }

    public static List<StatisticsFile> getStatisticsFiles(Table table, long snapshotId, String type) {
        List statisticsFiles = table.statisticsFiles();
        if (statisticsFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return statisticsFiles.stream().filter(s -> s.blobMetadata().stream().anyMatch(b -> type.equals(b.type()))).collect(Collectors.groupingBy(StatisticsFile::snapshotId)).get(snapshotId);
    }

    public static <T> PartitionDataSerializer<T> createPartitionDataSerializer(PartitionSpec spec, Class<T> valueClassType) {
        return new PartitionDataSerializer<T>(spec, valueClassType);
    }

    public static class WriterBuilder {
        private final Table table;
        private Long snapshotId;

        private WriterBuilder(Table table) {
            this.table = table;
        }

        public WriterBuilder withSnapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Writer build() {
            Snapshot snapshot = this.snapshotId == null ? this.table.currentSnapshot() : this.table.snapshot(this.snapshotId.longValue());
            Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (String)"Cannot find snapshot with id %s", (Object)this.snapshotId);
            return new Writer(this.table, snapshot.snapshotId(), snapshot.sequenceNumber());
        }
    }

    public static class Reader {
        private final Table table;

        private Reader(Table table) {
            this.table = table;
        }

        public <T> List<T> read(StatisticsFile statisticsFile, String type, DataSerializer<T> deserializer) {
            return this.read(statisticsFile, type).stream().map(deserializer::deserialize).collect(Collectors.toList());
        }

        public List<ByteBuffer> read(StatisticsFile statisticsFile, String type) {
            ArrayList arrayList;
            block8: {
                PuffinReader puffin = Puffin.read((InputFile)this.table.io().newInputFile(statisticsFile.path())).build();
                try {
                    FileMetadata fileMetadata = puffin.fileMetadata();
                    List blobs = fileMetadata.blobs().stream().filter(b -> type.equals(b.type())).collect(Collectors.toList());
                    arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)puffin.readAll(blobs), Pair::second));
                    if (puffin == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (puffin != null) {
                            try {
                                puffin.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                puffin.close();
            }
            return arrayList;
        }
    }

    public static class PartitionDataSerializer<T>
    implements DataSerializer<StructLikeMap<T>> {
        private final PartitionSpec spec;
        private final Class<T> valueClassType;

        public PartitionDataSerializer(PartitionSpec spec, Class<T> valueClassType) {
            this.spec = spec;
            this.valueClassType = valueClassType;
        }

        @Override
        public ByteBuffer serialize(StructLikeMap<T> data) {
            String value;
            HashMap stringKeyMap = Maps.newHashMap();
            for (StructLike pd : data.keySet()) {
                String pathLike = this.spec.partitionToPath(pd);
                stringKeyMap.put(pathLike, data.get((Object)pd));
            }
            try {
                value = new ObjectMapper().writeValueAsString((Object)stringKeyMap);
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
            return ByteBuffer.wrap(value.getBytes());
        }

        @Override
        public StructLikeMap<T> deserialize(ByteBuffer buffer) {
            try {
                StructLikeMap results = StructLikeMap.create((Types.StructType)this.spec.partitionType());
                ObjectMapper objectMapper = new ObjectMapper();
                MapLikeType mapLikeType = objectMapper.getTypeFactory().constructMapLikeType(Map.class, String.class, this.valueClassType);
                Map map = (Map)objectMapper.readValue(new String(buffer.array()), (JavaType)mapLikeType);
                for (String key : map.keySet()) {
                    if (this.spec.isUnpartitioned()) {
                        results.put(TablePropertyUtil.EMPTY_STRUCT, map.get(key));
                        continue;
                    }
                    GenericRecord partitionData = MixedDataFiles.data(this.spec, key);
                    results.put((StructLike)partitionData, map.get(key));
                }
                return results;
            }
            catch (JsonProcessingException e) {
                throw new UnsupportedOperationException("Failed to decode partition data ", e);
            }
        }
    }

    public static interface DataSerializer<T> {
        public ByteBuffer serialize(T var1);

        public T deserialize(ByteBuffer var1);
    }

    public static class Writer {
        private final long snapshotId;
        private final long sequenceNumber;
        private final OutputFile outputFile;
        private final PuffinWriter puffinWriter;
        private boolean closed = false;

        private Writer(Table table, long snapshotId, long sequenceNumber) {
            this.snapshotId = snapshotId;
            this.sequenceNumber = sequenceNumber;
            this.outputFile = table.io().newOutputFile(table.location() + "/data/puffin/" + snapshotId + "-" + UUID.randomUUID() + ".puffin");
            this.puffinWriter = Puffin.write((OutputFile)this.outputFile).build();
        }

        public Writer add(Blob blob) {
            this.checkNotClosed();
            this.puffinWriter.add(blob);
            return this;
        }

        public Writer add(String type, ByteBuffer blobData) {
            this.add(new Blob(type, Collections.emptyList(), this.snapshotId, this.sequenceNumber, blobData));
            return this;
        }

        public <T> Writer add(String type, T data, DataSerializer<T> serializer) {
            return this.add(type, serializer.serialize(data));
        }

        public StatisticsFile complete() {
            this.checkNotClosed();
            try {
                this.puffinWriter.finish();
                List blobMetadata = this.puffinWriter.writtenBlobsMetadata();
                long fileSize = this.puffinWriter.fileSize();
                long footerSize = this.puffinWriter.footerSize();
                List collect = blobMetadata.stream().map(GenericBlobMetadata::from).collect(Collectors.toList());
                GenericStatisticsFile genericStatisticsFile = new GenericStatisticsFile(this.snapshotId, this.outputFile.location(), fileSize, footerSize, collect);
                return genericStatisticsFile;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.close();
            }
        }

        private void checkNotClosed() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot operate on a closed writer");
        }

        private void close() {
            if (!this.closed) {
                this.closed = true;
                try {
                    this.puffinWriter.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

