/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.List;
import java.util.function.Predicate;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.StatisticsFileUtil;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.StructLikeMap;

public class MixedTableUtil {
    public static final String BLOB_TYPE_OPTIMIZED_SEQUENCE = "optimized-sequence";
    public static final String BLOB_TYPE_BASE_OPTIMIZED_TIME = "base-optimized-time";
    public static final String BLOB_TYPE_OPTIMIZED_SEQUENCE_EXIST = "optimized-sequence.exist";
    public static final String BLOB_TYPE_BASE_OPTIMIZED_TIME_EXIST = "base-optimized-time.exist";

    public static UnkeyedTable baseStore(MixedTable mixedTable) {
        if (mixedTable.isKeyedTable()) {
            return mixedTable.asKeyedTable().baseTable();
        }
        return mixedTable.asUnkeyedTable();
    }

    public static String tableRootLocation(MixedTable mixedTable) {
        String tableRootLocation = TableFormat.ICEBERG != mixedTable.format() && mixedTable.isUnkeyedTable() ? TableFileUtil.getFileDir(mixedTable.location()) : mixedTable.location();
        return tableRootLocation;
    }

    public static StructLikeMap<Long> readOptimizedSequence(KeyedTable table) {
        return MixedTableUtil.readWithLegacy(table.baseTable(), null, BLOB_TYPE_OPTIMIZED_SEQUENCE);
    }

    public static StructLikeMap<Long> readOptimizedSequence(KeyedTable table, long snapshotId) {
        return MixedTableUtil.readWithLegacy(table.baseTable(), snapshotId, BLOB_TYPE_OPTIMIZED_SEQUENCE);
    }

    public static StructLikeMap<Long> readBaseOptimizedTime(KeyedTable table) {
        return MixedTableUtil.readWithLegacy(table.baseTable(), null, BLOB_TYPE_BASE_OPTIMIZED_TIME);
    }

    public static StructLikeMap<Long> readBaseOptimizedTime(KeyedTable table, long snapshotId) {
        return MixedTableUtil.readWithLegacy(table.baseTable(), snapshotId, BLOB_TYPE_BASE_OPTIMIZED_TIME);
    }

    private static StructLikeMap<Long> readWithLegacy(UnkeyedTable table, Long snapshotId, String type) {
        StructLikeMap<Long> result;
        if (snapshotId == null) {
            Snapshot snapshot = table.currentSnapshot();
            if (snapshot == null) {
                return MixedTableUtil.readLegacyPartitionProperties(table, type);
            }
            snapshotId = snapshot.snapshotId();
        }
        return (result = MixedTableUtil.readFromStatisticsFile(table, snapshotId, type)) != null ? result : MixedTableUtil.readLegacyPartitionProperties(table, type);
    }

    private static StructLikeMap<Long> readFromStatisticsFile(UnkeyedTable table, long snapshotId, String type) {
        Snapshot snapshot = table.snapshot(snapshotId);
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (String)"Snapshot %s not found", (long)snapshotId);
        Snapshot snapshotContainsType = MixedTableUtil.findLatestValidSnapshot(table, snapshotId, MixedTableUtil.isTypeExist(type));
        if (snapshotContainsType == null) {
            return null;
        }
        List<StatisticsFile> statisticsFiles = StatisticsFileUtil.getStatisticsFiles(table, snapshotContainsType.snapshotId(), type);
        Preconditions.checkState((!statisticsFiles.isEmpty() ? 1 : 0) != 0, (String)"Statistics file not found for snapshot %s", (long)snapshotId);
        Preconditions.checkState((statisticsFiles.size() == 1 ? 1 : 0) != 0, (String)"There should be only one statistics file for snapshot %s", (long)snapshotId);
        List<Long> result = StatisticsFileUtil.reader(table).read(statisticsFiles.get(0), type, StatisticsFileUtil.createPartitionDataSerializer(table.spec(), Long.class));
        if (result.size() != 1) {
            throw new IllegalStateException("There should be only one partition data in statistics file for blob type " + type);
        }
        return (StructLikeMap)result.get(0);
    }

    public static Snapshot findLatestValidSnapshot(Table table, long currentSnapshotId, Predicate<Snapshot> condition) {
        Long snapshotId = currentSnapshotId;
        while (snapshotId != null && table.snapshot(snapshotId.longValue()) != null) {
            Snapshot snapshot = table.snapshot(snapshotId.longValue());
            if (condition.test(snapshot)) {
                return snapshot;
            }
            snapshotId = snapshot.parentId();
        }
        return null;
    }

    @VisibleForTesting
    public static Predicate<Snapshot> isTypeExist(String type) {
        switch (type) {
            case "optimized-sequence": {
                return snapshot -> snapshot.summary().containsKey(BLOB_TYPE_OPTIMIZED_SEQUENCE_EXIST);
            }
            case "base-optimized-time": {
                return snapshot -> snapshot.summary().containsKey(BLOB_TYPE_BASE_OPTIMIZED_TIME_EXIST);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private static StructLikeMap<Long> readLegacyPartitionProperties(UnkeyedTable table, String type) {
        switch (type) {
            case "optimized-sequence": {
                return TablePropertyUtil.getPartitionLongProperties(table, "max-txId");
            }
            case "base-optimized-time": {
                return TablePropertyUtil.getPartitionLongProperties(table, "base-op-time");
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static PartitionSpec getMixedTablePartitionSpecById(MixedTable mixedTable, int specId) {
        if (mixedTable.format() == TableFormat.ICEBERG) {
            return (PartitionSpec)mixedTable.asUnkeyedTable().specs().get(specId);
        }
        PartitionSpec spec = mixedTable.spec();
        if (spec.specId() != specId) {
            throw new IllegalArgumentException("Partition spec id " + specId + " not found in table " + mixedTable.name());
        }
        return spec;
    }
}

