/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.scan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.amoro.IcebergFileEntry;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.ManifestEntryFields;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEntriesScan {
    private static final Logger LOG = LoggerFactory.getLogger(TableEntriesScan.class);
    private final Table table;
    private final Long snapshotId;
    private final Expression dataFilter;
    private final boolean aliveEntry;
    private final boolean allFileContent;
    private final boolean includeColumnStats;
    private final Set<FileContent> validFileContent;
    private final MetadataTableType metadataTableType;
    private final Schema schema;
    private final Long fromSequence;
    private Table entriesTable;
    private InclusiveMetricsEvaluator lazyMetricsEvaluator = null;
    private Map<String, Integer> lazyIndexOfDataFileType;
    private Map<String, Integer> lazyIndexOfEntryType;

    public static Builder builder(Table table) {
        return new Builder(table);
    }

    private TableEntriesScan(Table table, Long snapshotId, Expression dataFilter, boolean aliveEntry, Set<FileContent> validFileContent, boolean includeColumnStats, Schema schema, MetadataTableType metadataTableType, Long fromSequence) {
        this.table = table;
        this.dataFilter = dataFilter;
        this.aliveEntry = aliveEntry;
        this.allFileContent = validFileContent.containsAll(Arrays.asList(FileContent.values()));
        this.validFileContent = validFileContent;
        this.snapshotId = snapshotId;
        this.includeColumnStats = includeColumnStats;
        this.schema = schema;
        this.metadataTableType = metadataTableType;
        this.fromSequence = fromSequence;
    }

    public CloseableIterable<IcebergFileEntry> entries() {
        TableScan tableScan = this.getMetadataTable().newScan();
        if (this.snapshotId != null) {
            tableScan = tableScan.useSnapshot(this.snapshotId.longValue());
        }
        if (this.schema != null) {
            tableScan = (TableScan)tableScan.project(this.schema);
        }
        CloseableIterable manifestFileScanTasks = tableScan.planFiles();
        CloseableIterable entries = CloseableIterable.concat(this.entriesOfManifest((CloseableIterable<FileScanTask>)manifestFileScanTasks));
        CloseableIterable allEntries = CloseableIterable.transform((CloseableIterable)entries, entry -> {
            StructLike fileRecord;
            FileContent fileContent;
            Long sequence = (Long)entry.get(this.entryFieldIndex(ManifestEntryFields.SEQUENCE_NUMBER.name()), Long.class);
            if (this.fromSequence != null && this.fromSequence > sequence) {
                return null;
            }
            ManifestEntryFields.Status status = ManifestEntryFields.Status.of((Integer)entry.get(this.entryFieldIndex(ManifestEntryFields.STATUS.name()), Integer.class));
            if (this.shouldKeep(status, fileContent = this.getFileContent((Integer)(fileRecord = (StructLike)entry.get(this.entryFieldIndex("data_file"), StructLike.class)).get(this.dataFileFieldIndex(DataFile.CONTENT.name()), Integer.class)))) {
                Long snapshotId = (Long)entry.get(this.entryFieldIndex(ManifestEntryFields.SNAPSHOT_ID.name()), Long.class);
                ContentFile contentFile = this.buildContentFile(fileContent, fileRecord);
                if (this.metricsEvaluator().eval(contentFile)) {
                    if (this.needMetrics() && !this.includeColumnStats) {
                        contentFile = (ContentFile)contentFile.copyWithoutStats();
                    }
                    return new IcebergFileEntry(snapshotId, sequence, status, contentFile);
                }
            }
            return null;
        });
        return CloseableIterable.filter((CloseableIterable)allEntries, Objects::nonNull);
    }

    private Table getMetadataTable() {
        if (this.entriesTable == null) {
            this.entriesTable = MetadataTableUtils.createMetadataTableInstance((TableOperations)((HasTableOperations)this.table).operations(), (String)this.table.name(), (String)(this.table.name() + "#" + this.metadataTableType.name()), (MetadataTableType)this.metadataTableType);
        }
        return this.entriesTable;
    }

    private FileContent getFileContent(int contentId) {
        for (FileContent content : FileContent.values()) {
            if (content.id() != contentId) continue;
            return content;
        }
        throw new IllegalArgumentException("not support content id " + contentId);
    }

    private boolean needMetrics() {
        return this.dataFilter != null || this.includeColumnStats;
    }

    private boolean shouldKeep(ManifestEntryFields.Status status, FileContent fileContent) {
        if (this.aliveEntry && status == ManifestEntryFields.Status.DELETED) {
            return false;
        }
        if (this.allFileContent) {
            return true;
        }
        return this.validFileContent != null && this.validFileContent.contains(fileContent);
    }

    private Iterable<CloseableIterable<StructLike>> entriesOfManifest(CloseableIterable<FileScanTask> fileScanTasks) {
        return Iterables.transform(fileScanTasks, task -> {
            assert (task != null);
            return ((DataTask)task).rows();
        });
    }

    private ContentFile<?> buildContentFile(FileContent fileContent, StructLike fileRecord) {
        Object file = fileContent == FileContent.DATA ? this.buildDataFile(fileRecord) : this.buildDeleteFile(fileRecord, fileContent);
        return file;
    }

    private DataFile buildDataFile(StructLike fileRecord) {
        String filePath = (String)fileRecord.get(this.dataFileFieldIndex(DataFile.FILE_PATH.name()), String.class);
        Long fileSize = (Long)fileRecord.get(this.dataFileFieldIndex(DataFile.FILE_SIZE.name()), Long.class);
        Long recordCount = (Long)fileRecord.get(this.dataFileFieldIndex(DataFile.RECORD_COUNT.name()), Long.class);
        String format = (String)fileRecord.get(this.dataFileFieldIndex(DataFile.FILE_FORMAT.name()), String.class);
        PartitionSpec spec = Optional.ofNullable((Integer)fileRecord.get(this.dataFileFieldIndex(DataFile.SPEC_ID.name()), Integer.class)).map(this.table.specs()::get).orElseGet(() -> {
            LOG.info("No specId found for the current fileRecord[%S]", (Object)filePath);
            return this.table.spec();
        });
        DataFiles.Builder builder = DataFiles.builder((PartitionSpec)spec).withPath(filePath).withFileSizeInBytes(fileSize.longValue()).withRecordCount(recordCount.longValue()).withFormat(FileFormat.fromString((String)format));
        if (this.needMetrics()) {
            builder.withMetrics(this.buildMetrics(fileRecord));
        }
        if (spec.isPartitioned()) {
            StructLike partition = (StructLike)fileRecord.get(this.dataFileFieldIndex("partition"), StructLike.class);
            builder.withPartition(partition);
        }
        return builder.build();
    }

    private DeleteFile buildDeleteFile(StructLike fileRecord, FileContent fileContent) {
        String filePath = (String)fileRecord.get(this.dataFileFieldIndex(DataFile.FILE_PATH.name()), String.class);
        Long fileSize = (Long)fileRecord.get(this.dataFileFieldIndex(DataFile.FILE_SIZE.name()), Long.class);
        Long recordCount = (Long)fileRecord.get(this.dataFileFieldIndex(DataFile.RECORD_COUNT.name()), Long.class);
        String format = (String)fileRecord.get(this.dataFileFieldIndex(DataFile.FILE_FORMAT.name()), String.class);
        PartitionSpec spec = Optional.ofNullable((Integer)fileRecord.get(this.dataFileFieldIndex(DataFile.SPEC_ID.name()), Integer.class)).map(this.table.specs()::get).orElseGet(() -> {
            LOG.info("No specId found for the current fileRecord[%S]", (Object)filePath);
            return this.table.spec();
        });
        FileMetadata.Builder builder = FileMetadata.deleteFileBuilder((PartitionSpec)spec).withPath(filePath).withFileSizeInBytes(fileSize.longValue()).withRecordCount(recordCount.longValue()).withFormat(FileFormat.fromString((String)format));
        if (this.needMetrics()) {
            builder.withMetrics(this.buildMetrics(fileRecord));
        }
        if (spec.isPartitioned()) {
            StructLike partition = (StructLike)fileRecord.get(this.dataFileFieldIndex("partition"), StructLike.class);
            builder.withPartition(partition);
        }
        if (fileContent == FileContent.EQUALITY_DELETES) {
            builder.ofEqualityDeletes(new int[0]);
        } else {
            builder.ofPositionDeletes();
        }
        return builder.build();
    }

    private Metrics buildMetrics(StructLike dataFile) {
        return new Metrics((Long)dataFile.get(this.dataFileFieldIndex(DataFile.RECORD_COUNT.name()), Long.class), (Map)dataFile.get(this.dataFileFieldIndex(DataFile.COLUMN_SIZES.name()), Map.class), (Map)dataFile.get(this.dataFileFieldIndex(DataFile.VALUE_COUNTS.name()), Map.class), (Map)dataFile.get(this.dataFileFieldIndex(DataFile.NULL_VALUE_COUNTS.name()), Map.class), (Map)dataFile.get(this.dataFileFieldIndex(DataFile.NAN_VALUE_COUNTS.name()), Map.class), (Map)dataFile.get(this.dataFileFieldIndex(DataFile.LOWER_BOUNDS.name()), Map.class), (Map)dataFile.get(this.dataFileFieldIndex(DataFile.UPPER_BOUNDS.name()), Map.class));
    }

    private int entryFieldIndex(String fieldName) {
        if (this.lazyIndexOfEntryType == null) {
            List fields = this.getMetadataTable().schema().columns();
            HashMap map = Maps.newHashMap();
            for (int i = 0; i < fields.size(); ++i) {
                map.put(((Types.NestedField)fields.get(i)).name(), i);
            }
            this.lazyIndexOfEntryType = map;
        }
        return this.lazyIndexOfEntryType.get(fieldName);
    }

    private int dataFileFieldIndex(String fieldName) {
        if (this.lazyIndexOfDataFileType == null) {
            List fields = this.getMetadataTable().schema().findType("data_file").asStructType().fields();
            HashMap map = Maps.newHashMap();
            for (int i = 0; i < fields.size(); ++i) {
                map.put(((Types.NestedField)fields.get(i)).name(), i);
            }
            this.lazyIndexOfDataFileType = map;
        }
        return this.lazyIndexOfDataFileType.get(fieldName);
    }

    private InclusiveMetricsEvaluator metricsEvaluator() {
        if (this.lazyMetricsEvaluator == null) {
            this.lazyMetricsEvaluator = this.dataFilter != null ? new InclusiveMetricsEvaluator(this.table.spec().schema(), this.dataFilter) : new AlwaysTrueEvaluator(this.table.spec().schema());
        }
        return this.lazyMetricsEvaluator;
    }

    public static class Builder {
        private final Table table;
        private Long snapshotId;
        private Expression dataFilter;
        private boolean aliveEntry = true;
        private boolean includeColumnStats = false;
        private final Set<FileContent> fileContents = Sets.newHashSet();
        private Schema schema;
        private MetadataTableType metadataTableType = MetadataTableType.ENTRIES;
        private Long fromSequence;

        public Builder(Table table) {
            this.table = table;
        }

        public Builder withDataFilter(Expression dataFilter) {
            this.dataFilter = dataFilter;
            return this;
        }

        public Builder withAliveEntry(boolean aliveEntry) {
            this.aliveEntry = aliveEntry;
            return this;
        }

        public Builder includeFileContent(FileContent ... fileContent) {
            this.fileContents.addAll(Arrays.asList(fileContent));
            return this;
        }

        public Builder useSnapshot(long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder includeColumnStats() {
            this.includeColumnStats = true;
            return this;
        }

        public Builder fromSequence(Long fromSequence) {
            this.fromSequence = fromSequence;
            return this;
        }

        public Builder project(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder allEntries() {
            this.metadataTableType = MetadataTableType.ALL_ENTRIES;
            return this;
        }

        public TableEntriesScan build() {
            return new TableEntriesScan(this.table, this.snapshotId, this.dataFilter, this.aliveEntry, this.fileContents, this.includeColumnStats, this.schema, this.metadataTableType, this.fromSequence);
        }
    }

    private static class AlwaysTrueEvaluator
    extends InclusiveMetricsEvaluator {
        public AlwaysTrueEvaluator(Schema schema) {
            super(schema, (Expression)Expressions.alwaysTrue());
        }

        public boolean eval(ContentFile<?> file) {
            return true;
        }
    }
}

