/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.Collections;
import java.util.List;
import org.apache.amoro.op.PartitionTransactionOperation;
import org.apache.amoro.op.RewritePartitions;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.amoro.utils.StatisticsFileUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;

public class KeyedPartitionRewrite
extends PartitionTransactionOperation
implements RewritePartitions {
    protected List<DataFile> addFiles = Lists.newArrayList();
    private Long optimizedSequence;

    public KeyedPartitionRewrite(KeyedTable keyedTable) {
        super(keyedTable);
    }

    @Override
    public KeyedPartitionRewrite addDataFile(DataFile dataFile) {
        this.addFiles.add(dataFile);
        return this;
    }

    @Override
    public KeyedPartitionRewrite updateOptimizedSequenceDynamically(long sequence) {
        this.optimizedSequence = sequence;
        return this;
    }

    @Override
    protected List<StatisticsFile> apply(Transaction transaction) {
        PartitionSpec spec = transaction.table().spec();
        if (this.addFiles.isEmpty()) {
            return Collections.emptyList();
        }
        Preconditions.checkNotNull((Object)this.optimizedSequence, (Object)"optimized sequence must be set.");
        Preconditions.checkArgument((this.optimizedSequence > 0L ? 1 : 0) != 0, (Object)"optimized sequence must > 0.");
        ReplacePartitions replacePartitions = transaction.newReplacePartitions();
        replacePartitions.set("optimized-sequence.exist", "true");
        this.addFiles.forEach(arg_0 -> ((ReplacePartitions)replacePartitions).addFile(arg_0));
        replacePartitions.commit();
        CreateSnapshotEvent newSnapshot = (CreateSnapshotEvent)replacePartitions.updateEvent();
        StructLikeMap<Long> oldOptimizedSequence = MixedTableUtil.readOptimizedSequence(this.keyedTable);
        StructLikeMap optimizedSequence = StructLikeMap.create((Types.StructType)spec.partitionType());
        if (oldOptimizedSequence != null) {
            optimizedSequence.putAll(oldOptimizedSequence);
        }
        this.addFiles.forEach(f -> optimizedSequence.put(f.partition(), (Object)this.optimizedSequence));
        Table table = transaction.table();
        StatisticsFile statisticsFile = StatisticsFileUtil.writerBuilder(table).withSnapshotId(newSnapshot.snapshotId()).build().add("optimized-sequence", optimizedSequence, StatisticsFileUtil.createPartitionDataSerializer(table.spec(), Long.class)).complete();
        return Collections.singletonList(statisticsFile);
    }

    @Override
    protected boolean isEmptyCommit() {
        return this.addFiles.isEmpty();
    }
}

