/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.log.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import javax.annotation.Nullable;
import org.apache.amoro.log.data.LogMapData;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public interface LogArrayData {
    public boolean getBoolean(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public LocalDateTime getTimestamp(int var1);

    public Instant getInstant(int var1);

    public String getString(int var1);

    public byte[] getBinary(int var1);

    public BigDecimal getDecimal(int var1);

    public Object getStruct(int var1);

    public LogArrayData getArray(int var1);

    public LogMapData getMap(int var1);

    public boolean isNullAt(int var1);

    public int size();

    public static ElementGetter createElementGetter(Types.NestedField field) {
        ElementGetter elementGetter;
        Type elementType = field.type();
        switch (elementType.typeId()) {
            case BOOLEAN: {
                elementGetter = LogArrayData::getBoolean;
                break;
            }
            case INTEGER: 
            case DATE: {
                elementGetter = LogArrayData::getInt;
                break;
            }
            case LONG: 
            case TIME: {
                elementGetter = LogArrayData::getLong;
                break;
            }
            case FLOAT: {
                elementGetter = LogArrayData::getFloat;
                break;
            }
            case DOUBLE: {
                elementGetter = LogArrayData::getDouble;
                break;
            }
            case TIMESTAMP: {
                Types.TimestampType timestamp = (Types.TimestampType)elementType;
                if (timestamp.shouldAdjustToUTC()) {
                    elementGetter = LogArrayData::getInstant;
                    break;
                }
                elementGetter = LogArrayData::getTimestamp;
                break;
            }
            case STRING: {
                elementGetter = LogArrayData::getString;
                break;
            }
            case UUID: 
            case FIXED: 
            case BINARY: {
                elementGetter = LogArrayData::getBinary;
                break;
            }
            case DECIMAL: {
                elementGetter = LogArrayData::getDecimal;
                break;
            }
            case LIST: {
                elementGetter = LogArrayData::getArray;
                break;
            }
            case MAP: {
                elementGetter = LogArrayData::getMap;
                break;
            }
            case STRUCT: {
                elementGetter = LogArrayData::getStruct;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not Support to parse type: " + elementType);
            }
        }
        if (field.isRequired()) {
            return elementGetter;
        }
        return (array, pos) -> {
            if (array.isNullAt(pos)) {
                return null;
            }
            return elementGetter.getElementOrNull(array, pos);
        };
    }

    public static interface ElementGetter
    extends Serializable {
        @Nullable
        public Object getElementOrNull(LogArrayData var1, int var2);
    }

    public static interface Factory
    extends Serializable {
        public LogArrayData create(Object[] var1);
    }
}

