/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.log;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.log.Converter;
import org.apache.amoro.log.LogData;
import org.apache.amoro.log.TimeFormats;
import org.apache.amoro.log.data.LogArrayData;
import org.apache.amoro.log.data.LogMapData;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class LogDataToJsonConverters
implements Serializable {
    private static final long serialVersionUID = 6851339012836496637L;

    public static <T> LogDataToJsonConverter<T> createConverter(Type type, LogData.FieldGetterFactory<T> fieldGetterFactory) {
        return LogDataToJsonConverters.wrapIntoNullableConverter(LogDataToJsonConverters.createNotNullConverter(type, fieldGetterFactory));
    }

    private static <T> LogDataToJsonConverter<T> createNotNullConverter(Type type, LogData.FieldGetterFactory<T> fieldGetterFactory) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().booleanNode(((Boolean)source).booleanValue());
            }
            case INTEGER: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().numberNode(((Integer)source).intValue());
            }
            case LONG: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().numberNode(((Long)source).longValue());
            }
            case FLOAT: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().numberNode(((Float)source).floatValue());
            }
            case DOUBLE: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().numberNode(((Double)source).doubleValue());
            }
            case DATE: {
                return LogDataToJsonConverters.createDateConverter();
            }
            case TIME: {
                return LogDataToJsonConverters.createTimeConverter();
            }
            case TIMESTAMP: {
                Types.TimestampType timestamp = (Types.TimestampType)type;
                if (timestamp.shouldAdjustToUTC()) {
                    return LogDataToJsonConverters.createTimestampWithLocalZone();
                }
                return LogDataToJsonConverters.createTimestampConverter();
            }
            case STRING: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().textNode(source.toString());
            }
            case UUID: 
            case FIXED: 
            case BINARY: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().binaryNode((byte[])source);
            }
            case DECIMAL: {
                return (source, context) -> ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().numberNode((BigDecimal)source);
            }
            case LIST: {
                return LogDataToJsonConverters.createListConverter(type, fieldGetterFactory);
            }
            case MAP: {
                return LogDataToJsonConverters.createMapConverter(type, fieldGetterFactory);
            }
            case STRUCT: {
                return LogDataToJsonConverters.createStructConverter(type, fieldGetterFactory);
            }
        }
        throw new UnsupportedOperationException("Not Support to parse type: " + type);
    }

    private static <T> LogDataToJsonConverter<T> createMapConverter(Type type, LogData.FieldGetterFactory<T> fieldGetterFactory) {
        Types.MapType map = type.asNestedType().asMapType();
        Types.NestedField keyField = map.field(map.keyId());
        Types.NestedField valueField = map.field(map.valueId());
        LogDataToJsonConverter valueConverter = LogDataToJsonConverters.createConverter(valueField.type(), fieldGetterFactory);
        LogArrayData.ElementGetter valueGetter = LogArrayData.createElementGetter(valueField);
        LogArrayData.ElementGetter keyGetter = LogArrayData.createElementGetter(keyField);
        return (source, context) -> {
            ObjectNode node;
            if (((LogDataToJsonConverter.FormatConverterContext)context).node == null || ((LogDataToJsonConverter.FormatConverterContext)context).node.isNull()) {
                node = ((LogDataToJsonConverter.FormatConverterContext)context).mapper.createObjectNode();
            } else {
                node = (ObjectNode)((LogDataToJsonConverter.FormatConverterContext)context).node;
                node.removeAll();
            }
            LogMapData mapData = (LogMapData)source;
            LogArrayData keyArray = mapData.keyArray();
            LogArrayData valueArray = mapData.valueArray();
            int numElements = mapData.size();
            for (int i = 0; i < numElements; ++i) {
                if (keyArray.isNullAt(i)) {
                    throw new RuntimeException("JSON format doesn't support to serialize map data with null keys. ");
                }
                Object obj = keyGetter.getElementOrNull(keyArray, i);
                String fieldName = null != obj ? obj.toString() : null;
                Object value = valueGetter.getElementOrNull(valueArray, i);
                LogDataToJsonConverter.FormatConverterContext subContext = new LogDataToJsonConverter.FormatConverterContext(((LogDataToJsonConverter.FormatConverterContext)context).mapper, node.get(fieldName));
                node.set(fieldName, (JsonNode)valueConverter.convert(value, subContext));
            }
            return node;
        };
    }

    private static <T> LogDataToJsonConverter<T> createListConverter(Type type, LogData.FieldGetterFactory<T> fieldGetterFactory) {
        Types.ListType list = type.asNestedType().asListType();
        Types.NestedField elementField = list.field(list.elementId());
        LogDataToJsonConverter elementConverter = LogDataToJsonConverters.createConverter(elementField.type(), fieldGetterFactory);
        LogArrayData.ElementGetter elementGetter = LogArrayData.createElementGetter(elementField);
        return (source, context) -> {
            ArrayNode node;
            if (((LogDataToJsonConverter.FormatConverterContext)context).node == null || ((LogDataToJsonConverter.FormatConverterContext)context).node.isNull()) {
                node = ((LogDataToJsonConverter.FormatConverterContext)context).mapper.createArrayNode();
            } else {
                node = (ArrayNode)((LogDataToJsonConverter.FormatConverterContext)context).node;
                node.removeAll();
            }
            LogArrayData array = (LogArrayData)source;
            int numElements = array.size();
            LogDataToJsonConverter.FormatConverterContext subContext = new LogDataToJsonConverter.FormatConverterContext(((LogDataToJsonConverter.FormatConverterContext)context).mapper, null);
            for (int i = 0; i < numElements; ++i) {
                Object element = elementGetter.getElementOrNull(array, i);
                node.add((JsonNode)elementConverter.convert(element, subContext));
            }
            return node;
        };
    }

    private static <T> LogDataToJsonConverter<T> createTimestampWithLocalZone() {
        return (source, context) -> {
            Instant instant = (Instant)source;
            return ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().textNode(TimeFormats.ISO8601_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT.format(instant.atOffset(ZoneOffset.UTC)));
        };
    }

    private static <T> LogDataToJsonConverter<T> createTimestampConverter() {
        return (source, context) -> {
            LocalDateTime localDateTime = (LocalDateTime)source;
            return ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().textNode(TimeFormats.SQL_TIMESTAMP_FORMAT.format(localDateTime));
        };
    }

    private static <T> LogDataToJsonConverter<T> createDateConverter() {
        return (source, context) -> {
            int days = (Integer)source;
            LocalDate date = LocalDate.ofEpochDay(days);
            return ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().textNode(DateTimeFormatter.ISO_LOCAL_DATE.format(date));
        };
    }

    private static <T> LogDataToJsonConverter<T> createTimeConverter() {
        return (source, context) -> {
            long nanosSecond = (Long)source;
            LocalTime time = LocalTime.ofNanoOfDay(nanosSecond);
            return ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().textNode(TimeFormats.SQL_TIME_FORMAT.format(time));
        };
    }

    private static <T> LogDataToJsonConverter<T> createStructConverter(Type type, LogData.FieldGetterFactory<T> fieldGetterFactory) {
        Types.StructType structType = type.asNestedType().asStructType();
        List fields = structType.fields();
        Type[] fieldTypes = (Type[])fields.stream().map(Types.NestedField::type).toArray(Type[]::new);
        String[] fieldNames = (String[])fields.stream().map(Types.NestedField::name).toArray(String[]::new);
        List fieldConverterList = Arrays.stream(fieldTypes).map(type1 -> LogDataToJsonConverters.createConverter(type1, fieldGetterFactory)).collect(Collectors.toList());
        int fieldCount = fields.size();
        ArrayList fieldGetterList = new ArrayList();
        for (int i = 0; i < fieldCount; ++i) {
            fieldGetterList.add(fieldGetterFactory.createFieldGetter(fieldTypes[i], i));
        }
        return (source, context) -> {
            ObjectNode node = ((LogDataToJsonConverter.FormatConverterContext)context).node == null || ((LogDataToJsonConverter.FormatConverterContext)context).node.isNull() ? ((LogDataToJsonConverter.FormatConverterContext)context).mapper.createObjectNode() : (ObjectNode)((LogDataToJsonConverter.FormatConverterContext)context).node;
            Object actualValue = source;
            for (int i = 0; i < fieldCount; ++i) {
                String fieldName = fieldNames[i];
                try {
                    LogDataToJsonConverter.FormatConverterContext subContext = new LogDataToJsonConverter.FormatConverterContext(((LogDataToJsonConverter.FormatConverterContext)context).mapper, node.get(fieldName));
                    Object field = ((LogData.FieldGetter)fieldGetterList.get(i)).getFieldOrNull(actualValue, i);
                    node.set(fieldName, (JsonNode)((LogDataToJsonConverter)fieldConverterList.get(i)).convert(field, subContext));
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Fail to serialize at field: %s.", fieldName), t);
                }
            }
            return node;
        };
    }

    private static <T> LogDataToJsonConverter<T> wrapIntoNullableConverter(LogDataToJsonConverter<T> converter) {
        return (source, context) -> {
            if (source == null) {
                return ((LogDataToJsonConverter.FormatConverterContext)context).mapper.getNodeFactory().nullNode();
            }
            return (JsonNode)converter.convert(source, context);
        };
    }

    static interface LogDataToJsonConverter<T>
    extends Converter<Object, JsonNode, FormatConverterContext, T> {

        public static class FormatConverterContext
        implements Serializable {
            private static final long serialVersionUID = 109329249465478511L;
            private final transient JsonNode node;
            private final ObjectMapper mapper;

            public FormatConverterContext(ObjectMapper jsonMapper, JsonNode node) {
                this.mapper = jsonMapper;
                this.node = node;
            }
        }
    }
}

